/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.thrift;

import com.thinkaurelius.titan.CassandraStorageSetup;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import com.thinkaurelius.titan.graphdb.SpeedTestSchema;
import com.thinkaurelius.titan.graphdb.TitanGraphSpeedTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.testcategory.PerformanceTests;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={PerformanceTests.class})
public class ThriftGraphSpeedTest
extends TitanGraphSpeedTest {
    private static StandardTitanGraph graph;
    private static SpeedTestSchema schema;
    private static final Logger log;

    public ThriftGraphSpeedTest() throws BackendException {
        super(CassandraStorageSetup.getCassandraThriftGraphConfiguration(ThriftGraphSpeedTest.class.getSimpleName()));
    }

    @BeforeClass
    public static void beforeClass() {
        CassandraStorageSetup.startCleanEmbedded();
    }

    protected StandardTitanGraph getGraph() throws BackendException {
        if (null == graph) {
            GraphDatabaseConfiguration graphconfig = new GraphDatabaseConfiguration((ReadConfiguration)this.conf);
            graphconfig.getBackend().clearStorage();
            log.debug("Cleared backend storage");
            graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)this.conf);
            this.initializeGraph((TitanGraph)graph);
        }
        return graph;
    }

    protected SpeedTestSchema getSchema() {
        if (null == schema) {
            schema = SpeedTestSchema.get();
        }
        return schema;
    }

    static {
        log = LoggerFactory.getLogger(ThriftGraphSpeedTest.class);
    }
}

