/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.paranamer.ant;

import com.thoughtworks.paranamer.generator.QdoxParanamerGenerator;
import com.thoughtworks.qdox.JavaDocBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ParanamerTask
extends Task {
    private String srcdir = null;
    private boolean srcdirSet = false;
    private String classdir = this.srcdir;
    private boolean classdirSet = false;
    private String includes = "**/*.java";
    private boolean includesSet = false;
    private String excludes = "";
    private boolean excludesSet = false;
    private Collection<FileSet> filesets = new Vector<FileSet>();

    public void execute() throws BuildException {
        if (this.srcdir == null) {
            this.srcdir = this.getProject().getBaseDir().getPath();
        }
        if (this.filesets.isEmpty() || this.srcdirSet || this.includesSet || this.excludesSet) {
            FileSet set = new FileSet();
            set.setDir(this.getProject().resolveFile(this.srcdir));
            for (String o : Arrays.asList(this.includes.split(","))) {
                set.appendIncludes(new String[]{o.trim()});
            }
            for (String o : Arrays.asList(this.excludes.split(","))) {
                set.appendExcludes(new String[]{o.trim()});
            }
            this.filesets.add(set);
        }
        Iterator<FileSet> i$ = this.filesets.iterator();
        while (i$.hasNext()) {
            FileSet fileset;
            FileSet fs = fileset = i$.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] includedFiles = ds.getIncludedFiles();
            this.log("Generating parameter names for" + includedFiles.length + " files in " + ds.getBasedir());
            Iterator<String> i$2 = Arrays.asList(includedFiles).iterator();
            while (i$2.hasNext()) {
                String o;
                String file = o = i$2.next();
                JavaDocBuilder builder = new JavaDocBuilder();
                try {
                    builder.addSource(new File(ds.getBasedir(), file));
                    if (this.classdirSet) {
                        this.makeQdoxParanamerGenerator().processClasses(builder.getClasses(), this.classdir);
                        continue;
                    }
                    this.makeQdoxParanamerGenerator().processClasses(builder.getClasses(), ds.getBasedir().getPath());
                }
                catch (IOException exception) {
                    throw new BuildException("Error processing: " + file + ". " + exception.getMessage());
                }
            }
        }
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setSrcdir(String srcdir) {
        this.srcdir = srcdir;
        this.srcdirSet = true;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
        this.includesSet = true;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
        this.excludesSet = true;
    }

    public void setClassdir(String classdir) {
        this.classdir = classdir;
        this.classdirSet = true;
    }

    protected QdoxParanamerGenerator makeQdoxParanamerGenerator() {
        return new QdoxParanamerGenerator();
    }
}

