/*
 * Decompiled with CFR 0.152.
 */
package com.tumblr.jumblr;

import com.tumblr.jumblr.request.RequestBuilder;
import com.tumblr.jumblr.types.Blog;
import com.tumblr.jumblr.types.Post;
import com.tumblr.jumblr.types.User;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JumblrClient {
    private RequestBuilder requestBuilder = new RequestBuilder(this);
    private String apiKey;

    public JumblrClient() {
    }

    public JumblrClient(String consumerKey, String consumerSecret) {
        this();
        this.requestBuilder.setConsumer(consumerKey, consumerSecret);
        this.apiKey = consumerKey;
    }

    public JumblrClient(String consumerKey, String consumerSecret, String token, String tokenSecret) {
        this(consumerKey, consumerSecret);
        this.setToken(token, tokenSecret);
    }

    public void setToken(String token, String tokenSecret) {
        this.requestBuilder.setToken(token, tokenSecret);
    }

    public User user() {
        return this.requestBuilder.get("/user/info", null).getUser();
    }

    public List<Post> userDashboard(Map<String, ?> options) {
        return this.requestBuilder.get("/user/dashboard", options).getPosts();
    }

    public List<Post> userDashboard() {
        return this.userDashboard(null);
    }

    public List<Blog> userFollowing(Map<String, ?> options) {
        return this.requestBuilder.get("/user/following", options).getBlogs();
    }

    public List<Blog> userFollowing() {
        return this.userFollowing(null);
    }

    public List<Post> tagged(String tag, Map<String, ?> options) {
        if (options == null) {
            options = new HashMap();
        }
        Map<String, Object> soptions = JumblrClient.safeOptionMap(options);
        soptions.put("api_key", this.apiKey);
        soptions.put("tag", tag);
        return this.requestBuilder.get("/tagged", soptions).getTaggedPosts();
    }

    public List<Post> tagged(String tag) {
        return this.tagged(tag, null);
    }

    public Blog blogInfo(String blogName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("api_key", this.apiKey);
        return this.requestBuilder.get(JumblrClient.blogPath(blogName, "/info"), map).getBlog();
    }

    public List<User> blogFollowers(String blogName, Map<String, ?> options) {
        return this.requestBuilder.get(JumblrClient.blogPath(blogName, "/followers"), options).getUsers();
    }

    public List<User> blogFollowers(String blogName) {
        return this.blogFollowers(blogName, null);
    }

    public List<Post> blogLikes(String blogName, Map<String, ?> options) {
        if (options == null) {
            options = new HashMap();
        }
        Map<String, Object> soptions = JumblrClient.safeOptionMap(options);
        soptions.put("api_key", this.apiKey);
        return this.requestBuilder.get(JumblrClient.blogPath(blogName, "/likes"), soptions).getLikedPosts();
    }

    public List<Post> blogLikes(String blogName) {
        return this.blogLikes(blogName, null);
    }

    public List<Post> blogPosts(String blogName, Map<String, ?> options) {
        if (options == null) {
            options = new HashMap();
        }
        Map<String, Object> soptions = JumblrClient.safeOptionMap(options);
        soptions.put("api_key", this.apiKey);
        String path = "/posts";
        if (soptions.containsKey("type")) {
            path = path + "/" + soptions.get("type").toString();
            soptions.remove("type");
        }
        return this.requestBuilder.get(JumblrClient.blogPath(blogName, path), soptions).getPosts();
    }

    public List<Post> blogPosts(String blogName) {
        return this.blogPosts(blogName, null);
    }

    public Post blogPost(String blogName, Long postId) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("id", postId.toString());
        List<Post> posts = this.blogPosts(blogName, options);
        return posts.size() > 0 ? posts.get(0) : null;
    }

    public List<Post> blogQueuedPosts(String blogName, Map<String, ?> options) {
        return this.requestBuilder.get(JumblrClient.blogPath(blogName, "/posts/queue"), options).getPosts();
    }

    public List<Post> blogQueuedPosts(String blogName) {
        return this.blogQueuedPosts(blogName, null);
    }

    public List<Post> blogDraftPosts(String blogName, Map<String, ?> options) {
        return this.requestBuilder.get(JumblrClient.blogPath(blogName, "/posts/draft"), options).getPosts();
    }

    public List<Post> blogDraftPosts(String blogName) {
        return this.blogDraftPosts(blogName, null);
    }

    public List<Post> blogSubmissions(String blogName, Map<String, ?> options) {
        return this.requestBuilder.get(JumblrClient.blogPath(blogName, "/posts/submission"), options).getPosts();
    }

    public List<Post> blogSubmissions(String blogName) {
        return this.blogSubmissions(blogName, null);
    }

    public List<Post> userLikes(Map<String, ?> options) {
        return this.requestBuilder.get("/user/likes", options).getLikedPosts();
    }

    public List<Post> userLikes() {
        return this.userLikes(null);
    }

    public String blogAvatar(String blogName, Integer size) {
        String pathExt = size == null ? "" : "/" + size.toString();
        return this.requestBuilder.getRedirectUrl(JumblrClient.blogPath(blogName, "/avatar" + pathExt));
    }

    public String blogAvatar(String blogName) {
        return this.blogAvatar(blogName, null);
    }

    public void like(Long postId, String reblogKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", postId.toString());
        map.put("reblog_key", reblogKey);
        this.requestBuilder.post("/user/like", map);
    }

    public void unlike(Long postId, String reblogKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", postId.toString());
        map.put("reblog_key", reblogKey);
        this.requestBuilder.post("/user/unlike", map);
    }

    public void follow(String blogName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", JumblrClient.blogUrl(blogName));
        this.requestBuilder.post("/user/follow", map);
    }

    public void unfollow(String blogName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", JumblrClient.blogUrl(blogName));
        this.requestBuilder.post("/user/unfollow", map);
    }

    public void postDelete(String blogName, Long postId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", postId.toString());
        this.requestBuilder.post(JumblrClient.blogPath(blogName, "/post/delete"), map);
    }

    public Post postReblog(String blogName, Long postId, String reblogKey, Map<String, ?> options) {
        if (options == null) {
            options = new HashMap();
        }
        Map<String, Object> soptions = JumblrClient.safeOptionMap(options);
        soptions.put("id", postId.toString());
        soptions.put("reblog_key", reblogKey);
        return this.requestBuilder.post(JumblrClient.blogPath(blogName, "/post/reblog"), soptions).getPost();
    }

    public Post postReblog(String blogName, Long postId, String reblogKey) {
        return this.postReblog(blogName, postId, reblogKey, null);
    }

    public void postEdit(String blogName, Long id, Map<String, ?> detail) throws IOException {
        Map<String, Object> sdetail = JumblrClient.safeOptionMap(detail);
        sdetail.put("id", id);
        this.requestBuilder.postMultipart(JumblrClient.blogPath(blogName, "/post/edit"), sdetail);
    }

    public Long postCreate(String blogName, Map<String, ?> detail) throws IOException {
        return this.requestBuilder.postMultipart(JumblrClient.blogPath(blogName, "/post"), detail).getId();
    }

    public <T extends Post> T newPost(String blogName, Class<T> klass) throws IllegalAccessException, InstantiationException {
        Post post = (Post)klass.newInstance();
        post.setClient(this);
        post.setBlogName(blogName);
        return (T)post;
    }

    private static String blogPath(String blogName, String extPath) {
        String bn = blogName.contains(".") ? blogName : blogName + ".tumblr.com";
        return "/blog/" + bn + extPath;
    }

    private static String blogUrl(String blogName) {
        return blogName.contains(".") ? blogName : blogName + ".tumblr.com";
    }

    public void setRequestBuilder(RequestBuilder builder) {
        this.requestBuilder = builder;
    }

    private static Map<String, Object> safeOptionMap(Map<String, ?> map) {
        HashMap<String, Object> mod = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            mod.put(key, map.get(key));
        }
        return mod;
    }
}

