/*
 * Decompiled with CFR 0.152.
 */
package com.tumblr.jumblr.exceptions;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import org.scribe.model.Response;

public class JumblrException
extends RuntimeException {
    private final int responseCode;
    private String message;
    private List<String> errors;

    public JumblrException(Response response) {
        this.responseCode = response.getCode();
        String body = response.getBody();
        JsonParser parser = new JsonParser();
        try {
            JsonObject object = parser.parse(body).getAsJsonObject();
            this.extractMessage(object);
            this.extractErrors(object);
        }
        catch (JsonParseException ex) {
            this.message = body;
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    private void extractErrors(JsonObject object) {
        JsonObject response;
        try {
            response = object.getAsJsonObject("response");
        }
        catch (ClassCastException ex) {
            return;
        }
        if (response == null) {
            return;
        }
        JsonArray e = response.getAsJsonArray("errors");
        if (e == null) {
            return;
        }
        this.errors = new ArrayList<String>(e.size());
        for (int i = 0; i < e.size(); ++i) {
            this.errors.add(e.get(i).getAsString());
        }
    }

    private void extractMessage(JsonObject object) {
        JsonPrimitive msg;
        JsonObject meta = object.getAsJsonObject("meta");
        if (meta != null && (msg = meta.getAsJsonPrimitive("msg")) != null) {
            this.message = msg.getAsString();
            return;
        }
        JsonPrimitive error = object.getAsJsonPrimitive("error");
        if (error != null) {
            this.message = error.getAsString();
            return;
        }
        this.message = "Unknown Error";
    }
}

