/*
 * Decompiled with CFR 0.152.
 */
package com.tumblr.jumblr.request;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.scribe.model.OAuthRequest;

public class MultipartConverter {
    private String boundary;
    private OAuthRequest originalRequest;
    private Integer bodyLength = 0;
    private List<Object> responsePieces;

    public MultipartConverter(OAuthRequest request, Map<String, ?> bodyMap) throws IOException {
        this.originalRequest = request;
        this.boundary = Long.toHexString(System.nanoTime());
        this.computeBody(bodyMap);
    }

    public OAuthRequest getRequest() {
        OAuthRequest request = new OAuthRequest(this.originalRequest.getVerb(), this.originalRequest.getUrl());
        request.addHeader("Authorization", (String)this.originalRequest.getHeaders().get("Authorization"));
        request.addHeader("Content-Type", "multipart/form-data, boundary=" + this.boundary);
        request.addHeader("Content-length", this.bodyLength.toString());
        request.addPayload(this.complexPayload());
        return request;
    }

    private byte[] complexPayload() {
        int used = 0;
        byte[] payload = new byte[this.bodyLength.intValue()];
        for (Object piece : this.responsePieces) {
            byte[] local = piece instanceof StringBuilder ? ((StringBuilder)piece).toString().getBytes() : (byte[])piece;
            System.arraycopy(local, 0, payload, used, local.length);
            used += local.length;
        }
        return payload;
    }

    private void addResponsePiece(byte[] arr) {
        this.responsePieces.add(arr);
        this.bodyLength = this.bodyLength + arr.length;
    }

    private void addResponsePiece(StringBuilder builder) {
        this.responsePieces.add(builder);
        this.bodyLength = this.bodyLength + builder.toString().getBytes().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeBody(Map<String, ?> bodyMap) throws IOException {
        this.responsePieces = new ArrayList<Object>();
        StringBuilder message = new StringBuilder();
        message.append("Content-Type: multipart/form-data; boundary=").append(this.boundary).append("\r\n\r\n");
        for (String key : bodyMap.keySet()) {
            Object object = bodyMap.get(key);
            if (object == null) continue;
            if (object instanceof File) {
                File f = (File)object;
                String mime = URLConnection.guessContentTypeFromName(f.getName());
                FilterInputStream dis = null;
                byte[] result = new byte[(int)f.length()];
                try {
                    dis = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
                    ((DataInputStream)dis).readFully(result);
                }
                finally {
                    dis.close();
                }
                message.append("--").append(this.boundary).append("\r\n");
                message.append("Content-Disposition: form-data; name=\"").append(key).append("\"; filename=\"").append(f.getName()).append("\"\r\n");
                message.append("Content-Type: ").append(mime).append("\r\n\r\n");
                this.addResponsePiece(message);
                this.addResponsePiece(result);
                message = new StringBuilder("\r\n");
                continue;
            }
            message.append("--").append(this.boundary).append("\r\n");
            message.append("Content-Disposition: form-data; name=\"").append(key).append("\"\r\n\r\n");
            message.append(object.toString()).append("\r\n");
        }
        message.append("--").append(this.boundary).append("--\r\n");
        this.addResponsePiece(message);
    }
}

