/*
 * Decompiled with CFR 0.152.
 */
package com.tumblr.jumblr.responses;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.tumblr.jumblr.JumblrClient;
import com.tumblr.jumblr.responses.PostDeserializer;
import com.tumblr.jumblr.types.Blog;
import com.tumblr.jumblr.types.Post;
import com.tumblr.jumblr.types.Resource;
import com.tumblr.jumblr.types.User;
import java.util.List;

public class ResponseWrapper {
    private JsonElement response;
    private JumblrClient client;

    public void setClient(JumblrClient client) {
        this.client = client;
    }

    public User getUser() {
        return this.get("user", User.class);
    }

    public Blog getBlog() {
        return this.get("blog", Blog.class);
    }

    public Post getPost() {
        return this.get("post", Post.class);
    }

    public Long getId() {
        JsonObject object = (JsonObject)this.response;
        return object.get("id").getAsLong();
    }

    public List<Post> getPosts() {
        Gson gson = this.gsonParser();
        JsonObject object = (JsonObject)this.response;
        List l = (List)gson.fromJson(object.get("posts"), new TypeToken<List<Post>>(){}.getType());
        for (Post e : l) {
            e.setClient(this.client);
        }
        return l;
    }

    public List<User> getUsers() {
        Gson gson = this.gsonParser();
        JsonObject object = (JsonObject)this.response;
        List l = (List)gson.fromJson(object.get("users"), new TypeToken<List<User>>(){}.getType());
        for (User e : l) {
            e.setClient(this.client);
        }
        return l;
    }

    public List<Post> getLikedPosts() {
        Gson gson = this.gsonParser();
        JsonObject object = (JsonObject)this.response;
        List l = (List)gson.fromJson(object.get("liked_posts"), new TypeToken<List<Post>>(){}.getType());
        for (Post e : l) {
            e.setClient(this.client);
        }
        return l;
    }

    public List<Post> getTaggedPosts() {
        Gson gson = this.gsonParser();
        List l = (List)gson.fromJson((JsonElement)this.response.getAsJsonArray(), new TypeToken<List<Post>>(){}.getType());
        for (Post e : l) {
            e.setClient(this.client);
        }
        return l;
    }

    public List<Blog> getBlogs() {
        Gson gson = this.gsonParser();
        JsonObject object = (JsonObject)this.response;
        List l = (List)gson.fromJson(object.get("blogs"), new TypeToken<List<Blog>>(){}.getType());
        for (Blog e : l) {
            e.setClient(this.client);
        }
        return l;
    }

    private <T extends Resource> T get(String field, Class<T> k) {
        Gson gson = this.gsonParser();
        JsonObject object = (JsonObject)this.response;
        Resource e = (Resource)gson.fromJson(object.get(field).toString(), k);
        e.setClient(this.client);
        return (T)e;
    }

    private Gson gsonParser() {
        return new GsonBuilder().registerTypeAdapter(Post.class, (Object)new PostDeserializer()).create();
    }
}

