/*
 * Decompiled with CFR 0.152.
 */
package com.tumblr.jumblr.types;

import com.tumblr.jumblr.types.Resource;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class Post
extends Resource {
    private Long id;
    private String reblog_key;
    private String blog_name;
    private String post_url;
    private String type;
    private Long timestamp;
    private String state;
    private String format;
    private String date;
    private List<String> tags;
    private Boolean bookmarklet;
    private Boolean mobile;
    private String source_url;
    private String source_title;
    private Boolean liked;
    private String slug;
    private Long reblogged_from_id;
    private String reblogged_from_name;

    public Boolean isLiked() {
        return this.liked;
    }

    public String getSourceUrl() {
        return this.source_url;
    }

    public Boolean isMobile() {
        return this.mobile;
    }

    public Boolean isBookmarklet() {
        return this.bookmarklet;
    }

    public String getFormat() {
        return this.format;
    }

    public String getState() {
        return this.state;
    }

    public String getPostUrl() {
        return this.post_url;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getDateGMT() {
        return this.date;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public Long getId() {
        return this.id;
    }

    public String getBlogName() {
        return this.blog_name;
    }

    public String getReblogKey() {
        return this.reblog_key;
    }

    public Long getRebloggedFromId() {
        return this.reblogged_from_id;
    }

    public String getRebloggedFromName() {
        return this.reblogged_from_name;
    }

    public void delete() {
        this.client.postDelete(this.blog_name, this.id);
    }

    public Post reblog(String blogName, Map<String, ?> options) {
        return this.client.postReblog(blogName, this.id, this.reblog_key, options);
    }

    public Post reblog(String blogName) {
        return this.reblog(blogName, null);
    }

    public void like() {
        this.client.like(this.id, this.reblog_key);
    }

    public void unlike() {
        this.client.unlike(this.id, this.reblog_key);
    }

    public void setBlogName(String blogName) {
        this.blog_name = blogName;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public void setDate(String dateString) {
        this.date = dateString;
    }

    public void setDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.setDate(df.format(date));
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tag);
    }

    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    public void save() throws IOException {
        if (this.id == null) {
            this.id = this.client.postCreate(this.blog_name, this.detail());
        } else {
            this.client.postEdit(this.blog_name, this.id, this.detail());
        }
    }

    protected Map<String, Object> detail() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state", this.state);
        map.put("tags", this.getTagString());
        map.put("format", this.format);
        map.put("slug", this.slug);
        map.put("date", this.date);
        return map;
    }

    private String getTagString() {
        return this.tags == null ? "" : StringUtils.join((Object[])this.tags.toArray(new String[0]), (String)",");
    }

    public String toString() {
        return "[" + this.getClass().getName() + " (" + this.blog_name + ":" + this.id + ")]";
    }
}

