/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.tracker;

import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.Torrent;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackedPeer
extends Peer {
    private static final Logger logger = LoggerFactory.getLogger(TrackedPeer.class);
    private static final int FRESH_TIME_SECONDS = 30;
    private long uploaded;
    private long downloaded;
    private long left;
    private Torrent torrent;
    private PeerState state;
    private Date lastAnnounce;

    public TrackedPeer(Torrent torrent, String ip, int port, ByteBuffer peerId) {
        super(ip, port, peerId);
        this.torrent = torrent;
        this.state = PeerState.UNKNOWN;
        this.lastAnnounce = null;
        this.uploaded = 0L;
        this.downloaded = 0L;
        this.left = 0L;
    }

    public void update(PeerState state, long uploaded, long downloaded, long left) {
        if (PeerState.STARTED.equals((Object)state) && left == 0L) {
            state = PeerState.COMPLETED;
        }
        if (!state.equals((Object)this.state)) {
            logger.info("Peer {} {} download of {}.", new Object[]{this, state.name().toLowerCase(), this.torrent});
        }
        this.state = state;
        this.lastAnnounce = new Date();
        this.uploaded = uploaded;
        this.downloaded = downloaded;
        this.left = left;
    }

    public boolean isCompleted() {
        return PeerState.COMPLETED.equals((Object)this.state);
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public long getLeft() {
        return this.left;
    }

    public boolean isFresh() {
        return this.lastAnnounce != null && this.lastAnnounce.getTime() + 30000L > new Date().getTime();
    }

    public BEValue toBEValue() throws UnsupportedEncodingException {
        HashMap<String, BEValue> peer = new HashMap<String, BEValue>();
        if (this.hasPeerId()) {
            peer.put("peer id", new BEValue(this.getPeerId().array()));
        }
        peer.put("ip", new BEValue(this.getIp(), "ISO-8859-1"));
        peer.put("port", new BEValue(this.getPort()));
        return new BEValue(peer);
    }

    public static enum PeerState {
        UNKNOWN,
        STARTED,
        COMPLETED,
        STOPPED;

    }
}

