/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import java.awt.image.RGBImageFilter;

public class BrightnessContrastFilter
extends RGBImageFilter {
    private final int[] LUT;

    public BrightnessContrastFilter() {
        this(0.3f, 0.3f);
    }

    public BrightnessContrastFilter(float pBrightness, float pContrast) {
        this.canFilterIndexColorModel = true;
        this.LUT = BrightnessContrastFilter.createLUT(pBrightness, pContrast);
    }

    private static int[] createLUT(float pBrightness, float pContrast) {
        int[] lut = new int[256];
        double contrast = pContrast > 0.0f ? Math.pow(pContrast, 7.0) * 127.0 : (double)pContrast;
        double brightness = (double)pBrightness + 1.0;
        for (int i = 0; i < 256; ++i) {
            lut[i] = BrightnessContrastFilter.clamp((int)(127.5 * brightness + (double)(i - 127) * (contrast + 1.0)));
        }
        if (pContrast == 1.0f) {
            lut[127] = lut[126];
        }
        return lut;
    }

    private static int clamp(int i) {
        if (i < 0) {
            return 0;
        }
        if (i > 255) {
            return 255;
        }
        return i;
    }

    public int filterRGB(int pX, int pY, int pARGB) {
        int r = pARGB >> 16 & 0xFF;
        int g = pARGB >> 8 & 0xFF;
        int b = pARGB & 0xFF;
        r = this.LUT[r];
        g = this.LUT[g];
        b = this.LUT[b];
        return pARGB & 0xFF000000 | r << 16 | g << 8 | b;
    }
}

