/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.ImageConversionException;
import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.image.SubsamplingFilter;
import com.twelvemonkeys.lang.Validate;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class BufferedImageFactory {
    private List<ProgressListener> listeners;
    private int percentageDone;
    private ImageProducer producer;
    private ImageConversionException consumerException;
    private volatile boolean fetching;
    private boolean readColorModelOnly;
    private int x = 0;
    private int y = 0;
    private int width = -1;
    private int height = -1;
    private int xSub = 1;
    private int ySub = 1;
    private int offset;
    private int scanSize;
    private ColorModel sourceColorModel;
    private Hashtable sourceProperties;
    private Object sourcePixels;
    private BufferedImage buffered;
    private ColorModel colorModel;
    private final Consumer consumer = new Consumer();

    public BufferedImageFactory(Image pSource) {
        this(pSource != null ? pSource.getSource() : null);
    }

    public BufferedImageFactory(ImageProducer pSource) {
        Validate.notNull((Object)pSource, (String)"source");
        this.producer = pSource;
    }

    public BufferedImage getBufferedImage() throws ImageConversionException {
        this.doFetch(false);
        return this.buffered;
    }

    public ColorModel getColorModel() throws ImageConversionException {
        this.doFetch(true);
        return this.buffered != null ? this.buffered.getColorModel() : this.colorModel;
    }

    public void dispose() {
        this.freeResources();
        this.buffered = null;
        this.colorModel = null;
    }

    public void abort() {
        this.consumer.imageComplete(4);
    }

    public void setSourceRegion(Rectangle pRegion) {
        if (this.x != pRegion.x || this.y != pRegion.y || this.width != pRegion.width || this.height != pRegion.height) {
            this.dispose();
        }
        this.x = pRegion.x;
        this.y = pRegion.y;
        this.width = pRegion.width;
        this.height = pRegion.height;
    }

    public void setSourceSubsampling(int pXSub, int pYSub) {
        if (this.xSub != pXSub || this.ySub != pYSub) {
            this.dispose();
        }
        if (pXSub > 1) {
            this.xSub = pXSub;
        }
        if (pYSub > 1) {
            this.ySub = pYSub;
        }
    }

    private synchronized void doFetch(boolean pColorModelOnly) throws ImageConversionException {
        if (!this.fetching && (!pColorModelOnly && this.buffered == null || this.buffered == null && this.sourceColorModel == null)) {
            if (!(pColorModelOnly || this.xSub <= 1 && this.ySub <= 1)) {
                if (this.width > 0 && this.height > 0) {
                    this.width = (this.width + this.xSub - 1) / this.xSub;
                    this.height = (this.height + this.ySub - 1) / this.ySub;
                    this.x = (this.x + this.xSub - 1) / this.xSub;
                    this.y = (this.y + this.ySub - 1) / this.ySub;
                }
                this.producer = new FilteredImageSource(this.producer, new SubsamplingFilter(this.xSub, this.ySub));
            }
            this.fetching = true;
            this.readColorModelOnly = pColorModelOnly;
            this.producer.startProduction(this.consumer);
            while (this.fetching) {
                try {
                    this.wait(200L);
                }
                catch (InterruptedException e) {
                    throw new ImageConversionException("Image conversion aborted: " + e.getMessage(), e);
                }
            }
            if (this.consumerException != null) {
                throw new ImageConversionException("Image conversion failed: " + this.consumerException.getMessage(), this.consumerException);
            }
            if (pColorModelOnly) {
                this.createColorModel();
            } else {
                this.createBuffered();
            }
        }
    }

    private void createColorModel() {
        this.colorModel = this.sourceColorModel;
        this.freeResources();
    }

    private void createBuffered() {
        if (this.width > 0 && this.height > 0) {
            if (this.sourceColorModel != null && this.sourcePixels != null) {
                WritableRaster raster = ImageUtil.createRaster(this.width, this.height, this.sourcePixels, this.sourceColorModel);
                this.buffered = new BufferedImage(this.sourceColorModel, raster, this.sourceColorModel.isAlphaPremultiplied(), this.sourceProperties);
            } else {
                this.buffered = ImageUtil.createClear(this.width, this.height, null);
            }
        }
        this.freeResources();
    }

    private void freeResources() {
        this.sourceColorModel = null;
        this.sourcePixels = null;
        this.sourceProperties = null;
    }

    private void processProgress(int mScanline) {
        int percent;
        if (this.listeners != null && (percent = 100 * mScanline / this.height) > this.percentageDone) {
            this.percentageDone = percent;
            for (ProgressListener listener : this.listeners) {
                listener.progress(this, percent);
            }
        }
    }

    public void addProgressListener(ProgressListener pListener) {
        if (pListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<ProgressListener>();
        }
        this.listeners.add(pListener);
    }

    public void removeProgressListener(ProgressListener pListener) {
        if (pListener == null) {
            return;
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(pListener);
    }

    public void removeAllProgressListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    private static short[] toShortPixels(int[] pPixels) {
        short[] pixels = new short[pPixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (short)(pPixels[i] & 0xFFFF);
        }
        return pixels;
    }

    private class Consumer
    implements ImageConsumer {
        private Consumer() {
        }

        private void setPixelsImpl(int pX, int pY, int pWidth, int pHeight, ColorModel pModel, Object pPixels, int pOffset, int pScanSize) {
            int diff;
            this.setColorModelOnce(pModel);
            if (pPixels == null) {
                return;
            }
            if (BufferedImageFactory.this.sourcePixels == null) {
                BufferedImageFactory.this.sourcePixels = Array.newInstance(pPixels.getClass().getComponentType(), BufferedImageFactory.this.width * BufferedImageFactory.this.height);
                BufferedImageFactory.this.scanSize = BufferedImageFactory.this.width;
                BufferedImageFactory.this.offset = 0;
            } else if (BufferedImageFactory.this.sourcePixels.getClass() != pPixels.getClass()) {
                throw new IllegalStateException("Only one pixel type allowed");
            }
            if (pY < BufferedImageFactory.this.y) {
                diff = BufferedImageFactory.this.y - pY;
                if (diff >= pHeight) {
                    return;
                }
                pOffset += pScanSize * diff;
                pY += diff;
                pHeight -= diff;
            }
            if (pY + pHeight > BufferedImageFactory.this.y + BufferedImageFactory.this.height && (pHeight = BufferedImageFactory.this.y + BufferedImageFactory.this.height - pY) <= 0) {
                return;
            }
            if (pX < BufferedImageFactory.this.x) {
                diff = BufferedImageFactory.this.x - pX;
                if (diff >= pWidth) {
                    return;
                }
                pOffset += diff;
                pX += diff;
                pWidth -= diff;
            }
            if (pX + pWidth > BufferedImageFactory.this.x + BufferedImageFactory.this.width && (pWidth = BufferedImageFactory.this.x + BufferedImageFactory.this.width - pX) <= 0) {
                return;
            }
            int dstOffset = BufferedImageFactory.this.offset + (pY - BufferedImageFactory.this.y) * BufferedImageFactory.this.scanSize + (pX - BufferedImageFactory.this.x);
            for (int i = pHeight; i > 0; --i) {
                System.arraycopy(pPixels, pOffset, BufferedImageFactory.this.sourcePixels, dstOffset, pWidth);
                pOffset += pScanSize;
                dstOffset += BufferedImageFactory.this.scanSize;
            }
            BufferedImageFactory.this.processProgress(pY + pHeight);
        }

        public void setPixels(int pX, int pY, int pWidth, int pHeight, ColorModel pModel, short[] pPixels, int pOffset, int pScanSize) {
            this.setPixelsImpl(pX, pY, pWidth, pHeight, pModel, pPixels, pOffset, pScanSize);
        }

        private void setColorModelOnce(ColorModel pModel) {
            if (BufferedImageFactory.this.sourceColorModel != pModel) {
                if (BufferedImageFactory.this.sourcePixels == null) {
                    BufferedImageFactory.this.sourceColorModel = pModel;
                } else {
                    throw new IllegalStateException("Change of ColorModel after pixel delivery not supported");
                }
            }
            if (BufferedImageFactory.this.readColorModelOnly) {
                BufferedImageFactory.this.consumer.imageComplete(4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void imageComplete(int pStatus) {
            BufferedImageFactory.this.fetching = false;
            if (BufferedImageFactory.this.producer != null) {
                BufferedImageFactory.this.producer.removeConsumer(this);
            }
            switch (pStatus) {
                case 1: {
                    BufferedImageFactory.this.consumerException = new ImageConversionException("ImageConsumer.IMAGEERROR");
                }
            }
            BufferedImageFactory bufferedImageFactory = BufferedImageFactory.this;
            synchronized (bufferedImageFactory) {
                BufferedImageFactory.this.notifyAll();
            }
        }

        public void setColorModel(ColorModel pModel) {
            this.setColorModelOnce(pModel);
        }

        public void setDimensions(int pWidth, int pHeight) {
            if (BufferedImageFactory.this.width < 0) {
                BufferedImageFactory.this.width = pWidth - BufferedImageFactory.this.x;
            }
            if (BufferedImageFactory.this.height < 0) {
                BufferedImageFactory.this.height = pHeight - BufferedImageFactory.this.y;
            }
            if (BufferedImageFactory.this.width <= 0 || BufferedImageFactory.this.height <= 0) {
                this.imageComplete(3);
            }
        }

        public void setHints(int pHintflags) {
        }

        public void setPixels(int pX, int pY, int pWidth, int pHeight, ColorModel pModel, byte[] pPixels, int pOffset, int pScanSize) {
            this.setPixelsImpl(pX, pY, pWidth, pHeight, pModel, pPixels, pOffset, pScanSize);
        }

        public void setPixels(int pX, int pY, int pWeigth, int pHeight, ColorModel pModel, int[] pPixels, int pOffset, int pScanSize) {
            if (ImageUtil.getTransferType(pModel) == 1) {
                this.setPixelsImpl(pX, pY, pWeigth, pHeight, pModel, BufferedImageFactory.toShortPixels(pPixels), pOffset, pScanSize);
            } else {
                this.setPixelsImpl(pX, pY, pWeigth, pHeight, pModel, pPixels, pOffset, pScanSize);
            }
        }

        public void setProperties(Hashtable pProperties) {
            BufferedImageFactory.this.sourceProperties = pProperties;
        }
    }

    public static interface ProgressListener
    extends EventListener {
        public void progress(BufferedImageFactory var1, float var2);
    }
}

