/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.ImageUtil;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class ConvolveWithEdgeOp
implements BufferedImageOp,
RasterOp {
    public static final int EDGE_ZERO_FILL = 0;
    public static final int EDGE_NO_OP = 1;
    public static final int EDGE_REFLECT = 2;
    public static final int EDGE_WRAP = 3;
    private final Kernel kernel;
    private final int edgeCondition;
    private final ConvolveOp convolve;

    public ConvolveWithEdgeOp(Kernel pKernel, int pEdgeCondition, RenderingHints pHints) {
        int edge;
        switch (pEdgeCondition) {
            case 2: 
            case 3: {
                edge = 1;
                break;
            }
            default: {
                edge = pEdgeCondition;
            }
        }
        this.kernel = pKernel;
        this.edgeCondition = pEdgeCondition;
        this.convolve = new ConvolveOp(pKernel, edge, pHints);
    }

    public ConvolveWithEdgeOp(Kernel pKernel) {
        this(pKernel, 0, null);
    }

    public BufferedImage filter(BufferedImage pSource, BufferedImage pDestination) {
        if (pSource == null) {
            throw new NullPointerException("source image is null");
        }
        if (pSource == pDestination) {
            throw new IllegalArgumentException("source image cannot be the same as the destination image");
        }
        int borderX = this.kernel.getWidth() / 2;
        int borderY = this.kernel.getHeight() / 2;
        BufferedImage original = this.addBorder(pSource, borderX, borderY);
        BufferedImage destination = pDestination;
        if (original.getType() == 5) {
            destination = ImageUtil.createBuffered(pSource.getWidth(), pSource.getHeight(), pSource.getType(), pSource.getColorModel().getTransparency(), null);
        }
        destination = this.convolve.filter(original, destination);
        if (pSource != original) {
            destination = destination.getSubimage(borderX, borderY, pSource.getWidth(), pSource.getHeight());
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BufferedImage addBorder(BufferedImage pOriginal, int pBorderX, int pBorderY) {
        if ((this.edgeCondition & 2) == 0) {
            return pOriginal;
        }
        int w = pOriginal.getWidth();
        int h = pOriginal.getHeight();
        ColorModel cm = pOriginal.getColorModel();
        WritableRaster raster = cm.createCompatibleWritableRaster(w + 2 * pBorderX, h + 2 * pBorderY);
        BufferedImage bordered = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
        Graphics2D g = bordered.createGraphics();
        try {
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g.drawImage((Image)pOriginal, pBorderX, pBorderY, null);
            switch (this.edgeCondition) {
                case 2: {
                    g.drawImage(pOriginal, pBorderX, 0, pBorderX + w, pBorderY, 0, 0, w, 1, null);
                    g.drawImage(pOriginal, -w + pBorderX, pBorderY, pBorderX, h + pBorderY, 0, 0, 1, h, null);
                    g.drawImage(pOriginal, w + pBorderX, pBorderY, 2 * pBorderX + w, h + pBorderY, w - 1, 0, w, h, null);
                    g.drawImage(pOriginal, pBorderX, pBorderY + h, pBorderX + w, 2 * pBorderY + h, 0, h - 1, w, h, null);
                    return bordered;
                }
                case 3: {
                    g.drawImage((Image)pOriginal, -w + pBorderX, -h + pBorderY, null);
                    g.drawImage((Image)pOriginal, pBorderX, -h + pBorderY, null);
                    g.drawImage((Image)pOriginal, w + pBorderX, -h + pBorderY, null);
                    g.drawImage((Image)pOriginal, -w + pBorderX, pBorderY, null);
                    g.drawImage((Image)pOriginal, w + pBorderX, pBorderY, null);
                    g.drawImage((Image)pOriginal, -w + pBorderX, h + pBorderY, null);
                    g.drawImage((Image)pOriginal, pBorderX, h + pBorderY, null);
                    g.drawImage((Image)pOriginal, w + pBorderX, h + pBorderY, null);
                    return bordered;
                }
                default: {
                    throw new IllegalArgumentException("Illegal edge operation " + this.edgeCondition);
                }
            }
        }
        finally {
            g.dispose();
        }
    }

    public int getEdgeCondition() {
        return this.edgeCondition;
    }

    public WritableRaster filter(Raster pSource, WritableRaster pDestination) {
        return this.convolve.filter(pSource, pDestination);
    }

    public BufferedImage createCompatibleDestImage(BufferedImage pSource, ColorModel pDesinationColorModel) {
        return this.convolve.createCompatibleDestImage(pSource, pDesinationColorModel);
    }

    public WritableRaster createCompatibleDestRaster(Raster pSource) {
        return this.convolve.createCompatibleDestRaster(pSource);
    }

    public Rectangle2D getBounds2D(BufferedImage pSource) {
        return this.convolve.getBounds2D(pSource);
    }

    public Rectangle2D getBounds2D(Raster pSource) {
        return this.convolve.getBounds2D(pSource);
    }

    public Point2D getPoint2D(Point2D pSourcePoint, Point2D pDestinationPoint) {
        return this.convolve.getPoint2D(pSourcePoint, pDestinationPoint);
    }

    public RenderingHints getRenderingHints() {
        return this.convolve.getRenderingHints();
    }

    public Kernel getKernel() {
        return this.convolve.getKernel();
    }
}

