/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.ImageFilterException;
import com.twelvemonkeys.image.IndexImage;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class CopyDither
implements BufferedImageOp,
RasterOp {
    protected IndexColorModel indexColorModel = null;

    public CopyDither(IndexColorModel pICM) {
        this.indexColorModel = pICM;
    }

    public CopyDither() {
    }

    public final BufferedImage createCompatibleDestImage(BufferedImage pSource, ColorModel pDestCM) {
        if (pDestCM == null) {
            return new BufferedImage(pSource.getWidth(), pSource.getHeight(), 13, this.indexColorModel);
        }
        if (pDestCM instanceof IndexColorModel) {
            return new BufferedImage(pSource.getWidth(), pSource.getHeight(), 13, (IndexColorModel)pDestCM);
        }
        throw new ImageFilterException("Only IndexColorModel allowed.");
    }

    public final WritableRaster createCompatibleDestRaster(Raster pSrc) {
        return this.createCompatibleDestRaster(pSrc, this.getICM(pSrc));
    }

    public final WritableRaster createCompatibleDestRaster(Raster pSrc, IndexColorModel pIndexColorModel) {
        return pIndexColorModel.createCompatibleWritableRaster(pSrc.getWidth(), pSrc.getHeight());
    }

    public final Rectangle2D getBounds2D(BufferedImage pSrc) {
        return this.getBounds2D(pSrc.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster pSrc) {
        return pSrc.getBounds();
    }

    public final Point2D getPoint2D(Point2D pSrcPt, Point2D pDstPt) {
        if (pDstPt == null) {
            pDstPt = new Point2D.Float();
        }
        pDstPt.setLocation(pSrcPt.getX(), pSrcPt.getY());
        return pDstPt;
    }

    public final RenderingHints getRenderingHints() {
        return null;
    }

    private static int toIntARGB(int[] pRGB) {
        return 0xFF000000 | pRGB[0] << 16 | pRGB[1] << 8 | pRGB[2];
    }

    public final BufferedImage filter(BufferedImage pSource, BufferedImage pDest) {
        if (pDest == null) {
            pDest = this.createCompatibleDestImage(pSource, this.getICM(pSource));
        } else if (!(pDest.getColorModel() instanceof IndexColorModel)) {
            throw new ImageFilterException("Only IndexColorModel allowed.");
        }
        this.filter(pSource.getRaster(), pDest.getRaster(), (IndexColorModel)pDest.getColorModel());
        return pDest;
    }

    public final WritableRaster filter(Raster pSource, WritableRaster pDest) {
        return this.filter(pSource, pDest, this.getICM(pSource));
    }

    private IndexColorModel getICM(BufferedImage pSource) {
        return this.indexColorModel != null ? this.indexColorModel : IndexImage.getIndexColorModel((Image)pSource, 256, 131584);
    }

    private IndexColorModel getICM(Raster pSource) {
        return this.indexColorModel != null ? this.indexColorModel : this.createIndexColorModel(pSource);
    }

    private IndexColorModel createIndexColorModel(Raster pSource) {
        BufferedImage image = new BufferedImage(pSource.getWidth(), pSource.getHeight(), 2);
        image.setData(pSource);
        return IndexImage.getIndexColorModel((Image)image, 256, 131584);
    }

    public final WritableRaster filter(Raster pSource, WritableRaster pDest, IndexColorModel pColorModel) {
        int width = pSource.getWidth();
        int height = pSource.getHeight();
        if (pDest == null) {
            pDest = this.createCompatibleDestRaster(pSource, pColorModel);
        }
        int[] inRGB = new int[4];
        Object pixel = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                pSource.getPixel(x, y, inRGB);
                pixel = pColorModel.getDataElements(CopyDither.toIntARGB(inRGB), pixel);
                pDest.setDataElements(x, y, pixel);
            }
        }
        return pDest;
    }
}

