/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.BrightnessContrastFilter;
import com.twelvemonkeys.image.BufferedImageFactory;
import com.twelvemonkeys.image.DiffusionDither;
import com.twelvemonkeys.image.GrayFilter;
import com.twelvemonkeys.image.IndexImage;
import com.twelvemonkeys.image.ResampleOp;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;
import java.awt.image.Kernel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public final class ImageUtil {
    public static final int ROTATE_90_CCW = -90;
    public static final int ROTATE_90_CW = 90;
    public static final int ROTATE_180 = 180;
    public static final int FLIP_VERTICAL = -1;
    public static final int FLIP_HORIZONTAL = 1;
    public static final int EDGE_ZERO_FILL = 0;
    public static final int EDGE_NO_OP = 1;
    public static final int EDGE_REFLECT = 2;
    public static final int EDGE_WRAP = 3;
    public static final int DITHER_DEFAULT = 0;
    public static final int DITHER_NONE = 1;
    public static final int DITHER_DIFFUSION = 2;
    public static final int DITHER_DIFFUSION_ALTSCANS = 3;
    public static final int COLOR_SELECTION_DEFAULT = 0;
    public static final int COLOR_SELECTION_FAST = 256;
    public static final int COLOR_SELECTION_QUALITY = 512;
    public static final int TRANSPARENCY_DEFAULT = 0;
    public static final int TRANSPARENCY_OPAQUE = 65536;
    public static final int TRANSPARENCY_BITMASK = 131072;
    protected static final int TRANSPARENCY_TRANSLUCENT = 196608;
    private static final int BI_TYPE_ANY = -1;
    private static boolean VM_SUPPORTS_ACCELERATION = true;
    private static final float[] SHARPEN_MATRIX = new float[]{0.0f, -0.3f, 0.0f, -0.3f, 2.2f, -0.3f, 0.0f, -0.3f, 0.0f};
    private static final Kernel SHARPEN_KERNEL = new Kernel(3, 3, SHARPEN_MATRIX);
    private static final Component NULL_COMPONENT = new Component(){};
    private static MediaTracker sTracker = new MediaTracker(NULL_COMPONENT);
    protected static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    protected static final Point LOCATION_UPPER_LEFT = new Point(0, 0);
    private static final boolean COLORMODEL_TRANSFERTYPE_SUPPORTED = ImageUtil.isColorModelTransferTypeSupported();
    private static final GraphicsConfiguration DEFAULT_CONFIGURATION = ImageUtil.getDefaultGraphicsConfiguration();

    private static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        try {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (!env.isHeadlessInstance()) {
                return env.getDefaultScreenDevice().getDefaultConfiguration();
            }
        }
        catch (LinkageError e) {
            VM_SUPPORTS_ACCELERATION = false;
        }
        return null;
    }

    private ImageUtil() {
    }

    private static boolean isColorModelTransferTypeSupported() {
        try {
            ColorModel.getRGBdefault().getTransferType();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static BufferedImage toBuffered(RenderedImage pOriginal) {
        WritableRaster raster;
        Raster data;
        Hashtable<String, Object> properties;
        if (pOriginal instanceof BufferedImage) {
            return (BufferedImage)pOriginal;
        }
        if (pOriginal == null) {
            throw new IllegalArgumentException("original == null");
        }
        String[] names = pOriginal.getPropertyNames();
        if (names != null && names.length > 0) {
            properties = new Hashtable<String, Object>(names.length);
            for (String name : names) {
                properties.put(name, pOriginal.getProperty(name));
            }
        } else {
            properties = null;
        }
        if ((data = pOriginal.getData()) instanceof WritableRaster) {
            raster = (WritableRaster)data;
        } else {
            raster = data.createCompatibleWritableRaster();
            raster = pOriginal.copyData(raster);
        }
        ColorModel colorModel = pOriginal.getColorModel();
        return new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage toBuffered(RenderedImage pOriginal, int pType) {
        if (pOriginal instanceof BufferedImage && ((BufferedImage)pOriginal).getType() == pType) {
            return (BufferedImage)pOriginal;
        }
        if (pOriginal == null) {
            throw new IllegalArgumentException("original == null");
        }
        BufferedImage image = ImageUtil.createBuffered(pOriginal.getWidth(), pOriginal.getHeight(), pType, 3);
        Graphics2D g = image.createGraphics();
        try {
            g.setComposite(AlphaComposite.Src);
            g.drawRenderedImage(pOriginal, IDENTITY_TRANSFORM);
        }
        finally {
            g.dispose();
        }
        return image;
    }

    public static BufferedImage toBuffered(BufferedImage pOriginal, int pType) {
        return ImageUtil.toBuffered((RenderedImage)pOriginal, pType);
    }

    public static BufferedImage toBuffered(Image pOriginal) {
        if (pOriginal instanceof BufferedImage) {
            return (BufferedImage)pOriginal;
        }
        if (pOriginal == null) {
            throw new IllegalArgumentException("original == null");
        }
        BufferedImageFactory factory = new BufferedImageFactory(pOriginal);
        return factory.getBufferedImage();
    }

    public static BufferedImage createCopy(BufferedImage pImage) {
        if (pImage == null) {
            throw new IllegalArgumentException("image == null");
        }
        ColorModel cm = pImage.getColorModel();
        BufferedImage img = new BufferedImage(cm, cm.createCompatibleWritableRaster(pImage.getWidth(), pImage.getHeight()), cm.isAlphaPremultiplied(), null);
        ImageUtil.drawOnto(pImage, img);
        return img;
    }

    static WritableRaster createRaster(int pWidth, int pHeight, Object pPixels, ColorModel pColorModel) {
        int bands;
        Object[] data;
        DataBuffer buffer = null;
        WritableRaster raster = null;
        if (pPixels instanceof int[]) {
            data = (int[])pPixels;
            buffer = new DataBufferInt((int[])data, data.length);
            bands = pColorModel.getNumComponents();
        } else if (pPixels instanceof short[]) {
            data = (short[])pPixels;
            buffer = new DataBufferUShort((short[])data, data.length);
            bands = data.length / (pWidth * pHeight);
        } else if (pPixels instanceof byte[]) {
            data = (byte[])pPixels;
            buffer = new DataBufferByte((byte[])data, data.length);
            bands = pColorModel instanceof IndexColorModel ? 1 : data.length / (pWidth * pHeight);
        } else {
            bands = -1;
            raster = pColorModel.createCompatibleWritableRaster(pWidth, pHeight);
            raster.setDataElements(0, 0, pWidth, pHeight, pPixels);
        }
        if (raster == null) {
            if (pColorModel instanceof IndexColorModel && ImageUtil.isIndexedPacked((IndexColorModel)pColorModel)) {
                raster = Raster.createPackedRaster(buffer, pWidth, pHeight, pColorModel.getPixelSize(), LOCATION_UPPER_LEFT);
            } else if (pColorModel instanceof PackedColorModel) {
                PackedColorModel pcm = (PackedColorModel)pColorModel;
                raster = Raster.createPackedRaster(buffer, pWidth, pHeight, pWidth, pcm.getMasks(), LOCATION_UPPER_LEFT);
            } else {
                int[] bandsOffsets = new int[bands];
                int i = 0;
                while (i < bands) {
                    bandsOffsets[i++] = bands - i;
                }
                raster = Raster.createInterleavedRaster(buffer, pWidth, pHeight, pWidth * bands, bands, bandsOffsets, LOCATION_UPPER_LEFT);
            }
        }
        return raster;
    }

    private static boolean isIndexedPacked(IndexColorModel pColorModel) {
        return pColorModel.getPixelSize() == 1 || pColorModel.getPixelSize() == 2 || pColorModel.getPixelSize() == 4;
    }

    static WritableRaster createCompatibleWritableRaster(BufferedImage pOriginal, ColorModel pModel, int width, int height) {
        if (pModel == null || ImageUtil.equals(pOriginal.getColorModel(), pModel)) {
            switch (pOriginal.getType()) {
                case 5: {
                    int[] bOffs = new int[]{2, 1, 0};
                    return Raster.createInterleavedRaster(0, width, height, width * 3, 3, bOffs, null);
                }
                case 6: 
                case 7: {
                    int[] bOffs = new int[]{3, 2, 1, 0};
                    return Raster.createInterleavedRaster(0, width, height, width * 4, 4, bOffs, null);
                }
                case 0: {
                    SampleModel sm = pOriginal.getRaster().getSampleModel();
                    if (!(sm instanceof ComponentSampleModel)) break;
                    int[] bOffs = ((ComponentSampleModel)sm).getBandOffsets();
                    return Raster.createInterleavedRaster(sm.getDataType(), width, height, width * bOffs.length, bOffs.length, bOffs, null);
                }
            }
            return pOriginal.getColorModel().createCompatibleWritableRaster(width, height);
        }
        return pModel.createCompatibleWritableRaster(width, height);
    }

    public static BufferedImage toBuffered(Image pOriginal, int pType) {
        return ImageUtil.toBuffered(pOriginal, pType, null);
    }

    private static BufferedImage toBuffered(Image pOriginal, int pType, IndexColorModel pICM) {
        if (pOriginal instanceof BufferedImage && ((BufferedImage)pOriginal).getType() == pType && (pICM == null || ImageUtil.equals(((BufferedImage)pOriginal).getColorModel(), pICM))) {
            return (BufferedImage)pOriginal;
        }
        if (pOriginal == null) {
            throw new IllegalArgumentException("original == null");
        }
        BufferedImage image = pICM == null ? ImageUtil.createBuffered(ImageUtil.getWidth(pOriginal), ImageUtil.getHeight(pOriginal), pType, 3) : new BufferedImage(ImageUtil.getWidth(pOriginal), ImageUtil.getHeight(pOriginal), pType, pICM);
        ImageUtil.drawOnto(image, pOriginal);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void drawOnto(BufferedImage pDestination, Image pSource) {
        Graphics2D g = pDestination.createGraphics();
        try {
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g.drawImage(pSource, 0, 0, null);
        }
        finally {
            g.dispose();
        }
    }

    public static BufferedImage createFlipped(Image pImage, int pAxis) {
        AffineTransform transform;
        switch (pAxis) {
            case -1: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal direction: " + pAxis);
            }
        }
        BufferedImage source = ImageUtil.toBuffered(pImage);
        if (pAxis == 1) {
            transform = AffineTransform.getTranslateInstance(0.0, source.getHeight());
            transform.scale(1.0, -1.0);
        } else {
            transform = AffineTransform.getTranslateInstance(source.getWidth(), 0.0);
            transform.scale(-1.0, 1.0);
        }
        AffineTransformOp transformOp = new AffineTransformOp(transform, 1);
        return transformOp.filter(source, null);
    }

    public static BufferedImage createRotated(Image pImage, int pDirection) {
        switch (pDirection) {
            case -90: 
            case 90: 
            case 180: {
                return ImageUtil.createRotated(pImage, Math.toRadians(pDirection));
            }
        }
        throw new IllegalArgumentException("Illegal direction: " + pDirection);
    }

    public static BufferedImage createRotated(Image pImage, double pAngle) {
        return ImageUtil.createRotated0(ImageUtil.toBuffered(pImage), pAngle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage createRotated0(BufferedImage pSource, double pAngle) {
        if (Math.abs(Math.toDegrees(pAngle)) % 360.0 == 0.0) {
            return pSource;
        }
        boolean fast = Math.abs(Math.toDegrees(pAngle)) % 90.0 == 0.0;
        int w = pSource.getWidth();
        int h = pSource.getHeight();
        double sin = Math.abs(Math.sin(pAngle));
        double cos = Math.abs(Math.cos(pAngle));
        int newW = (int)Math.floor((double)w * cos + (double)h * sin);
        int newH = (int)Math.floor((double)h * cos + (double)w * sin);
        AffineTransform transform = AffineTransform.getTranslateInstance((double)(newW - w) / 2.0, (double)(newH - h) / 2.0);
        transform.rotate(pAngle, (double)w / 2.0, (double)h / 2.0);
        BufferedImage dest = ImageUtil.createTransparent(newW, newH);
        Graphics2D g = dest.createGraphics();
        try {
            g.transform(transform);
            if (!fast) {
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setPaint(new TexturePaint(pSource, new Rectangle2D.Float(0.0f, 0.0f, pSource.getWidth(), pSource.getHeight())));
                g.fillRect(0, 0, pSource.getWidth(), pSource.getHeight());
            } else {
                g.drawImage((Image)pSource, 0, 0, null);
            }
        }
        finally {
            g.dispose();
        }
        return dest;
    }

    public static BufferedImage createScaled(Image pImage, int pWidth, int pHeight, int pHints) {
        BufferedImage scaled;
        ColorModel cm;
        int type = -1;
        if (pImage instanceof RenderedImage) {
            cm = ((RenderedImage)((Object)pImage)).getColorModel();
            if (pImage instanceof BufferedImage) {
                type = ((BufferedImage)pImage).getType();
            }
        } else {
            BufferedImageFactory factory = new BufferedImageFactory(pImage);
            cm = factory.getColorModel();
        }
        if (type != (scaled = ImageUtil.createResampled(pImage, pWidth, pHeight, pHints)).getType() && type != -1 || !ImageUtil.equals(scaled.getColorModel(), cm)) {
            WritableRaster raster = pImage instanceof BufferedImage ? ImageUtil.createCompatibleWritableRaster((BufferedImage)pImage, cm, pWidth, pHeight) : cm.createCompatibleWritableRaster(pWidth, pHeight);
            BufferedImage temp = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
            if (cm instanceof IndexColorModel && pHints == 4) {
                new DiffusionDither((IndexColorModel)cm).filter(scaled, temp);
            } else {
                ImageUtil.drawOnto(temp, scaled);
            }
            scaled = temp;
        }
        return scaled;
    }

    private static boolean equals(ColorModel pLeft, ColorModel pRight) {
        if (pLeft == pRight) {
            return true;
        }
        if (!pLeft.equals(pRight)) {
            return false;
        }
        if (pLeft instanceof IndexColorModel) {
            int mapSize2;
            IndexColorModel icm1 = (IndexColorModel)pLeft;
            IndexColorModel icm2 = (IndexColorModel)pRight;
            int mapSize1 = icm1.getMapSize();
            if (mapSize1 != (mapSize2 = icm2.getMapSize())) {
                return false;
            }
            for (int i = 0; i > mapSize1; ++i) {
                if (icm1.getRGB(i) == icm2.getRGB(i)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static BufferedImage createResampled(Image pImage, int pWidth, int pHeight, int pHints) {
        BufferedImage image = pImage instanceof BufferedImage ? (BufferedImage)pImage : ImageUtil.toBuffered(pImage, 6);
        return ImageUtil.createResampled(image, pWidth, pHeight, pHints);
    }

    public static BufferedImage createResampled(RenderedImage pImage, int pWidth, int pHeight, int pHints) {
        BufferedImage image = pImage instanceof BufferedImage ? (BufferedImage)pImage : ImageUtil.toBuffered(pImage, pImage.getColorModel().hasAlpha() ? 6 : 5);
        return ImageUtil.createResampled(image, pWidth, pHeight, pHints);
    }

    public static BufferedImage createResampled(BufferedImage pImage, int pWidth, int pHeight, int pHints) {
        return new ResampleOp(pWidth, pHeight, ImageUtil.convertAWTHints(pHints)).filter(pImage, null);
    }

    private static int convertAWTHints(int pHints) {
        switch (pHints) {
            case 2: 
            case 8: {
                return 1;
            }
            case 16: {
                return 2;
            }
            case 4: {
                return 13;
            }
        }
        return 9;
    }

    public static IndexColorModel getIndexColorModel(Image pImage, int pColors, int pHints) {
        return IndexImage.getIndexColorModel(pImage, pColors, pHints);
    }

    public static BufferedImage createIndexed(Image pImage) {
        return IndexImage.getIndexedImage(ImageUtil.toBuffered(pImage), 256, Color.black, 0);
    }

    public static BufferedImage createIndexed(Image pImage, int pColors, Color pMatte, int pHints) {
        return IndexImage.getIndexedImage(ImageUtil.toBuffered(pImage), pColors, pMatte, pHints);
    }

    public static BufferedImage createIndexed(Image pImage, IndexColorModel pColors, Color pMatte, int pHints) {
        return IndexImage.getIndexedImage(ImageUtil.toBuffered(pImage), pColors, pMatte, pHints);
    }

    public static BufferedImage createIndexed(Image pImage, Image pColors, Color pMatte, int pHints) {
        return IndexImage.getIndexedImage(ImageUtil.toBuffered(pImage), IndexImage.getIndexColorModel(pColors, 255, pHints), pMatte, pHints);
    }

    public static BufferedImage sharpen(BufferedImage pOriginal) {
        return ImageUtil.convolve(pOriginal, SHARPEN_KERNEL, 2);
    }

    public static BufferedImage sharpen(BufferedImage pOriginal, float pAmmount) {
        if (pAmmount == 0.0f) {
            return pOriginal;
        }
        float[] data = new float[]{0.0f, -pAmmount, 0.0f, -pAmmount, 4.0f * pAmmount + 1.0f, -pAmmount, 0.0f, -pAmmount, 0.0f};
        return ImageUtil.convolve(pOriginal, new Kernel(3, 3, data), 2);
    }

    public static BufferedImage blur(BufferedImage pOriginal) {
        return ImageUtil.blur(pOriginal, 1.5f);
    }

    public static BufferedImage blur(BufferedImage pOriginal, float pRadius) {
        if (pRadius <= 1.0f) {
            return pOriginal;
        }
        Kernel horizontal = ImageUtil.makeKernel(pRadius);
        Kernel vertical = new Kernel(horizontal.getHeight(), horizontal.getWidth(), horizontal.getKernelData(null));
        BufferedImage temp = ImageUtil.addBorder(pOriginal, horizontal.getWidth() / 2, vertical.getHeight() / 2, 2);
        temp = ImageUtil.convolve(temp, horizontal, 1);
        temp = ImageUtil.convolve(temp, vertical, 1);
        return temp.getSubimage(horizontal.getWidth() / 2, vertical.getHeight() / 2, pOriginal.getWidth(), pOriginal.getHeight());
    }

    private static Kernel makeKernel(float radius) {
        int r = (int)Math.ceil(radius);
        int rows = r * 2 + 1;
        float[] matrix = new float[rows];
        float sigma = radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)(Math.PI * 2 * (double)sigma);
        float sqrtSigmaPi2 = (float)Math.sqrt(sigmaPi2);
        float radius2 = radius * radius;
        float total = 0.0f;
        int index = 0;
        for (int row = -r; row <= r; ++row) {
            float distance = row * row;
            matrix[index] = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sqrtSigmaPi2;
            total += matrix[index];
            ++index;
        }
        int i = 0;
        while (i < rows) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        return new Kernel(rows, 1, matrix);
    }

    public static BufferedImage convolve(BufferedImage pOriginal, Kernel pKernel, int pEdgeOperation) {
        BufferedImage original;
        switch (pEdgeOperation) {
            case 2: 
            case 3: {
                original = ImageUtil.addBorder(pOriginal, pKernel.getWidth() / 2, pKernel.getHeight() / 2, pEdgeOperation);
                break;
            }
            default: {
                original = pOriginal;
            }
        }
        ConvolveOp convolve = new ConvolveOp(pKernel, pEdgeOperation, null);
        BufferedImage result = null;
        if (original.getType() == 5) {
            result = ImageUtil.createBuffered(pOriginal.getWidth(), pOriginal.getHeight(), pOriginal.getType(), pOriginal.getColorModel().getTransparency());
        }
        BufferedImage image = convolve.filter(original, result);
        if (pOriginal != original) {
            image = image.getSubimage(pKernel.getWidth() / 2, pKernel.getHeight() / 2, pOriginal.getWidth(), pOriginal.getHeight());
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BufferedImage addBorder(BufferedImage pOriginal, int pBorderX, int pBorderY, int pEdgeOperation) {
        int w = pOriginal.getWidth();
        int h = pOriginal.getHeight();
        ColorModel cm = pOriginal.getColorModel();
        WritableRaster raster = cm.createCompatibleWritableRaster(w + 2 * pBorderX, h + 2 * pBorderY);
        BufferedImage bordered = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
        Graphics2D g = bordered.createGraphics();
        try {
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g.drawImage((Image)pOriginal, pBorderX, pBorderY, null);
            switch (pEdgeOperation) {
                case 2: {
                    g.drawImage(pOriginal, pBorderX, 0, pBorderX + w, pBorderY, 0, 0, w, 1, null);
                    g.drawImage(pOriginal, -w + pBorderX, pBorderY, pBorderX, h + pBorderY, 0, 0, 1, h, null);
                    g.drawImage(pOriginal, w + pBorderX, pBorderY, 2 * pBorderX + w, h + pBorderY, w - 1, 0, w, h, null);
                    g.drawImage(pOriginal, pBorderX, pBorderY + h, pBorderX + w, 2 * pBorderY + h, 0, h - 1, w, h, null);
                    return bordered;
                }
                case 3: {
                    g.drawImage((Image)pOriginal, -w + pBorderX, -h + pBorderY, null);
                    g.drawImage((Image)pOriginal, pBorderX, -h + pBorderY, null);
                    g.drawImage((Image)pOriginal, w + pBorderX, -h + pBorderY, null);
                    g.drawImage((Image)pOriginal, -w + pBorderX, pBorderY, null);
                    g.drawImage((Image)pOriginal, w + pBorderX, pBorderY, null);
                    g.drawImage((Image)pOriginal, -w + pBorderX, h + pBorderY, null);
                    g.drawImage((Image)pOriginal, pBorderX, h + pBorderY, null);
                    g.drawImage((Image)pOriginal, w + pBorderX, h + pBorderY, null);
                    return bordered;
                }
                default: {
                    throw new IllegalArgumentException("Illegal edge operation " + pEdgeOperation);
                }
            }
        }
        finally {
            g.dispose();
        }
    }

    public static Image contrast(Image pOriginal) {
        return ImageUtil.contrast(pOriginal, 0.3f);
    }

    public static Image contrast(Image pOriginal, float pAmmount) {
        if (pAmmount == 0.0f) {
            return pOriginal;
        }
        BrightnessContrastFilter filter = new BrightnessContrastFilter(0.0f, pAmmount);
        return ImageUtil.filter(pOriginal, filter);
    }

    public static Image brightness(Image pOriginal, float pAmmount) {
        if (pAmmount == 0.0f) {
            return pOriginal;
        }
        BrightnessContrastFilter filter = new BrightnessContrastFilter(pAmmount, 0.0f);
        return ImageUtil.filter(pOriginal, filter);
    }

    public static Image grayscale(Image pOriginal) {
        GrayFilter filter = new GrayFilter();
        return ImageUtil.filter(pOriginal, filter);
    }

    public static Image filter(Image pOriginal, ImageFilter pFilter) {
        FilteredImageSource source = new FilteredImageSource(pOriginal.getSource(), pFilter);
        return Toolkit.getDefaultToolkit().createImage(source);
    }

    public static BufferedImage accelerate(Image pImage) {
        return ImageUtil.accelerate(pImage, null, DEFAULT_CONFIGURATION);
    }

    public static BufferedImage accelerate(Image pImage, GraphicsConfiguration pConfiguration) {
        return ImageUtil.accelerate(pImage, null, pConfiguration);
    }

    static BufferedImage accelerate(Image pImage, Color pBackgroundColor, GraphicsConfiguration pConfiguration) {
        BufferedImage buffered;
        if (pImage instanceof BufferedImage && (buffered = (BufferedImage)pImage).getType() != 0 && ImageUtil.equals(buffered.getColorModel(), pConfiguration.getColorModel(buffered.getTransparency()))) {
            return buffered;
        }
        if (pImage == null) {
            throw new IllegalArgumentException("image == null");
        }
        int w = ImageUtil.getWidth(pImage);
        int h = ImageUtil.getHeight(pImage);
        BufferedImage temp = ImageUtil.createClear(w, h, -1, ImageUtil.getTransparency(pImage), pBackgroundColor, pConfiguration);
        ImageUtil.drawOnto(temp, pImage);
        return temp;
    }

    private static int getTransparency(Image pImage) {
        if (pImage instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)pImage;
            return bi.getTransparency();
        }
        return 1;
    }

    public static BufferedImage createTransparent(int pWidth, int pHeight) {
        return ImageUtil.createTransparent(pWidth, pHeight, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createTransparent(int pWidth, int pHeight, int pType) {
        BufferedImage image = ImageUtil.createBuffered(pWidth, pHeight, pType, 3);
        Graphics2D g = image.createGraphics();
        try {
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(0, 0, pWidth, pHeight);
        }
        finally {
            g.dispose();
        }
        return image;
    }

    public static BufferedImage createClear(int pWidth, int pHeight, Color pBackground) {
        return ImageUtil.createClear(pWidth, pHeight, -1, pBackground);
    }

    public static BufferedImage createClear(int pWidth, int pHeight, int pType, Color pBackground) {
        return ImageUtil.createClear(pWidth, pHeight, pType, 1, pBackground, DEFAULT_CONFIGURATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BufferedImage createClear(int pWidth, int pHeight, int pType, int pTransparency, Color pBackground, GraphicsConfiguration pConfiguration) {
        int transparency = pBackground != null ? pBackground.getTransparency() : pTransparency;
        BufferedImage image = ImageUtil.createBuffered(pWidth, pHeight, pType, transparency, pConfiguration);
        if (pBackground != null) {
            Graphics2D g = image.createGraphics();
            try {
                g.setComposite(AlphaComposite.Src);
                g.setColor(pBackground);
                g.fillRect(0, 0, pWidth, pHeight);
            }
            finally {
                g.dispose();
            }
        }
        return image;
    }

    private static BufferedImage createBuffered(int pWidth, int pHeight, int pType, int pTransparency) {
        return ImageUtil.createBuffered(pWidth, pHeight, pType, pTransparency, DEFAULT_CONFIGURATION);
    }

    static BufferedImage createBuffered(int pWidth, int pHeight, int pType, int pTransparency, GraphicsConfiguration pConfiguration) {
        GraphicsEnvironment env;
        if (VM_SUPPORTS_ACCELERATION && pType == -1 && ImageUtil.supportsAcceleration(env = GraphicsEnvironment.getLocalGraphicsEnvironment())) {
            return ImageUtil.getConfiguration(pConfiguration).createCompatibleImage(pWidth, pHeight, pTransparency);
        }
        return new BufferedImage(pWidth, pHeight, ImageUtil.getImageType(pType, pTransparency));
    }

    private static GraphicsConfiguration getConfiguration(GraphicsConfiguration pConfiguration) {
        return pConfiguration != null ? pConfiguration : DEFAULT_CONFIGURATION;
    }

    private static int getImageType(int pType, int pTransparency) {
        if (pType != -1) {
            return pType;
        }
        switch (pTransparency) {
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unknown transparency type: " + pTransparency);
    }

    private static boolean supportsAcceleration(GraphicsEnvironment pEnv) {
        try {
            return !pEnv.isHeadlessInstance();
        }
        catch (LinkageError ignore) {
            VM_SUPPORTS_ACCELERATION = false;
            return false;
        }
    }

    public static int getWidth(Image pImage) {
        int width = pImage.getWidth(NULL_COMPONENT);
        if (width < 0) {
            if (!ImageUtil.waitForImage(pImage)) {
                return -1;
            }
            width = pImage.getWidth(NULL_COMPONENT);
        }
        return width;
    }

    public static int getHeight(Image pImage) {
        int height = pImage.getHeight(NULL_COMPONENT);
        if (height < 0) {
            if (!ImageUtil.waitForImage(pImage)) {
                return -1;
            }
            height = pImage.getHeight(NULL_COMPONENT);
        }
        return height;
    }

    public static boolean waitForImage(Image pImage) {
        return ImageUtil.waitForImages(new Image[]{pImage}, -1L);
    }

    public static boolean waitForImage(Image pImage, long pTimeOut) {
        return ImageUtil.waitForImages(new Image[]{pImage}, pTimeOut);
    }

    public static boolean waitForImages(Image[] pImages) {
        return ImageUtil.waitForImages(pImages, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImages(Image[] pImages, long pTimeOut) {
        boolean success = true;
        int imageId = pImages.length == 1 ? System.identityHashCode(pImages[0]) : System.identityHashCode(pImages);
        for (Image image : pImages) {
            sTracker.addImage(image, imageId);
            if (!sTracker.checkID(imageId, false)) continue;
            sTracker.removeImage(image, imageId);
        }
        try {
            if (pTimeOut < 0L) {
                sTracker.waitForID(imageId);
            } else {
                success = sTracker.waitForID(imageId, pTimeOut);
            }
        }
        catch (InterruptedException ie) {
            success = false;
            return success;
        }
        finally {
            for (Image pImage : pImages) {
                sTracker.removeImage(pImage, imageId);
            }
        }
        return success && !sTracker.isErrorID(imageId);
    }

    public static boolean hasTransparentPixels(RenderedImage pImage, boolean pFast) {
        if (pImage == null) {
            return false;
        }
        ColorModel cm = pImage.getColorModel();
        if (!cm.hasAlpha()) {
            return false;
        }
        if (cm.getTransparency() != 2 && cm.getTransparency() != 3) {
            return false;
        }
        Object data = null;
        for (int yT = pImage.getMinTileY(); yT < pImage.getNumYTiles(); ++yT) {
            for (int xT = pImage.getMinTileX(); xT < pImage.getNumXTiles(); ++xT) {
                Raster raster = pImage.getTile(xT, yT);
                int xIncrement = pFast ? Math.max(raster.getWidth() / 10, 1) : 1;
                int yIncrement = pFast ? Math.max(raster.getHeight() / 10, 1) : 1;
                for (int y = 0; y < raster.getHeight(); y += yIncrement) {
                    for (int x = 0; x < raster.getWidth(); x += xIncrement) {
                        if (cm.getAlpha(data = raster.getDataElements(x, y, data)) == 255) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static Color createTranslucent(Color pColor, int pTransparency) {
        return new Color((pTransparency & 0xFF) << 24 | pColor.getRGB() & 0xFFFFFF, true);
    }

    static int blend(int pRGB1, int pRGB2) {
        return (((pRGB1 ^ pRGB2) & 0xFEFEFEFE) >> 1) + (pRGB1 & pRGB2);
    }

    public static Color blend(Color pColor, Color pOther) {
        return new Color(ImageUtil.blend(pColor.getRGB(), pOther.getRGB()), true);
    }

    public static Color blend(Color pColor, Color pOther, float pBlendFactor) {
        float inverseBlend = 1.0f - pBlendFactor;
        return new Color(ImageUtil.clamp((float)pColor.getRed() * inverseBlend + (float)pOther.getRed() * pBlendFactor), ImageUtil.clamp((float)pColor.getGreen() * inverseBlend + (float)pOther.getGreen() * pBlendFactor), ImageUtil.clamp((float)pColor.getBlue() * inverseBlend + (float)pOther.getBlue() * pBlendFactor), ImageUtil.clamp((float)pColor.getAlpha() * inverseBlend + (float)pOther.getAlpha() * pBlendFactor));
    }

    private static int clamp(float f) {
        return (int)f;
    }

    public static int getTransferType(ColorModel pModel) {
        if (COLORMODEL_TRANSFERTYPE_SUPPORTED) {
            return pModel.getTransferType();
        }
        return pModel.createCompatibleSampleModel(1, 1).getDataType();
    }
}

