/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader;
import com.twelvemonkeys.imageio.plugins.jpeg.ThumbnailReadProgressListener;
import com.twelvemonkeys.imageio.plugins.jpeg.ThumbnailReader;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class EXIFThumbnailReader
extends ThumbnailReader {
    private final Directory ifd;
    private final ImageInputStream stream;
    private final int compression;
    private transient SoftReference<BufferedImage> cachedThumbnail;

    public EXIFThumbnailReader(ThumbnailReadProgressListener progressListener, int imageIndex, int thumbnailIndex, Directory ifd, ImageInputStream stream) {
        super(progressListener, imageIndex, thumbnailIndex);
        this.ifd = ifd;
        this.stream = stream;
        Entry compression = ifd.getEntryById((Object)259);
        this.compression = compression != null ? ((Number)compression.getValue()).intValue() : 6;
    }

    public BufferedImage read() throws IOException {
        if (this.compression == 1) {
            this.processThumbnailStarted();
            BufferedImage thumbnail = this.readUncompressed();
            this.processThumbnailProgress(100.0f);
            this.processThumbnailComplete();
            return thumbnail;
        }
        if (this.compression == 6) {
            this.processThumbnailStarted();
            BufferedImage thumbnail = this.readJPEGCached(true);
            this.processThumbnailProgress(100.0f);
            this.processThumbnailComplete();
            return thumbnail;
        }
        throw new IIOException("Unsupported EXIF thumbnail compression: " + this.compression);
    }

    private BufferedImage readJPEGCached(boolean pixelsExposed) throws IOException {
        BufferedImage thumbnail;
        BufferedImage bufferedImage = thumbnail = this.cachedThumbnail != null ? this.cachedThumbnail.get() : null;
        if (thumbnail == null) {
            thumbnail = this.readJPEG();
        }
        this.cachedThumbnail = pixelsExposed ? null : new SoftReference<BufferedImage>(thumbnail);
        return thumbnail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readJPEG() throws IOException {
        Entry jpegOffset = this.ifd.getEntryById((Object)513);
        if (jpegOffset != null) {
            this.stream.seek(((Number)jpegOffset.getValue()).longValue());
            InputStream input = IIOUtil.createStreamAdapter((ImageInputStream)this.stream);
            byte[] fakeEmptyExif = new byte[]{(byte)input.read(), (byte)input.read(), -1, -31, 0, 16, 69, 120, 105, 102, 0, 0, 77, 77, 0, 42, 0, 0, 0, 0};
            input = new SequenceInputStream(new ByteArrayInputStream(fakeEmptyExif), input);
            try {
                BufferedImage bufferedImage = EXIFThumbnailReader.readJPEGThumbnail(input);
                return bufferedImage;
            }
            finally {
                input.close();
            }
        }
        throw new IIOException("Missing JPEGInterchangeFormat tag for JPEG compressed EXIF thumbnail");
    }

    private BufferedImage readUncompressed() throws IOException {
        int[] bpp;
        Entry width = this.ifd.getEntryById((Object)256);
        Entry height = this.ifd.getEntryById((Object)257);
        if (width == null || height == null) {
            throw new IIOException("Missing dimensions for uncompressed EXIF thumbnail");
        }
        Entry bitsPerSample = this.ifd.getEntryById((Object)258);
        Entry samplesPerPixel = this.ifd.getEntryById((Object)277);
        Entry photometricInterpretation = this.ifd.getEntryById((Object)262);
        int w = ((Number)width.getValue()).intValue();
        int h = ((Number)height.getValue()).intValue();
        if (bitsPerSample != null && !Arrays.equals(bpp = (int[])bitsPerSample.getValue(), new int[]{8, 8, 8})) {
            throw new IIOException("Unknown BitsPerSample value for uncompressed EXIF thumbnail (expected [8, 8, 8]): " + bitsPerSample.getValueAsString());
        }
        if (samplesPerPixel != null && (Integer)samplesPerPixel.getValue() != 3) {
            throw new IIOException("Unknown SamplesPerPixel value for uncompressed EXIF thumbnail (expected 3): " + samplesPerPixel.getValueAsString());
        }
        int interpretation = photometricInterpretation != null ? ((Number)photometricInterpretation.getValue()).intValue() : 2;
        Entry offset = this.ifd.getEntryById((Object)273);
        if (offset != null) {
            this.stream.seek(((Number)offset.getValue()).longValue());
            int thumbSize = w * h * 3;
            byte[] thumbData = JPEGImageReader.readFully(this.stream, thumbSize);
            switch (interpretation) {
                case 2: {
                    break;
                }
                case 6: {
                    int thumbDataLength = thumbData.length;
                    for (int i = 0; i < thumbDataLength; i += 3) {
                        JPEGImageReader.YCbCrConverter.convertYCbCr2RGB(thumbData, thumbData, i);
                    }
                    break;
                }
                default: {
                    throw new IIOException("Unknown PhotometricInterpretation value for uncompressed EXIF thumbnail (expected 2 or 6): " + interpretation);
                }
            }
            return ThumbnailReader.readRawThumbnail(thumbData, thumbData.length, 0, w, h);
        }
        throw new IIOException("Missing StripOffsets tag for uncompressed EXIF thumbnail");
    }

    public int getWidth() throws IOException {
        if (this.compression == 1) {
            Entry width = this.ifd.getEntryById((Object)256);
            if (width == null) {
                throw new IIOException("Missing dimensions for unknown EXIF thumbnail");
            }
            return ((Number)width.getValue()).intValue();
        }
        if (this.compression == 6) {
            return this.readJPEGCached(false).getWidth();
        }
        throw new IIOException("Unsupported EXIF thumbnail compression (expected 1 or 6): " + this.compression);
    }

    public int getHeight() throws IOException {
        if (this.compression == 1) {
            Entry height = this.ifd.getEntryById((Object)257);
            if (height == null) {
                throw new IIOException("Missing dimensions for unknown EXIF thumbnail");
            }
            return ((Number)height.getValue()).intValue();
        }
        if (this.compression == 6) {
            return this.readJPEGCached(false).getHeight();
        }
        throw new IIOException("Unsupported EXIF thumbnail compression  (expected 1 or 6): " + this.compression);
    }
}

