/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class JFIFSegment {
    final int majorVersion;
    final int minorVersion;
    final int units;
    final int xDensity;
    final int yDensity;
    final int xThumbnail;
    final int yThumbnail;
    final byte[] thumbnail;

    private JFIFSegment(int majorVersion, int minorVersion, int units, int xDensity, int yDensity, int xThumbnail, int yThumbnail, byte[] thumbnail) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.units = units;
        this.xDensity = xDensity;
        this.yDensity = yDensity;
        this.xThumbnail = xThumbnail;
        this.yThumbnail = yThumbnail;
        this.thumbnail = thumbnail;
    }

    public String toString() {
        return String.format("JFIF v%d.%02d %dx%d %s (%s)", this.majorVersion, this.minorVersion, this.xDensity, this.yDensity, this.unitsAsString(), this.thumbnailToString());
    }

    private String unitsAsString() {
        switch (this.units) {
            case 0: {
                return "(aspect only)";
            }
            case 1: {
                return "dpi";
            }
            case 2: {
                return "dpcm";
            }
        }
        return "(unknown unit)";
    }

    private String thumbnailToString() {
        if (this.xThumbnail == 0 || this.yThumbnail == 0) {
            return "no thumbnail";
        }
        return String.format("thumbnail: %dx%d", this.xThumbnail, this.yThumbnail);
    }

    public static JFIFSegment read(InputStream data) throws IOException {
        DataInputStream stream = new DataInputStream(data);
        int x = stream.readUnsignedByte();
        int y = stream.readUnsignedByte();
        return new JFIFSegment(stream.readUnsignedByte(), stream.readUnsignedByte(), stream.readUnsignedByte(), stream.readUnsignedShort(), stream.readUnsignedShort(), x, y, JPEGImageReader.readFully(stream, x * y * 3));
    }
}

