/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader;
import com.twelvemonkeys.imageio.spi.ProviderInfo;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPEGImageReaderSpi
extends ImageReaderSpi {
    private ImageReaderSpi delegateProvider;

    public JPEGImageReaderSpi() {
        this(IIOUtil.getProviderInfo(JPEGImageReaderSpi.class));
    }

    private JPEGImageReaderSpi(ProviderInfo providerInfo) {
        super(providerInfo.getVendorName(), providerInfo.getVersion(), new String[]{"JPEG", "jpeg", "JPG", "jpg"}, new String[]{"jpg", "jpeg"}, new String[]{"image/jpeg"}, "com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader", STANDARD_INPUT_TYPE, new String[]{"com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageWriterSpi"}, true, null, null, null, null, true, null, null, null, null);
    }

    protected JPEGImageReaderSpi(ImageReaderSpi delegateProvider) {
        this(IIOUtil.getProviderInfo(JPEGImageReaderSpi.class));
        this.delegateProvider = (ImageReaderSpi)Validate.notNull((Object)delegateProvider);
    }

    static ImageReaderSpi lookupDelegateProvider(ServiceRegistry registry) {
        try {
            return (ImageReaderSpi)registry.getServiceProviderByClass(Class.forName("com.sun.imageio.plugins.jpeg.JPEGImageReaderSpi"));
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void onRegistration(ServiceRegistry registry, Class<?> category) {
        if (this.delegateProvider == null) {
            this.delegateProvider = JPEGImageReaderSpi.lookupDelegateProvider(registry);
        }
        if (this.delegateProvider != null) {
            registry.setOrdering(category, this, this.delegateProvider);
        } else {
            IIOUtil.deregisterProvider((ServiceRegistry)registry, (IIOServiceProvider)this, category);
        }
    }

    @Override
    public String getVendorName() {
        return String.format("%s/%s", super.getVendorName(), this.delegateProvider.getVendorName());
    }

    @Override
    public String getVersion() {
        return String.format("%s/%s", super.getVersion(), this.delegateProvider.getVersion());
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new JPEGImageReader(this, this.delegateProvider.createReaderInstance(extension));
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        return this.delegateProvider.canDecodeInput(source);
    }

    @Override
    public String[] getFormatNames() {
        return this.delegateProvider.getFormatNames();
    }

    @Override
    public String[] getFileSuffixes() {
        return this.delegateProvider.getFileSuffixes();
    }

    @Override
    public String[] getMIMETypes() {
        return this.delegateProvider.getMIMETypes();
    }

    @Override
    public boolean isStandardStreamMetadataFormatSupported() {
        return this.delegateProvider.isStandardStreamMetadataFormatSupported();
    }

    @Override
    public String getNativeStreamMetadataFormatName() {
        return this.delegateProvider.getNativeStreamMetadataFormatName();
    }

    @Override
    public String[] getExtraStreamMetadataFormatNames() {
        return this.delegateProvider.getExtraStreamMetadataFormatNames();
    }

    @Override
    public boolean isStandardImageMetadataFormatSupported() {
        return this.delegateProvider.isStandardImageMetadataFormatSupported();
    }

    @Override
    public String getNativeImageMetadataFormatName() {
        return this.delegateProvider.getNativeImageMetadataFormatName();
    }

    @Override
    public String[] getExtraImageMetadataFormatNames() {
        return this.delegateProvider.getExtraImageMetadataFormatNames();
    }

    @Override
    public IIOMetadataFormat getStreamMetadataFormat(String formatName) {
        return this.delegateProvider.getStreamMetadataFormat(formatName);
    }

    @Override
    public IIOMetadataFormat getImageMetadataFormat(String formatName) {
        return this.delegateProvider.getImageMetadataFormat(formatName);
    }

    @Override
    public String getDescription(Locale locale) {
        return this.delegateProvider.getDescription(locale);
    }

    public Class[] getInputTypes() {
        return this.delegateProvider.getInputTypes();
    }
}

