/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageWriterSpi;
import com.twelvemonkeys.imageio.util.ProgressListenerBase;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPEGImageWriter
extends ImageWriterBase {
    private final ImageWriter delegate;
    private final ProgressDelegator progressDelegator;

    public JPEGImageWriter(JPEGImageWriterSpi provider, ImageWriter delegate) {
        super((ImageWriterSpi)provider);
        this.delegate = delegate;
        this.progressDelegator = new ProgressDelegator();
    }

    private void installListeners() {
        this.delegate.addIIOWriteProgressListener((IIOWriteProgressListener)((Object)this.progressDelegator));
        this.delegate.addIIOWriteWarningListener(this.progressDelegator);
    }

    protected void resetMembers() {
        this.installListeners();
    }

    public void setOutput(Object output) {
        super.setOutput(output);
        this.delegate.setOutput(output);
    }

    public Object getOutput() {
        return this.delegate.getOutput();
    }

    public Locale[] getAvailableLocales() {
        return this.delegate.getAvailableLocales();
    }

    public void setLocale(Locale locale) {
        this.delegate.setLocale(locale);
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public ImageWriteParam getDefaultWriteParam() {
        return this.delegate.getDefaultWriteParam();
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return this.delegate.getDefaultStreamMetadata(param);
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return this.delegate.getDefaultImageMetadata(imageType, param);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return this.delegate.convertStreamMetadata(inData, param);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return this.delegate.convertImageMetadata(inData, imageType, param);
    }

    public int getNumThumbnailsSupported(ImageTypeSpecifier imageType, ImageWriteParam param, IIOMetadata streamMetadata, IIOMetadata imageMetadata) {
        return this.delegate.getNumThumbnailsSupported(imageType, param, streamMetadata, imageMetadata);
    }

    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageType, ImageWriteParam param, IIOMetadata streamMetadata, IIOMetadata imageMetadata) {
        return this.delegate.getPreferredThumbnailSizes(imageType, param, streamMetadata, imageMetadata);
    }

    public boolean canWriteRasters() {
        return this.delegate.canWriteRasters();
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        this.delegate.write(streamMetadata, image, param);
    }

    public void write(IIOImage image) throws IOException {
        this.delegate.write(image);
    }

    public void write(RenderedImage image) throws IOException {
        this.delegate.write(image);
    }

    public boolean canWriteSequence() {
        return this.delegate.canWriteSequence();
    }

    public void prepareWriteSequence(IIOMetadata streamMetadata) throws IOException {
        this.delegate.prepareWriteSequence(streamMetadata);
    }

    public void writeToSequence(IIOImage image, ImageWriteParam param) throws IOException {
        this.delegate.writeToSequence(image, param);
    }

    public void endWriteSequence() throws IOException {
        this.delegate.endWriteSequence();
    }

    public boolean canReplaceStreamMetadata() throws IOException {
        return this.delegate.canReplaceStreamMetadata();
    }

    public void replaceStreamMetadata(IIOMetadata streamMetadata) throws IOException {
        this.delegate.replaceStreamMetadata(streamMetadata);
    }

    public boolean canReplaceImageMetadata(int imageIndex) throws IOException {
        return this.delegate.canReplaceImageMetadata(imageIndex);
    }

    public void replaceImageMetadata(int imageIndex, IIOMetadata imageMetadata) throws IOException {
        this.delegate.replaceImageMetadata(imageIndex, imageMetadata);
    }

    public boolean canInsertImage(int imageIndex) throws IOException {
        return this.delegate.canInsertImage(imageIndex);
    }

    public void writeInsert(int imageIndex, IIOImage image, ImageWriteParam param) throws IOException {
        this.delegate.writeInsert(imageIndex, image, param);
    }

    public boolean canRemoveImage(int imageIndex) throws IOException {
        return this.delegate.canRemoveImage(imageIndex);
    }

    public void removeImage(int imageIndex) throws IOException {
        this.delegate.removeImage(imageIndex);
    }

    public boolean canWriteEmpty() throws IOException {
        return this.delegate.canWriteEmpty();
    }

    public void prepareWriteEmpty(IIOMetadata streamMetadata, ImageTypeSpecifier imageType, int width, int height, IIOMetadata imageMetadata, List<? extends BufferedImage> thumbnails, ImageWriteParam param) throws IOException {
        this.delegate.prepareWriteEmpty(streamMetadata, imageType, width, height, imageMetadata, thumbnails, param);
    }

    public void endWriteEmpty() throws IOException {
        this.delegate.endWriteEmpty();
    }

    public boolean canInsertEmpty(int imageIndex) throws IOException {
        return this.delegate.canInsertEmpty(imageIndex);
    }

    public void prepareInsertEmpty(int imageIndex, ImageTypeSpecifier imageType, int width, int height, IIOMetadata imageMetadata, List<? extends BufferedImage> thumbnails, ImageWriteParam param) throws IOException {
        this.delegate.prepareInsertEmpty(imageIndex, imageType, width, height, imageMetadata, thumbnails, param);
    }

    public void endInsertEmpty() throws IOException {
        this.delegate.endInsertEmpty();
    }

    public boolean canReplacePixels(int imageIndex) throws IOException {
        return this.delegate.canReplacePixels(imageIndex);
    }

    public void prepareReplacePixels(int imageIndex, Rectangle region) throws IOException {
        this.delegate.prepareReplacePixels(imageIndex, region);
    }

    public void replacePixels(RenderedImage image, ImageWriteParam param) throws IOException {
        this.delegate.replacePixels(image, param);
    }

    public void replacePixels(Raster raster, ImageWriteParam param) throws IOException {
        this.delegate.replacePixels(raster, param);
    }

    public void endReplacePixels() throws IOException {
        this.delegate.endReplacePixels();
    }

    public void abort() {
        super.abort();
        this.delegate.abort();
    }

    public void reset() {
        super.reset();
        this.delegate.reset();
    }

    public void dispose() {
        super.dispose();
        this.delegate.dispose();
    }

    private class ProgressDelegator
    extends ProgressListenerBase
    implements IIOWriteWarningListener {
        private ProgressDelegator() {
        }

        public void imageComplete(ImageWriter source) {
            JPEGImageWriter.this.processImageComplete();
        }

        public void imageProgress(ImageWriter source, float percentageDone) {
            JPEGImageWriter.this.processImageProgress(percentageDone);
        }

        public void imageStarted(ImageWriter source, int imageIndex) {
            JPEGImageWriter.this.processImageStarted(imageIndex);
        }

        public void thumbnailComplete(ImageWriter source) {
            JPEGImageWriter.this.processThumbnailComplete();
        }

        public void thumbnailProgress(ImageWriter source, float percentageDone) {
            JPEGImageWriter.this.processThumbnailProgress(percentageDone);
        }

        public void thumbnailStarted(ImageWriter source, int imageIndex, int thumbnailIndex) {
            JPEGImageWriter.this.processThumbnailStarted(imageIndex, thumbnailIndex);
        }

        public void writeAborted(ImageWriter source) {
            JPEGImageWriter.this.processWriteAborted();
        }

        public void warningOccurred(ImageWriter source, int imageIndex, String warning) {
            JPEGImageWriter.this.processWarningOccurred(imageIndex, warning);
        }
    }
}

