/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata;

import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.lang.Validate;
import com.twelvemonkeys.util.CollectionUtil;
import java.lang.reflect.Array;
import java.util.Arrays;

public abstract class AbstractEntry
implements Entry {
    private final Object identifier;
    private final Object value;

    protected AbstractEntry(Object identifier, Object value) {
        Validate.notNull((Object)identifier, (String)"identifier");
        this.identifier = identifier;
        this.value = value;
    }

    public final Object getIdentifier() {
        return this.identifier;
    }

    protected String getNativeIdentifier() {
        return String.valueOf(this.getIdentifier());
    }

    public String getFieldName() {
        return null;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString() {
        if (this.valueCount() > 1) {
            if (this.valueCount() < 16) {
                return AbstractEntry.arrayToString(this.value);
            }
            String first = AbstractEntry.arrayToString(CollectionUtil.subArray((Object)this.value, (int)0, (int)4));
            String last = AbstractEntry.arrayToString(CollectionUtil.subArray((Object)this.value, (int)(this.valueCount() - 4), (int)4));
            return String.format("%s ... %s (%d)", first.substring(0, first.length() - 1), last.substring(1), this.valueCount());
        }
        if (this.value != null && this.value.getClass().isArray() && Array.getLength(this.value) == 1) {
            return String.valueOf(Array.get(this.value, 0));
        }
        return String.valueOf(this.value);
    }

    private static String arrayToString(Object value) {
        Class<?> type = value.getClass().getComponentType();
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                return Arrays.toString((boolean[])value);
            }
            if (type.equals(Byte.TYPE)) {
                return Arrays.toString((byte[])value);
            }
            if (type.equals(Character.TYPE)) {
                return new String((char[])value);
            }
            if (type.equals(Double.TYPE)) {
                return Arrays.toString((double[])value);
            }
            if (type.equals(Float.TYPE)) {
                return Arrays.toString((float[])value);
            }
            if (type.equals(Integer.TYPE)) {
                return Arrays.toString((int[])value);
            }
            if (type.equals(Long.TYPE)) {
                return Arrays.toString((long[])value);
            }
            if (type.equals(Short.TYPE)) {
                return Arrays.toString((short[])value);
            }
            throw new AssertionError((Object)("Unknown type: " + type));
        }
        return Arrays.toString((Object[])value);
    }

    public String getTypeName() {
        if (this.value == null) {
            return null;
        }
        return this.value.getClass().getSimpleName();
    }

    public int valueCount() {
        if (this.value != null && this.value.getClass().isArray()) {
            return Array.getLength(this.value);
        }
        return 1;
    }

    public int hashCode() {
        return this.identifier.hashCode() + (this.value != null ? 31 * this.value.hashCode() : 0);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (!(pOther instanceof AbstractEntry)) {
            return false;
        }
        AbstractEntry other = (AbstractEntry)pOther;
        return this.identifier.equals(other.identifier) && (this.value == null && other.value == null || this.value != null && this.value.equals(other.value));
    }

    public String toString() {
        String name = this.getFieldName();
        String nameStr = name != null ? "/" + name + "" : "";
        String type = this.getTypeName();
        String typeStr = type != null ? " (" + type + ")" : "";
        return String.format("%s%s: %s%s", this.getNativeIdentifier(), nameStr, this.getValueAsString(), typeStr);
    }
}

