/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.jpeg;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.exif.EXIFReader;
import com.twelvemonkeys.imageio.metadata.jpeg.JPEGSegment;
import com.twelvemonkeys.imageio.metadata.psd.PSDReader;
import com.twelvemonkeys.imageio.metadata.xmp.XMPReader;
import com.twelvemonkeys.lang.Validate;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPEGSegmentUtil {
    public static final List<String> ALL_IDS = Collections.unmodifiableList(new AllIdsList());
    public static final Map<Integer, List<String>> ALL_SEGMENTS = Collections.unmodifiableMap(new AllSegmentsMap());
    public static final Map<Integer, List<String>> APP_SEGMENTS = Collections.unmodifiableMap(new AllAppSegmentsMap());

    private JPEGSegmentUtil() {
    }

    public static List<JPEGSegment> readSegments(ImageInputStream stream, int marker, String identifier) throws IOException {
        return JPEGSegmentUtil.readSegments(stream, Collections.singletonMap(marker, identifier != null ? Collections.singletonList(identifier) : ALL_IDS));
    }

    public static List<JPEGSegment> readSegments(ImageInputStream stream, Map<Integer, List<String>> segmentIdentifiers) throws IOException {
        JPEGSegmentUtil.readSOI((ImageInputStream)Validate.notNull((Object)stream, (String)"stream"));
        List<JPEGSegment> segments = Collections.emptyList();
        try {
            JPEGSegment segment;
            while (!JPEGSegmentUtil.isImageDone(segment = JPEGSegmentUtil.readSegment(stream, segmentIdentifiers))) {
                if (!JPEGSegmentUtil.isRequested(segment, segmentIdentifiers)) continue;
                if (segments == Collections.EMPTY_LIST) {
                    segments = new ArrayList<JPEGSegment>();
                }
                segments.add(segment);
            }
        }
        catch (EOFException ignore) {
            // empty catch block
        }
        return segments;
    }

    private static boolean isRequested(JPEGSegment segment, Map<Integer, List<String>> segmentIdentifiers) {
        return segmentIdentifiers.containsKey(segment.marker) && (segment.identifier() == null && segmentIdentifiers.get(segment.marker) == null || JPEGSegmentUtil.containsSafe(segment, segmentIdentifiers));
    }

    private static boolean containsSafe(JPEGSegment segment, Map<Integer, List<String>> segmentIdentifiers) {
        List<String> identifiers = segmentIdentifiers.get(segment.marker);
        return identifiers != null && identifiers.contains(segment.identifier());
    }

    private static boolean isImageDone(JPEGSegment segment) {
        return segment.marker == 65498 || segment.marker == 65497 || segment.marker == 65496;
    }

    static String asNullTerminatedAsciiString(byte[] data, int offset) {
        for (int i = 0; i < data.length - offset; ++i) {
            if (data[offset + i] != 0 && i <= 255) continue;
            return JPEGSegmentUtil.asAsciiString(data, offset, offset + i);
        }
        return null;
    }

    static String asAsciiString(byte[] data, int offset, int length) {
        return new String(data, offset, length, Charset.forName("ascii"));
    }

    static void readSOI(ImageInputStream stream) throws IOException {
        if (stream.readUnsignedShort() != 65496) {
            throw new IIOException("Not a JPEG stream");
        }
    }

    static JPEGSegment readSegment(ImageInputStream stream, Map<Integer, List<String>> segmentIdentifiers) throws IOException {
        byte[] data;
        int marker = stream.readUnsignedShort();
        int length = stream.readUnsignedShort();
        if (segmentIdentifiers.containsKey(marker)) {
            data = new byte[length - 2];
            stream.readFully(data);
        } else if (JPEGSegment.isAppSegmentMarker(marker)) {
            int read;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(32);
            while ((read = stream.read()) > 0) {
                buffer.write(read);
            }
            data = buffer.toByteArray();
            stream.skipBytes(length - 3 - data.length);
        } else {
            data = null;
            stream.skipBytes(length - 2);
        }
        return new JPEGSegment(marker, data, length);
    }

    public static void main(String[] args) throws IOException {
        List<JPEGSegment> segments = JPEGSegmentUtil.readSegments(ImageIO.createImageInputStream(new File(args[0])), ALL_SEGMENTS);
        for (JPEGSegment segment : segments) {
            System.err.println("segment: " + segment);
            if ("Exif".equals(segment.identifier())) {
                InputStream data = segment.data();
                data.read();
                ImageInputStream stream = ImageIO.createImageInputStream(data);
                Directory tiff = new EXIFReader().read(stream);
                System.err.println("EXIF: " + tiff);
                continue;
            }
            if ("http://ns.adobe.com/xap/1.0/".equals(segment.identifier())) {
                Directory xmp = new XMPReader().read(ImageIO.createImageInputStream(segment.data()));
                System.err.println("XMP: " + xmp);
                continue;
            }
            if ("Photoshop 3.0".equals(segment.identifier())) {
                ImageInputStream stream = ImageIO.createImageInputStream(segment.data());
                Directory psd = new PSDReader().read(stream);
                System.err.println("PSD: " + psd);
                continue;
            }
            if ("ICC_PROFILE".equals(segment.identifier())) continue;
            System.err.println(EXIFReader.HexDump.dump(segment.data));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AllAppSegmentsMap
    extends HashMap<Integer, List<String>> {
        private AllAppSegmentsMap() {
        }

        @Override
        public String toString() {
            return "{All APPn segments}";
        }

        @Override
        public List<String> get(Object key) {
            return this.containsKey(key) ? ALL_IDS : null;
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof Integer && JPEGSegment.isAppSegmentMarker((Integer)key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AllSegmentsMap
    extends HashMap<Integer, List<String>> {
        private AllSegmentsMap() {
        }

        @Override
        public String toString() {
            return "{All segments}";
        }

        @Override
        public List<String> get(Object key) {
            return key instanceof Integer && JPEGSegment.isAppSegmentMarker((Integer)key) ? ALL_IDS : null;
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AllIdsList
    extends ArrayList<String> {
        private AllIdsList() {
        }

        @Override
        public String toString() {
            return "[All ids]";
        }

        @Override
        public boolean contains(Object o) {
            return true;
        }
    }
}

