/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.psd;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.MetadataReader;
import com.twelvemonkeys.imageio.metadata.psd.PSDDirectory;
import com.twelvemonkeys.imageio.metadata.psd.PSDEntry;
import com.twelvemonkeys.imageio.stream.SubImageInputStream;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.lang.Validate;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

public final class PSDReader
extends MetadataReader {
    public Directory read(ImageInputStream input) throws IOException {
        Validate.notNull((Object)input, (String)"input");
        ArrayList<PSDEntry> entries = new ArrayList<PSDEntry>();
        try {
            while (true) {
                int type;
                if ((type = input.readInt()) != 943868237) {
                    throw new IIOException(String.format("Wrong image resource type, expected '8BIM': '%08x'", type));
                }
                short id = input.readShort();
                PSDResource resource = new PSDResource(id, input);
                entries.add(new PSDEntry(id, resource.name(), resource.data()));
            }
        }
        catch (EOFException e) {
            return new PSDDirectory(entries);
        }
    }

    protected static class PSDResource {
        final short id;
        final String name;
        final long size;
        byte[] data;

        static String readPascalString(DataInput pInput) throws IOException {
            int length = pInput.readUnsignedByte();
            if (length == 0) {
                return "";
            }
            byte[] bytes = new byte[length];
            pInput.readFully(bytes);
            return StringUtil.decode((byte[])bytes, (int)0, (int)bytes.length, (String)"ASCII");
        }

        PSDResource(short resourceId, ImageInputStream input) throws IOException {
            this.id = resourceId;
            this.name = PSDResource.readPascalString(input);
            int nameSize = this.name.length() + 1;
            if (nameSize % 2 != 0) {
                input.readByte();
            }
            this.size = input.readUnsignedInt();
            long startPos = input.getStreamPosition();
            this.readData((ImageInputStream)new SubImageInputStream(input, this.size));
            if (input.getStreamPosition() != startPos + this.size) {
                input.seek(startPos + this.size);
            }
            if (this.size % 2L != 0L) {
                input.read();
            }
        }

        protected void readData(ImageInputStream pInput) throws IOException {
            this.data = new byte[(int)this.size];
            pInput.readFully(this.data);
        }

        public final byte[] data() {
            return this.data;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            StringBuilder builder = this.toStringBuilder();
            builder.append(", data length: ");
            builder.append(this.size);
            builder.append("]");
            return builder.toString();
        }

        protected StringBuilder toStringBuilder() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append("[ID: 0x");
            builder.append(Integer.toHexString(this.id));
            if (this.name != null && this.name.trim().length() != 0) {
                builder.append(", name: \"");
                builder.append(this.name);
                builder.append("\"");
            }
            return builder;
        }
    }
}

