/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.xmp;

import com.twelvemonkeys.imageio.metadata.AbstractEntry;
import com.twelvemonkeys.imageio.metadata.xmp.XMP;

final class XMPEntry
extends AbstractEntry {
    private final String fieldName;

    public XMPEntry(String identifier, Object pValue) {
        this(identifier, null, pValue);
    }

    public XMPEntry(String identifier, String fieldName, Object value) {
        super(identifier, value);
        this.fieldName = fieldName;
    }

    protected String getNativeIdentifier() {
        String identifier = (String)this.getIdentifier();
        String namespace = this.fieldName != null && identifier.endsWith(this.fieldName) ? XMP.DEFAULT_NS_MAPPING.get(identifier.substring(0, identifier.length() - this.fieldName.length())) : null;
        return namespace != null ? namespace + ":" + this.fieldName : identifier;
    }

    public String getFieldName() {
        return this.fieldName != null ? this.fieldName : XMP.DEFAULT_NS_MAPPING.get(this.getIdentifier());
    }

    public String toString() {
        String type = this.getTypeName();
        String typeStr = type != null ? " (" + type + ")" : "";
        return String.format("%s: %s%s", this.getNativeIdentifier(), this.getValueAsString(), typeStr);
    }
}

