/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.xmp;

import com.twelvemonkeys.imageio.stream.BufferedImageInputStream;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public final class XMPScanner {
    private static final byte[] XMP_PACKET_BEGIN = new byte[]{60, 63, 120, 112, 97, 99, 107, 101, 116, 32, 98, 101, 103, 105, 110, 61};
    private static final byte[] XMP_PACKET_END = new byte[]{60, 63, 120, 112, 97, 99, 107, 101, 116, 32, 101, 110, 100, 61};

    public static Reader scanForXMPPacket(Object pInput) throws IOException {
        byte quote;
        long pos;
        ImageInputStream stream;
        ImageInputStream imageInputStream = stream = pInput instanceof ImageInputStream ? (ImageInputStream)pInput : ImageIO.createImageInputStream(pInput);
        if (!(stream instanceof BufferedImageInputStream)) {
            stream = new BufferedImageInputStream(stream);
        }
        if ((pos = XMPScanner.scanForSequence(stream, XMP_PACKET_BEGIN)) >= 0L && ((quote = stream.readByte()) == 39 || quote == 34)) {
            Charset cs = null;
            byte[] bom = new byte[4];
            stream.readFully(bom);
            if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65 && bom[3] == quote || bom[0] == quote) {
                cs = Charset.forName("UTF-8");
            } else if (bom[0] == -2 && bom[1] == -1 && bom[2] == 0 && bom[3] == quote) {
                cs = Charset.forName("UTF-16BE");
            } else if (bom[0] == 0 && bom[1] == -1 && bom[2] == -2 && bom[3] == quote) {
                stream.skipBytes(1);
                cs = Charset.forName("UTF-16LE");
            } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                cs = Charset.forName("UTF-32BE");
            } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == 0 && bom[3] == -1 && stream.read() == 254) {
                stream.skipBytes(2);
                cs = Charset.forName("UTF-32LE");
            }
            if (cs != null) {
                stream.mark();
                long end = XMPScanner.scanForSequence(stream, XMP_PACKET_END);
                stream.reset();
                long length = end - stream.getStreamPosition();
                InputStreamReader reader = new InputStreamReader(IIOUtil.createStreamAdapter((ImageInputStream)stream, (long)length), cs);
                while (((Reader)reader).read() != 62) {
                }
                return reader;
            }
        }
        return null;
    }

    private static long scanForSequence(ImageInputStream pStream, byte[] pSequence) throws IOException {
        int read;
        long start = -1L;
        int index = 0;
        int nullBytes = 0;
        while ((read = pStream.read()) >= 0) {
            if (pSequence[index] == (byte)read) {
                if (start == -1L) {
                    start = pStream.getStreamPosition() - 1L;
                }
                if (nullBytes == 1 || nullBytes == 3) {
                    pStream.skipBytes(nullBytes);
                }
                if (++index != pSequence.length) continue;
                return start;
            }
            if (index == 1 && read == 0 && nullBytes < 3) {
                ++nullBytes;
                continue;
            }
            if (index == 0) continue;
            index = 0;
            start = -1L;
            nullBytes = 0;
        }
        return -1L;
    }

    public static void main(String[] pArgs) throws IOException {
        Reader xmp;
        ImageInputStream stream = ImageIO.createImageInputStream(new File(pArgs[0]));
        while ((xmp = XMPScanner.scanForXMPPacket(stream)) != null) {
            String line;
            BufferedReader reader = new BufferedReader(xmp);
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
        stream.close();
    }
}

