/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.SlackAttachment;
import com.ullink.slack.simpleslackapi.SlackBot;
import com.ullink.slack.simpleslackapi.SlackChannel;
import com.ullink.slack.simpleslackapi.SlackMessageHandle;
import com.ullink.slack.simpleslackapi.SlackPersona;
import com.ullink.slack.simpleslackapi.SlackSession;
import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.impl.SlackChannelImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChatConfiguration;
import com.ullink.slack.simpleslackapi.impl.SlackReplyListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelArchivedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelCreatedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelDeletedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelRenamedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelUnarchivedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackConnectedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackGroupJoinedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackMessageDeletedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackMessagePostedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackMessageUpdatedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractSlackSessionImpl
implements SlackSession {
    protected Map<String, SlackChannel> channels = new HashMap<String, SlackChannel>();
    protected Map<String, SlackUser> users = new HashMap<String, SlackUser>();
    protected SlackPersona sessionPersona;
    protected List<SlackChannelArchivedListener> channelArchiveListener = new ArrayList<SlackChannelArchivedListener>();
    protected List<SlackChannelCreatedListener> channelCreateListener = new ArrayList<SlackChannelCreatedListener>();
    protected List<SlackChannelDeletedListener> channelDeleteListener = new ArrayList<SlackChannelDeletedListener>();
    protected List<SlackChannelRenamedListener> channelRenamedListener = new ArrayList<SlackChannelRenamedListener>();
    protected List<SlackChannelUnarchivedListener> channelUnarchiveListener = new ArrayList<SlackChannelUnarchivedListener>();
    protected List<SlackGroupJoinedListener> groupJoinedListener = new ArrayList<SlackGroupJoinedListener>();
    protected List<SlackMessageDeletedListener> messageDeletedListener = new ArrayList<SlackMessageDeletedListener>();
    protected List<SlackMessagePostedListener> messagePostedListener = new ArrayList<SlackMessagePostedListener>();
    protected List<SlackMessageUpdatedListener> messageUpdatedListener = new ArrayList<SlackMessageUpdatedListener>();
    protected List<SlackReplyListener> slackReplyListener = new ArrayList<SlackReplyListener>();
    protected List<SlackConnectedListener> slackConnectedLinster = new ArrayList<SlackConnectedListener>();
    static final SlackChatConfiguration DEFAULT_CONFIGURATION = SlackChatConfiguration.getConfiguration().asUser();

    AbstractSlackSessionImpl() {
    }

    @Override
    public Collection<SlackChannel> getChannels() {
        return new ArrayList<SlackChannel>(this.channels.values());
    }

    @Override
    public Collection<SlackUser> getUsers() {
        return new ArrayList<SlackUser>(this.users.values());
    }

    @Override
    @Deprecated
    public Collection<SlackBot> getBots() {
        ArrayList<SlackBot> toReturn = new ArrayList<SlackBot>();
        for (SlackUser user : this.users.values()) {
            if (!user.isBot()) continue;
            toReturn.add(user);
        }
        return toReturn;
    }

    @Override
    public SlackChannel findChannelByName(String channelName) {
        for (SlackChannel channel : this.channels.values()) {
            if (!channelName.equals(channel.getName())) continue;
            return channel;
        }
        return null;
    }

    @Override
    public SlackChannel findChannelById(String channelId) {
        SlackChannel toReturn = this.channels.get(channelId);
        if (toReturn == null && channelId != null && channelId.startsWith("D")) {
            toReturn = new SlackChannelImpl(channelId, "", "", "", true);
        }
        return toReturn;
    }

    @Override
    public SlackUser findUserById(String userId) {
        return this.users.get(userId);
    }

    @Override
    public SlackUser findUserByUserName(String userName) {
        for (SlackUser user : this.users.values()) {
            if (!userName.equals(user.getUserName())) continue;
            return user;
        }
        return null;
    }

    @Override
    public SlackUser findUserByEmail(String userMail) {
        for (SlackUser user : this.users.values()) {
            if (!userMail.equals(user.getUserMail())) continue;
            return user;
        }
        return null;
    }

    @Override
    public SlackPersona sessionPersona() {
        return this.sessionPersona;
    }

    @Override
    @Deprecated
    public SlackBot findBotById(String botId) {
        return this.users.get(botId);
    }

    @Override
    public SlackMessageHandle sendMessage(SlackChannel channel, String message, SlackAttachment attachment) {
        return this.sendMessage(channel, message, attachment, DEFAULT_CONFIGURATION);
    }

    @Override
    public void addchannelArchivedListener(SlackChannelArchivedListener listener) {
        this.channelArchiveListener.add(listener);
    }

    @Override
    public void removeChannelArchivedListener(SlackChannelArchivedListener listener) {
        this.channelArchiveListener.remove(listener);
    }

    @Override
    public void addchannelCreatedListener(SlackChannelCreatedListener listener) {
        this.channelCreateListener.add(listener);
    }

    @Override
    public void removeChannelCreatedListener(SlackChannelCreatedListener listener) {
        this.channelCreateListener.remove(listener);
    }

    @Override
    public void addchannelDeletedListener(SlackChannelDeletedListener listener) {
        this.channelDeleteListener.add(listener);
    }

    @Override
    public void removeChannelDeletedListener(SlackChannelDeletedListener listener) {
        this.channelDeleteListener.remove(listener);
    }

    @Override
    public void addChannelRenamedListener(SlackChannelRenamedListener listener) {
        this.channelRenamedListener.add(listener);
    }

    @Override
    public void removeChannelRenamedListener(SlackChannelRenamedListener listener) {
        this.channelRenamedListener.remove(listener);
    }

    @Override
    public void addChannelUnarchivedListener(SlackChannelUnarchivedListener listener) {
        this.channelUnarchiveListener.add(listener);
    }

    @Override
    public void removeChannelUnarchivedListener(SlackChannelUnarchivedListener listener) {
        this.channelUnarchiveListener.remove(listener);
    }

    @Override
    public void addMessageDeletedListener(SlackMessageDeletedListener listener) {
        this.messageDeletedListener.add(listener);
    }

    @Override
    public void removeMessageDeletedListener(SlackMessageDeletedListener listener) {
        this.messageDeletedListener.remove(listener);
    }

    @Override
    public void addMessagePostedListener(SlackMessagePostedListener listener) {
        this.messagePostedListener.add(listener);
    }

    @Override
    public void removeMessagePostedListener(SlackMessagePostedListener listener) {
        this.messagePostedListener.remove(listener);
    }

    @Override
    public void addMessageUpdatedListener(SlackMessageUpdatedListener listener) {
        this.messageUpdatedListener.add(listener);
    }

    @Override
    public void removeMessageUpdatedListener(SlackMessageUpdatedListener listener) {
        this.messageUpdatedListener.remove(listener);
    }

    @Override
    public void addGroupJoinedListener(SlackGroupJoinedListener listener) {
        this.groupJoinedListener.add(listener);
    }

    @Override
    public void removeGroupJoinedListener(SlackGroupJoinedListener listener) {
        this.groupJoinedListener.remove(listener);
    }

    void addSlackReplyListener(SlackReplyListener listener) {
        this.slackReplyListener.add(listener);
    }

    void removeSlackReplyListener(SlackReplyListener listener) {
        this.slackReplyListener.remove(listener);
    }
}

