/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.SlackChannel;
import com.ullink.slack.simpleslackapi.SlackSession;
import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.events.EventType;
import com.ullink.slack.simpleslackapi.events.SlackChannelArchived;
import com.ullink.slack.simpleslackapi.events.SlackChannelCreated;
import com.ullink.slack.simpleslackapi.events.SlackChannelDeleted;
import com.ullink.slack.simpleslackapi.events.SlackChannelRenamed;
import com.ullink.slack.simpleslackapi.events.SlackChannelUnarchived;
import com.ullink.slack.simpleslackapi.events.SlackEvent;
import com.ullink.slack.simpleslackapi.events.SlackGroupJoined;
import com.ullink.slack.simpleslackapi.impl.SlackChannelArchivedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelCreatedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelDeletedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelRenamedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelUnarchivedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackGroupJoinedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackMessageDeletedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackMessagePostedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackMessageUpdatedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackReplyImpl;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;

class SlackJSONMessageParser {
    SlackJSONMessageParser() {
    }

    static SlackEvent decode(SlackSession slackSession, JSONObject obj) {
        String type = (String)obj.get((Object)"type");
        if (type == null) {
            return SlackJSONMessageParser.parseSlackReply(obj);
        }
        EventType eventType = EventType.getByCode(type);
        switch (eventType) {
            case MESSAGE: {
                return SlackJSONMessageParser.extractMessageEvent(slackSession, obj);
            }
            case CHANNEL_CREATED: {
                return SlackJSONMessageParser.extractChannelCreatedEvent(slackSession, obj);
            }
            case CHANNEL_ARCHIVE: {
                return SlackJSONMessageParser.extractChannelArchiveEvent(slackSession, obj);
            }
            case CHANNEL_DELETED: {
                return SlackJSONMessageParser.extractChannelDeletedEvent(slackSession, obj);
            }
            case CHANNEL_RENAME: {
                return SlackJSONMessageParser.extractChannelRenamedEvent(slackSession, obj);
            }
            case CHANNEL_UNARCHIVE: {
                return SlackJSONMessageParser.extractChannelUnarchiveEvent(slackSession, obj);
            }
            case GROUP_JOINED: {
                return SlackJSONMessageParser.extractGroupJoinedEvent(slackSession, obj);
            }
        }
        return SlackEvent.UNKNOWN_EVENT;
    }

    private static SlackGroupJoined extractGroupJoinedEvent(SlackSession slackSession, JSONObject obj) {
        JSONObject channelJSONObject = (JSONObject)obj.get((Object)"channel");
        SlackChannel slackChannel = SlackJSONMessageParser.parseChannelDescription(channelJSONObject);
        return new SlackGroupJoinedImpl(slackChannel);
    }

    private static SlackChannelRenamed extractChannelRenamedEvent(SlackSession slackSession, JSONObject obj) {
        String channelId = (String)obj.get((Object)"channel");
        String newName = (String)obj.get((Object)"name");
        return new SlackChannelRenamedImpl(slackSession.findChannelById(channelId), newName);
    }

    private static SlackChannelDeleted extractChannelDeletedEvent(SlackSession slackSession, JSONObject obj) {
        String channelId = (String)obj.get((Object)"channel");
        return new SlackChannelDeletedImpl(slackSession.findChannelById(channelId));
    }

    private static SlackChannelUnarchived extractChannelUnarchiveEvent(SlackSession slackSession, JSONObject obj) {
        String channelId = (String)obj.get((Object)"channel");
        String userId = (String)obj.get((Object)"user");
        return new SlackChannelUnarchivedImpl(slackSession.findChannelById(channelId), slackSession.findUserById(userId));
    }

    private static SlackChannelArchived extractChannelArchiveEvent(SlackSession slackSession, JSONObject obj) {
        String channelId = (String)obj.get((Object)"channel");
        String userId = (String)obj.get((Object)"user");
        return new SlackChannelArchivedImpl(slackSession.findChannelById(channelId), slackSession.findUserById(userId));
    }

    private static SlackChannelCreated extractChannelCreatedEvent(SlackSession slackSession, JSONObject obj) {
        JSONObject channelJSONObject = (JSONObject)obj.get((Object)"channel");
        SlackChannel channel = SlackJSONMessageParser.parseChannelDescription(channelJSONObject);
        String creatorId = (String)channelJSONObject.get((Object)"creator");
        SlackUser user = slackSession.findUserById(creatorId);
        return new SlackChannelCreatedImpl(channel, user);
    }

    private static SlackEvent extractMessageEvent(SlackSession slackSession, JSONObject obj) {
        String channelId = (String)obj.get((Object)"channel");
        SlackChannel channel = SlackJSONMessageParser.getChannel(slackSession, channelId);
        String ts = (String)obj.get((Object)"ts");
        SlackMessageSubType subType = SlackMessageSubType.getByCode((String)obj.get((Object)"subtype"));
        switch (subType) {
            case MESSAGE_CHANGED: {
                return SlackJSONMessageParser.parseMessageUpdated(obj, channel, ts);
            }
            case MESSAGE_DELETED: {
                return SlackJSONMessageParser.parseMessageDeleted(obj, channel, ts);
            }
            case BOT_MESSAGE: {
                return SlackJSONMessageParser.parseBotMessage(obj, channel, ts, slackSession);
            }
        }
        return SlackJSONMessageParser.parseMessagePublished(obj, channel, ts, slackSession);
    }

    private static SlackEvent parseSlackReply(JSONObject obj) {
        Boolean ok = (Boolean)obj.get((Object)"ok");
        Long replyTo = (Long)obj.get((Object)"reply_to");
        String timestamp = (String)obj.get((Object)"ts");
        return new SlackReplyImpl(ok, replyTo != null ? replyTo : -1L, timestamp);
    }

    private static SlackChannel getChannel(SlackSession slackSession, String channelId) {
        if (channelId != null) {
            if (channelId.startsWith("D")) {
                return new SlackChannelImpl(channelId, channelId, "", "", true);
            }
            return slackSession.findChannelById(channelId);
        }
        return null;
    }

    private static SlackMessageUpdatedImpl parseMessageUpdated(JSONObject obj, SlackChannel channel, String ts) {
        JSONObject message = (JSONObject)obj.get((Object)"message");
        String text = (String)message.get((Object)"text");
        String messageTs = (String)message.get((Object)"ts");
        SlackMessageUpdatedImpl toto = new SlackMessageUpdatedImpl(channel, messageTs, ts, text);
        return toto;
    }

    private static SlackMessageDeletedImpl parseMessageDeleted(JSONObject obj, SlackChannel channel, String ts) {
        String deletedTs = (String)obj.get((Object)"deleted_ts");
        return new SlackMessageDeletedImpl(channel, deletedTs, ts);
    }

    private static SlackMessagePostedImpl parseBotMessage(JSONObject obj, SlackChannel channel, String ts, SlackSession slackSession) {
        String text = (String)obj.get((Object)"text");
        String botId = (String)obj.get((Object)"bot_id");
        SlackUser user = slackSession.findUserById(botId);
        return new SlackMessagePostedImpl(text, user, user, channel, ts);
    }

    private static SlackMessagePostedImpl parseMessagePublished(JSONObject obj, SlackChannel channel, String ts, SlackSession slackSession) {
        String text = (String)obj.get((Object)"text");
        String userId = (String)obj.get((Object)"user");
        SlackUser user = slackSession.findUserById(userId);
        return new SlackMessagePostedImpl(text, user, user, channel, ts);
    }

    private static SlackChannel parseChannelDescription(JSONObject channelJSONObject) {
        String id = (String)channelJSONObject.get((Object)"id");
        String name = (String)channelJSONObject.get((Object)"name");
        String topic = null;
        String purpose = null;
        return new SlackChannelImpl(id, name, topic, purpose, true);
    }

    public static enum SlackMessageSubType {
        CHANNEL_JOIN("channel_join"),
        MESSAGE_CHANGED("message_changed"),
        MESSAGE_DELETED("message_deleted"),
        BOT_MESSAGE("bot_message"),
        OTHER("-");

        private static final Map<String, SlackMessageSubType> CODE_MAP;
        String code;

        public static SlackMessageSubType getByCode(String code) {
            SlackMessageSubType toReturn = CODE_MAP.get(code);
            if (toReturn == null) {
                return OTHER;
            }
            return toReturn;
        }

        private SlackMessageSubType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        static {
            CODE_MAP = new HashMap<String, SlackMessageSubType>();
            for (SlackMessageSubType enumValue : SlackMessageSubType.values()) {
                CODE_MAP.put(enumValue.getCode(), enumValue);
            }
        }
    }
}

