/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.impl.SlackChannelImpl;
import com.ullink.slack.simpleslackapi.impl.SlackUserImpl;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class SlackJSONParsingUtils {
    private SlackJSONParsingUtils() {
    }

    static final SlackUser buildSlackUser(JSONObject jsonUser) {
        String id = (String)jsonUser.get((Object)"id");
        String name = (String)jsonUser.get((Object)"name");
        String realName = (String)jsonUser.get((Object)"real_name");
        String tz = (String)jsonUser.get((Object)"tz");
        String tzLabel = (String)jsonUser.get((Object)"tz_label");
        Long tzOffset = (Long)jsonUser.get((Object)"tz_offset");
        Boolean deleted = SlackJSONParsingUtils.ifNullFalse(jsonUser, "deleted");
        Boolean admin = SlackJSONParsingUtils.ifNullFalse(jsonUser, "is_admin");
        Boolean owner = SlackJSONParsingUtils.ifNullFalse(jsonUser, "is_owner");
        Boolean primaryOwner = SlackJSONParsingUtils.ifNullFalse(jsonUser, "is_primary_owner");
        Boolean restricted = SlackJSONParsingUtils.ifNullFalse(jsonUser, "is_restricted");
        Boolean ultraRestricted = SlackJSONParsingUtils.ifNullFalse(jsonUser, "is_ultra_restricted");
        Boolean bot = SlackJSONParsingUtils.ifNullFalse(jsonUser, "is_bot");
        JSONObject profileJSON = (JSONObject)jsonUser.get((Object)"profile");
        String email = "";
        if (profileJSON != null) {
            email = (String)profileJSON.get((Object)"email");
        }
        return new SlackUserImpl(id, name, realName, email, deleted, admin, owner, primaryOwner, restricted, ultraRestricted, bot, tz, tzLabel, tzOffset == null ? null : new Integer(tzOffset.intValue()));
    }

    private static Boolean ifNullFalse(JSONObject jsonUser, String field) {
        Boolean deleted = (Boolean)jsonUser.get((Object)field);
        if (deleted == null) {
            deleted = false;
        }
        return deleted;
    }

    static final SlackChannelImpl buildSlackChannel(JSONObject jsonChannel, Map<String, SlackUser> knownUsersById) {
        String id = (String)jsonChannel.get((Object)"id");
        String name = (String)jsonChannel.get((Object)"name");
        String topic = null;
        String purpose = null;
        SlackChannelImpl toReturn = new SlackChannelImpl(id, name, topic, purpose, false);
        JSONArray membersJson = (JSONArray)jsonChannel.get((Object)"members");
        if (membersJson != null) {
            for (Object jsonMembersObject : membersJson) {
                String memberId = (String)jsonMembersObject;
                SlackUser user = knownUsersById.get(memberId);
                toReturn.addUser(user);
            }
        }
        return toReturn;
    }

    static final SlackChannelImpl buildSlackImChannel(JSONObject jsonChannel, Map<String, SlackUser> knownUsersById) {
        String id = (String)jsonChannel.get((Object)"id");
        SlackChannelImpl toReturn = new SlackChannelImpl(id, null, null, null, true);
        String memberId = (String)jsonChannel.get((Object)"user");
        SlackUser user = knownUsersById.get(memberId);
        toReturn.addUser(user);
        return toReturn;
    }
}

