/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.demos;

import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class DecodeAndCaptureFrames {
    public static final double SECONDS_BETWEEN_FRAMES = 5.0;
    public static final long NANO_SECONDS_BETWEEN_FRAMES = (long)((double)Global.DEFAULT_PTS_PER_SECOND * 5.0);
    private static long mLastPtsWrite = Global.NO_PTS;

    private static void processFrame(IVideoPicture picture, BufferedImage image) {
        try {
            if (mLastPtsWrite == Global.NO_PTS) {
                mLastPtsWrite = picture.getPts() - NANO_SECONDS_BETWEEN_FRAMES;
            }
            if (picture.getPts() - mLastPtsWrite >= NANO_SECONDS_BETWEEN_FRAMES) {
                File file = File.createTempFile("frame", ".png");
                ImageIO.write((RenderedImage)image, "png", file);
                double seconds = (double)picture.getPts() / (double)Global.DEFAULT_PTS_PER_SECOND;
                System.out.printf("at elapsed time of %6.3f seconds wrote: %s\n", seconds, file);
                mLastPtsWrite += NANO_SECONDS_BETWEEN_FRAMES;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            throw new IllegalArgumentException("must pass in a filename as the first argument");
        }
        String filename = args[0];
        if (!IVideoResampler.isSupported(IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            throw new RuntimeException("you must install the GPL version of Xuggler (with IVideoResampler support) for this demo to work");
        }
        IContainer container = IContainer.make();
        if (container.open(filename, IContainer.Type.READ, null) < 0) {
            throw new IllegalArgumentException("could not open file: " + filename);
        }
        int numStreams = container.getNumStreams();
        int videoStreamId = -1;
        IStreamCoder videoCoder = null;
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = container.getStream(i);
            IStreamCoder coder = stream.getStreamCoder();
            if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            videoStreamId = i;
            videoCoder = coder;
            break;
        }
        if (videoStreamId == -1) {
            throw new RuntimeException("could not find video stream in container: " + filename);
        }
        if (videoCoder.open() < 0) {
            throw new RuntimeException("could not open video decoder for container: " + filename);
        }
        IVideoResampler resampler = null;
        if (videoCoder.getPixelType() != IPixelFormat.Type.BGR24 && (resampler = IVideoResampler.make(videoCoder.getWidth(), videoCoder.getHeight(), IPixelFormat.Type.BGR24, videoCoder.getWidth(), videoCoder.getHeight(), videoCoder.getPixelType())) == null) {
            throw new RuntimeException("could not create color space resampler for: " + filename);
        }
        IPacket packet = IPacket.make();
        while (container.readNextPacket(packet) >= 0) {
            int bytesDecoded;
            if (packet.getStreamIndex() != videoStreamId) continue;
            IVideoPicture picture = IVideoPicture.make(videoCoder.getPixelType(), videoCoder.getWidth(), videoCoder.getHeight());
            for (int offset = 0; offset < packet.getSize(); offset += bytesDecoded) {
                bytesDecoded = videoCoder.decodeVideo(picture, packet, offset);
                if (bytesDecoded >= 0) continue;
                throw new RuntimeException("got error decoding video in: " + filename);
            }
        }
        if (videoCoder != null) {
            videoCoder.close();
            videoCoder = null;
        }
        if (container != null) {
            container.close();
            container = null;
        }
    }
}

