/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.video;

import com.xuggle.ferry.JNIReference;
import com.xuggle.xuggler.IMediaData;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.AConverter;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.atomic.AtomicReference;

public class BgrConverter
extends AConverter {
    private static final int[] mBandOffsets = new int[]{2, 1, 0};
    private static final ColorSpace mColorSpace = ColorSpace.getInstance(1000);

    public BgrConverter(IPixelFormat.Type pictureType, int pictureWidth, int pictureHeight, int imageWidth, int imageHeight) {
        super(pictureType, IPixelFormat.Type.BGR24, 5, pictureWidth, pictureHeight, imageWidth, imageHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVideoPicture toPicture(BufferedImage image, long timestamp) {
        this.validateImage(image);
        DataBuffer imageBuffer = image.getRaster().getDataBuffer();
        byte[] imageBytes = null;
        int[] imageInts = null;
        if (imageBuffer instanceof DataBufferByte) {
            imageBytes = ((DataBufferByte)imageBuffer).getData();
        } else if (imageBuffer instanceof DataBufferInt) {
            imageInts = ((DataBufferInt)imageBuffer).getData();
        } else {
            throw new IllegalArgumentException("Unsupported BufferedImage data buffer type: " + imageBuffer.getDataType());
        }
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        IMediaData resamplePicture = null;
        try {
            IVideoPicture picture = IVideoPicture.make(this.getRequiredPictureType(), image.getWidth(), image.getHeight());
            ByteBuffer pictureByteBuffer = picture.getByteBuffer(ref);
            if (imageInts != null) {
                pictureByteBuffer.order(ByteOrder.BIG_ENDIAN);
                IntBuffer pictureIntBuffer = pictureByteBuffer.asIntBuffer();
                pictureIntBuffer.put(imageInts);
            } else {
                pictureByteBuffer.put(imageBytes);
            }
            pictureByteBuffer = null;
            picture.setComplete(true, this.getRequiredPictureType(), image.getWidth(), image.getHeight(), timestamp);
            if (this.willResample()) {
                resamplePicture = picture;
                picture = BgrConverter.resample((IVideoPicture)resamplePicture, this.mToPictureResampler);
            }
            IVideoPicture iVideoPicture = picture;
            return iVideoPicture;
        }
        finally {
            if (resamplePicture != null) {
                resamplePicture.delete();
            }
            if (ref.get() != null) {
                ((JNIReference)ref.get()).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage toImage(IVideoPicture picture) {
        this.validatePicture((IVideoPicture)picture);
        IMediaData resamplePicture = null;
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        try {
            if (this.willResample()) {
                picture = resamplePicture = BgrConverter.resample((IVideoPicture)picture, this.mToImageResampler);
            }
            int w = ((IVideoPicture)picture).getWidth();
            int h = ((IVideoPicture)picture).getHeight();
            ByteBuffer byteBuf = picture.getByteBuffer(ref);
            byte[] bytes = new byte[((IVideoPicture)picture).getSize()];
            byteBuf.get(bytes, 0, bytes.length);
            DataBufferByte db = new DataBufferByte(bytes, bytes.length);
            PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), w, h, 3, 3 * w, mBandOffsets);
            WritableRaster wr = Raster.createWritableRaster(sm, db, null);
            ComponentColorModel colorModel = new ComponentColorModel(mColorSpace, false, false, 1, db.getDataType());
            BufferedImage bufferedImage = new BufferedImage(colorModel, wr, false, null);
            return bufferedImage;
        }
        finally {
            if (resamplePicture != null) {
                resamplePicture.delete();
            }
            if (ref.get() != null) {
                ((JNIReference)ref.get()).delete();
            }
        }
    }

    public void delete() {
        super.close();
    }
}

