/*
 * Decompiled with CFR 0.152.
 */
package org.m2latex.mojo;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.m2latex.mojo.CommandExecutorImpl;
import org.m2latex.mojo.LatexProcessor;
import org.m2latex.mojo.Settings;
import org.m2latex.mojo.TexFileUtils;
import org.m2latex.mojo.TexFileUtilsImpl;

public abstract class AbstractLatexMojo
extends AbstractMojo {
    protected File baseDirectory;
    protected File targetDirectory;
    protected File targetSiteDirectory;
    protected Settings settings;
    protected LatexProcessor latexProcessor;
    protected TexFileUtils fileUtils;
    protected Log log;

    protected void cleanUp() {
        this.getLog().debug((CharSequence)("Deleting temporary directory " + this.settings.getTempDirectory().getPath()));
        try {
            FileUtils.deleteDirectory((File)this.settings.getTempDirectory());
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("The temporary directory '" + this.settings.getTempDirectory() + "' could be deleted."), (Throwable)e);
        }
    }

    protected void initialize() {
        if (this.settings == null) {
            this.settings = new Settings();
        }
        this.settings.setBaseDirectory(this.baseDirectory).setTargetSiteDirectory(this.targetSiteDirectory).setTargetDirectory(this.targetDirectory);
        this.log = this.getLog();
        this.fileUtils = new TexFileUtilsImpl(this.log);
        this.latexProcessor = new LatexProcessor(this.settings, new CommandExecutorImpl(this.log), this.log, this.fileUtils);
    }
}

