/*
 * Decompiled with CFR 0.152.
 */
package org.m2latex.mojo;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.m2latex.mojo.AbstractLatexMojo;

public class LatexMojo
extends AbstractLatexMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initialize();
        File texDirectory = this.settings.getTexDirectory();
        if (!texDirectory.exists()) {
            this.log.info((CharSequence)"No tex directory - skipping LaTeX processing");
            return;
        }
        try {
            this.fileUtils.copyLatexSrcToTempDir(texDirectory, this.settings.getTempDirectory());
            List latexMainFiles = this.fileUtils.getLatexMainDocuments(this.settings.getTempDirectory());
            Iterator iterator = latexMainFiles.iterator();
            while (iterator.hasNext()) {
                File texFile = (File)iterator.next();
                this.latexProcessor.processLatex(texFile);
                this.fileUtils.copyLatexOutputToOutputFolder(texFile, this.settings.getTempDirectory(), this.settings.getOutputDirectory());
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error executing command", (Exception)((Object)e));
        }
        finally {
            if (this.settings.isCleanUp()) {
                this.cleanUp();
            }
        }
    }
}

