/*
 * Decompiled with CFR 0.152.
 */
package org.m2latex.mojo;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.m2latex.mojo.CommandExecutor;
import org.m2latex.mojo.Settings;
import org.m2latex.mojo.TexFileUtils;

public class LatexProcessor {
    static final String PATTERN_NEED_ANOTHER_LATEX_RUN = "(Rerun (LaTeX|to get cross-references right)|There were undefined references|Package natbib Warning: Citation\\(s\\) may have changed)";
    private final Settings settings;
    private final Log log;
    private final CommandExecutor executor;
    private TexFileUtils fileUtils;

    public LatexProcessor(Settings settings, CommandExecutor executor, Log log, TexFileUtils fileUtils) {
        this.settings = settings;
        this.executor = executor;
        this.log = log;
        this.fileUtils = fileUtils;
    }

    public void processLatex(File texFile) throws CommandLineException, MojoExecutionException {
        this.log.info((CharSequence)("Processing LaTeX file " + texFile));
        this.runLatex(texFile);
        if (this.needBibtexRun(texFile)) {
            this.runBibtex(texFile);
        }
        for (int retries = 0; retries < 5 && this.needAnotherLatexRun(texFile); ++retries) {
            this.log.debug((CharSequence)"Latex must be rerun");
            this.runLatex(texFile);
        }
    }

    public void processTex4ht(File texFile) throws MojoExecutionException, CommandLineException {
        this.processLatex(texFile);
        this.runTex4ht(texFile);
    }

    private void runTex4ht(File texFile) throws CommandLineException, MojoExecutionException {
        this.log.debug((CharSequence)("Running " + this.settings.getTex4htCommand() + " on file " + texFile.getName()));
        File workingDir = texFile.getParentFile();
        String[] args = this.buildHtlatexArguments(texFile);
        this.executor.execute(workingDir, this.settings.getTexPath(), this.settings.getTex4htCommand(), args);
    }

    private String[] buildHtlatexArguments(File texFile) throws MojoExecutionException {
        File tex4htOutdir = this.fileUtils.createTex4htOutputDir(this.settings.getTempDirectory());
        String argOutputDir = " -d" + tex4htOutdir.getAbsolutePath() + File.separatorChar;
        String[] tex4htCommandArgs = this.settings.getTex4htCommandArgs();
        String htlatexOptions = this.getTex4htArgument(tex4htCommandArgs, 0);
        String tex4htOptions = this.getTex4htArgument(tex4htCommandArgs, 1);
        String t4htOptions = this.getTex4htArgument(tex4htCommandArgs, 2) + argOutputDir;
        String latexOptions = this.getTex4htArgument(tex4htCommandArgs, 3);
        String[] args = new String[]{texFile.getName(), htlatexOptions, tex4htOptions, t4htOptions, latexOptions};
        return args;
    }

    private String getTex4htArgument(String[] args, int index) {
        boolean returnEmptyArg = args == null || args.length < index + 1 || StringUtils.isEmpty((String)args[index]);
        return returnEmptyArg ? "" : args[index];
    }

    private boolean needAnotherLatexRun(File texFile) throws MojoExecutionException {
        String reRunPattern = PATTERN_NEED_ANOTHER_LATEX_RUN;
        boolean needRun = this.fileUtils.matchInCorrespondingLogFile(texFile, reRunPattern);
        this.log.debug((CharSequence)("Another Latex run? " + needRun));
        return needRun;
    }

    private boolean needBibtexRun(File texFile) throws MojoExecutionException {
        String namePrefixTexFile = this.fileUtils.getFileNameWithoutSuffix(texFile);
        String pattern = "No file " + namePrefixTexFile + ".bbl";
        return this.fileUtils.matchInCorrespondingLogFile(texFile, pattern);
    }

    private void runBibtex(File texFile) throws CommandLineException {
        this.log.debug((CharSequence)("Running BibTeX on file " + texFile.getName()));
        File workingDir = texFile.getParentFile();
        String[] args = new String[]{this.fileUtils.getCorrespondingAuxFile(texFile).getPath()};
        this.executor.execute(workingDir, this.settings.getTexPath(), this.settings.getBibtexCommand(), args);
    }

    private void runLatex(File texFile) throws CommandLineException {
        this.log.debug((CharSequence)("Running " + this.settings.getTexCommand() + " on file " + texFile.getName()));
        File workingDir = texFile.getParentFile();
        String[] texCommandArgs = this.settings.getTexCommandArgs();
        String[] args = new String[texCommandArgs.length + 1];
        System.arraycopy(texCommandArgs, 0, args, 0, texCommandArgs.length);
        args[texCommandArgs.length] = texFile.getName();
        this.executor.execute(workingDir, this.settings.getTexPath(), this.settings.getTexCommand(), args);
    }
}

