/*
 * Decompiled with CFR 0.152.
 */
package org.m2latex.mojo;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class Settings {
    private File baseDirectory;
    private File targetSiteDirectory;
    private File targetDirectory;
    private String tempDirectory = null;
    private File texDirectory = null;
    private String outputDirectory = null;
    private File texPath = null;
    private String texCommand = "pdflatex";
    private String tex4htCommand = "htlatex";
    private String bibtexCommand = "bibtex";
    private boolean cleanUp = true;
    private String[] texCommandArgs = new String[]{"-interaction=nonstopmode", "--src-specials"};
    private String[] tex4htCommandArgs = new String[]{"html,2", "", "", "-interaction=nonstopmode --src-specials"};
    private File outputDirectoryFile = null;
    private File tempDirectoryFile = null;

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public String getBibtexCommand() {
        return this.bibtexCommand;
    }

    public File getOutputDirectory() {
        if (this.outputDirectoryFile == null) {
            this.outputDirectoryFile = StringUtils.isEmpty((String)this.outputDirectory) ? this.targetSiteDirectory : new File(this.targetSiteDirectory, this.outputDirectory);
        }
        return this.outputDirectoryFile;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public File getTargetSiteDirectory() {
        return this.targetSiteDirectory;
    }

    public File getTempDirectory() {
        if (this.tempDirectoryFile == null) {
            String dirName = StringUtils.isBlank((String)this.tempDirectory) ? "m2latex" : this.tempDirectory;
            this.tempDirectoryFile = new File(this.targetDirectory, dirName);
        }
        return this.tempDirectoryFile;
    }

    public String getTex4htCommand() {
        return this.tex4htCommand;
    }

    public String[] getTex4htCommandArgs() {
        return this.tex4htCommandArgs;
    }

    public String getTexCommand() {
        return this.texCommand;
    }

    public String[] getTexCommandArgs() {
        return this.texCommandArgs;
    }

    public File getTexDirectory() {
        if (this.texDirectory == null) {
            this.texDirectory = new File(new File(new File(this.baseDirectory, "src"), "site"), "tex");
        }
        return this.texDirectory;
    }

    public File getTexPath() {
        return this.texPath;
    }

    public boolean isCleanUp() {
        return this.cleanUp;
    }

    public Settings setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        return this;
    }

    public Settings setBibtexCommand(String bibtexCommand) {
        this.bibtexCommand = bibtexCommand;
        return this;
    }

    public Settings setCleanUp(boolean cleanUp) {
        this.cleanUp = cleanUp;
        return this;
    }

    public Settings setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public Settings setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
        return this;
    }

    public Settings setTargetSiteDirectory(File targetSiteDirectory) {
        this.targetSiteDirectory = targetSiteDirectory;
        return this;
    }

    public Settings setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
        return this;
    }

    public Settings setTex4htCommand(String tex4htCommand) {
        this.tex4htCommand = tex4htCommand;
        return this;
    }

    public Settings setTex4htCommandArgs(String[] tex4htCommandArgs) {
        this.tex4htCommandArgs = tex4htCommandArgs;
        return this;
    }

    public Settings setTexCommand(String texCommand) {
        this.texCommand = texCommand;
        return this;
    }

    public Settings setTexCommandArgs(String[] args) {
        this.texCommandArgs = args;
        return this;
    }

    public Settings setTexDirectory(File texDirectory) {
        this.texDirectory = texDirectory;
        return this;
    }

    public Settings setTexPath(File texPath) {
        this.texPath = texPath;
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append('[').append("tempDirectory=").append(this.tempDirectory);
        sb.append(",texPath=").append(this.texPath);
        sb.append(",texCommand=").append(this.texCommand);
        sb.append(",bibtexCommand=").append(this.bibtexCommand);
        sb.append(",baseDirectory=").append(this.baseDirectory);
        sb.append(",targetSiteDirectory=").append(this.targetSiteDirectory);
        sb.append(",texDirectory=").append(this.texDirectory);
        sb.append(",texCommandArgs=").append(Arrays.asList(this.texCommandArgs)).append(']');
        return sb.toString();
    }
}

