/*
 * Decompiled with CFR 0.152.
 */
package org.m2latex.mojo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.m2latex.mojo.TexFileUtils;

public class TexFileUtilsImpl
implements TexFileUtils {
    private static final String[] LATEX_OUTPUT_FILES = new String[]{"%n.pdf", "%n.dvi", "%n.ps"};
    private final Log log;

    public TexFileUtilsImpl(Log log) {
        this.log = log;
    }

    public void copyLatexOutputToOutputFolder(File texFile, File tempDirectory, File outputDirectory) throws MojoExecutionException, MojoFailureException {
        WildcardFileFilter fileFilter = new WildcardFileFilter(this.getFilesToCopy(texFile, LATEX_OUTPUT_FILES));
        this.copyLatexOutputToOutputFolder(texFile, tempDirectory, outputDirectory, (IOFileFilter)fileFilter);
    }

    public void copyTex4htOutputToOutputFolder(File texFile, File tempDirectory, File tex4htOutputDirectory, File outputDirectory) throws MojoExecutionException, MojoFailureException {
        File[] outputFiles = tex4htOutputDirectory.listFiles();
        if (outputFiles == null || outputFiles.length == 0) {
            this.log.warn((CharSequence)("LaTeX file " + texFile + " did not generate any output in " + tex4htOutputDirectory + "!"));
        } else {
            File targetDirectory = this.getTargetDirectory(texFile, tempDirectory, outputDirectory);
            this.copyFilesToDirectory(outputFiles, targetDirectory);
        }
    }

    private void copyFilesToDirectory(File[] files, File targetDirectory) throws MojoExecutionException {
        for (int i = 0; i < files.length; ++i) {
            try {
                FileUtils.copyFileToDirectory((File)files[i], (File)targetDirectory);
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file " + files[i] + " to directory " + targetDirectory, (Exception)e);
            }
        }
    }

    private void copyLatexOutputToOutputFolder(File texFile, File tempDirectory, File outputDirectory, IOFileFilter fileFilter) throws MojoFailureException, MojoExecutionException {
        File targetDir = this.getTargetDirectory(texFile, tempDirectory, outputDirectory);
        try {
            Collection filesToCopy = FileUtils.listFiles((File)texFile.getParentFile(), (IOFileFilter)fileFilter, null);
            Iterator iterator = filesToCopy.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                this.copyFileToDirectory(file, targetDir);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("File " + texFile + " could not be copied to the target directory: " + targetDir, (Exception)e);
        }
    }

    File getTargetDirectory(File sourceFile, File sourceBaseDir, File targetBaseDir) throws MojoExecutionException, MojoFailureException {
        String tempPath;
        String filePath;
        try {
            filePath = sourceFile.getParentFile().getCanonicalPath();
            tempPath = sourceBaseDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error getting canonical path", (Exception)e);
        }
        if (!filePath.startsWith(tempPath)) {
            throw new MojoFailureException("File " + sourceFile + " is expected to be somewhere under the following directory: " + tempPath);
        }
        File targetDir = new File(targetBaseDir, filePath.substring(tempPath.length()));
        return targetDir;
    }

    private String[] getFilesToCopy(File texFile, String[] filesPatterns) {
        String texFilePrefix = this.getFileNameWithoutSuffix(texFile);
        String[] fileNames = new String[filesPatterns.length];
        for (int i = 0; i < filesPatterns.length; ++i) {
            fileNames[i] = filesPatterns[i].replaceAll("%n", texFilePrefix);
        }
        return fileNames;
    }

    public void copyLatexSrcToTempDir(File texDirectory, File tempDirectory) throws MojoExecutionException {
        try {
            if (tempDirectory.exists()) {
                this.log.info((CharSequence)("Deleting existing directory " + tempDirectory.getPath()));
                FileUtils.deleteDirectory((File)tempDirectory);
            }
            this.log.debug((CharSequence)("Copying TeX source directory (" + texDirectory.getPath() + ") to temporary directory (" + tempDirectory + ")"));
            FileUtils.copyDirectory((File)texDirectory, (File)tempDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure copying the TeX directory (" + texDirectory.getPath() + ") to a temporary directory (" + tempDirectory.getPath() + ").", (Exception)e);
        }
    }

    public File getCorrespondingAuxFile(File texFile) {
        return this.getFileWithDifferentSuffix(texFile, "aux");
    }

    public File getCorrespondingDviFile(File texFile) {
        return this.getFileWithDifferentSuffix(texFile, "dvi");
    }

    public File getCorrespondingLogFile(File texFile) {
        return this.getFileWithDifferentSuffix(texFile, "log");
    }

    public File getCorrespondingPdfFile(File texFile) {
        return this.getFileWithDifferentSuffix(texFile, "pdf");
    }

    public String getFileNameWithoutSuffix(File texFile) {
        String nameTexFile = texFile.getName();
        String namePrefixTexFile = nameTexFile.substring(0, nameTexFile.lastIndexOf("."));
        return namePrefixTexFile;
    }

    public List getLatexMainDocuments(File directory) throws MojoExecutionException {
        ArrayList<File> mainFiles = new ArrayList<File>();
        Collection texFiles = FileUtils.listFiles((File)directory, (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".tex"), (IOFileFilter)TrueFileFilter.INSTANCE);
        Iterator iterator = texFiles.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!this.isTexMainFile(file)) continue;
            mainFiles.add(file);
        }
        return mainFiles;
    }

    public boolean matchInCorrespondingLogFile(File texFile, String pattern) throws MojoExecutionException {
        File logFile = this.getCorrespondingLogFile(texFile);
        if (logFile.exists()) {
            try {
                return this.fileContainsPattern(logFile, pattern);
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("File " + logFile.getPath() + " does not exist after running LaTeX.", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading file " + logFile.getPath(), (Exception)e);
            }
        }
        throw new MojoExecutionException("File " + logFile.getPath() + " does not exist after running LaTeX.");
    }

    public File createTex4htOutputDir(File tempDir) throws MojoExecutionException {
        File tex4htOutdir = new File(tempDir, "m2latex_tex4ht_out");
        if (tex4htOutdir.exists()) {
            try {
                FileUtils.cleanDirectory((File)tex4htOutdir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not clean TeX4ht output dir: " + tex4htOutdir, (Exception)e);
            }
        } else {
            tex4htOutdir.mkdirs();
        }
        return tex4htOutdir;
    }

    private void copyFileToDirectory(File file, File targetDir) throws IOException {
        this.log.info((CharSequence)("Copying " + file.getName() + " to " + targetDir));
        FileUtils.copyFileToDirectory((File)file, (File)targetDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fileContainsPattern(File file, String regex) throws FileNotFoundException, IOException {
        Pattern pattern = Pattern.compile(regex);
        BufferedReader bufferedReader = null;
        try {
            FileReader fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            String line = bufferedReader.readLine();
            while (line != null) {
                if (pattern.matcher(line).find()) {
                    boolean bl = true;
                    return bl;
                }
                line = bufferedReader.readLine();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    this.log.warn((CharSequence)("Cannot close the file '" + file.getPath() + "'."), (Throwable)e);
                }
            }
        }
    }

    private File getFileWithDifferentSuffix(File file, String suffix) {
        return new File(file.getParentFile(), this.getFileNameWithoutSuffix(file) + "." + suffix);
    }

    private boolean isTexMainFile(File file) throws MojoExecutionException {
        String pattern = ".*\\\\begin\\s*\\{document\\}.*";
        try {
            return this.fileContainsPattern(file, pattern);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("The TeX file '" + file.getPath() + "' was removed while running this goal", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problems reading the file '" + file.getPath() + "' while checking if it is a TeX main file", (Exception)e);
        }
    }
}

