/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import com.google.common.base.Strings;
import com.google.common.io.CharSource;
import de.dentrassi.rpm.builder.Dependency;
import de.dentrassi.rpm.builder.Logger;
import de.dentrassi.rpm.builder.MojoFileInformationProvider;
import de.dentrassi.rpm.builder.Naming;
import de.dentrassi.rpm.builder.PackageEntry;
import de.dentrassi.rpm.builder.Ruleset;
import de.dentrassi.rpm.builder.RulesetEvaluator;
import de.dentrassi.rpm.builder.Script;
import de.dentrassi.rpm.builder.ScriptSetter;
import de.dentrassi.rpm.builder.Signature;
import de.dentrassi.rpm.builder.SigningHelper;
import de.dentrassi.rpm.builder.SimpleDependency;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.packagedrone.utils.rpm.Architecture;
import org.eclipse.packagedrone.utils.rpm.HashAlgorithm;
import org.eclipse.packagedrone.utils.rpm.OperatingSystem;
import org.eclipse.packagedrone.utils.rpm.RpmLead;
import org.eclipse.packagedrone.utils.rpm.RpmVersion;
import org.eclipse.packagedrone.utils.rpm.build.BuilderContext;
import org.eclipse.packagedrone.utils.rpm.build.FileInformationProvider;
import org.eclipse.packagedrone.utils.rpm.build.RpmBuilder;
import org.eclipse.packagedrone.utils.rpm.build.RpmFileNameProvider;
import org.eclipse.packagedrone.utils.rpm.deps.RpmDependencyFlags;
import org.eclipse.packagedrone.utils.rpm.signature.RsaHeaderSignatureProcessor;
import org.eclipse.packagedrone.utils.rpm.signature.SignatureProcessor;

@Mojo(name="rpm", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class RpmMojo
extends AbstractMojo {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.version}")
    private String version;
    @Parameter(defaultValue="${project.artifactId}", property="rpm.packageName")
    private String packageName;
    @Parameter(defaultValue="noarch", property="rpm.architecture")
    private String architecture = "noarch";
    @Parameter(property="rpm.leadOverride.architecture")
    private Architecture leadOverrideArchitecture;
    @Parameter(property="rpm.operatingSystem")
    private String operatingSystem = "linux";
    @Parameter(property="rpm.leadOverride.operatingSystem")
    private OperatingSystem leadOverrideOperatingSystem;
    @Parameter(property="rpm.sourcePackage")
    private String sourcePackage;
    @Parameter(property="rpm.generateDefaultSourcePackage", defaultValue="true")
    private boolean generateDefaultSourcePackage = true;
    @Parameter(defaultValue="0.", property="rpm.snapshotReleasePrefix")
    private String snapshotReleasePrefix = "0.";
    @Parameter(property="rpm.snapshotBuildId", required=false)
    private String snapshotBuildId;
    @Parameter(property="rpm.release", defaultValue="1")
    private String release = "1";
    @Parameter(property="rpm.forceRelease", defaultValue="false")
    private boolean forceRelease = false;
    @Parameter(property="rpm.classifier", defaultValue="rpm")
    private String classifier = "rpm";
    @Parameter(property="rpm.attach", defaultValue="true")
    private boolean attach = true;
    @Parameter(property="rpm.epoch")
    private Integer epoch;
    @Parameter(property="rpm.summary", defaultValue="${project.name}")
    private String summary;
    @Parameter(property="rpm.description", defaultValue="${project.description}")
    private String description;
    @Parameter(property="rpm.group", defaultValue="Unspecified")
    private String group;
    @Parameter(property="rpm.distribution")
    private String distribution;
    @Parameter(property="rpm.evalHostname", defaultValue="true")
    private boolean evalHostname = true;
    @Parameter(property="rpm.license")
    private String license;
    @Parameter(property="rpm.vendor")
    private String vendor;
    @Parameter(property="rpm.packager")
    private String packager;
    @Parameter(property="rpm.prefixes")
    private List<String> prefixes;
    @Parameter
    private List<PackageEntry> entries = new LinkedList<PackageEntry>();
    @Parameter
    private List<Ruleset> rulesets = new LinkedList<Ruleset>();
    @Parameter
    private String defaultRuleset;
    private Logger logger;
    private RulesetEvaluator eval;
    @Parameter
    private Script beforeInstallation;
    @Parameter
    private Script afterInstallation;
    @Parameter
    private Script beforeRemoval;
    @Parameter
    private Script afterRemoval;
    @Parameter(property="rpm.defaultScriptInterpreter", defaultValue="/bin/sh")
    private String defaultScriptInterpreter;
    @Parameter
    private final List<Dependency> requires = new LinkedList<Dependency>();
    @Parameter
    private final List<SimpleDependency> provides = new LinkedList<SimpleDependency>();
    @Parameter
    private final List<SimpleDependency> conflicts = new LinkedList<SimpleDependency>();
    @Parameter
    private final List<SimpleDependency> obsoletes = new LinkedList<SimpleDependency>();
    @Parameter
    private final List<SimpleDependency> prerequisites = new LinkedList<SimpleDependency>();
    @Parameter
    private final List<SimpleDependency> suggests = new LinkedList<SimpleDependency>();
    @Parameter
    private final List<SimpleDependency> enhances = new LinkedList<SimpleDependency>();
    @Parameter
    private final List<SimpleDependency> supplements = new LinkedList<SimpleDependency>();
    @Parameter
    private final List<SimpleDependency> recommends = new LinkedList<SimpleDependency>();
    @Parameter(property="rpm.signature")
    private Signature signature;
    @Parameter(property="rpm.skip", defaultValue="false")
    private boolean skip = false;
    @Parameter(property="rpm.skipSigning", defaultValue="false")
    private boolean skipSigning = false;
    @Parameter(property="rpm.naming")
    private Naming naming;
    @Parameter(property="rpm.targetDir", defaultValue="${project.build.directory}")
    private File targetDir;
    @Parameter(property="rpm.outputFileName")
    private String outputFileName;
    @Parameter(property="rpm.maximumSupportedRpmVersion")
    private RpmBuilder.Version maximumSupportedRpmVersion;

    public void setLeadOverrideArchitecture(Architecture leadOverrideArchitecture) {
        this.leadOverrideArchitecture = leadOverrideArchitecture;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public void setLeadOverrideOperatingSystem(OperatingSystem leadOverrideOperatingSystem) {
        this.leadOverrideOperatingSystem = leadOverrideOperatingSystem;
    }

    public void setSourcePackage(String sourcePackage) {
        this.sourcePackage = sourcePackage;
    }

    public void setGenerateDefaultSourcePackage(boolean generateDefaultSourcePackage) {
        this.generateDefaultSourcePackage = generateDefaultSourcePackage;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setSkipSigning(boolean skipSigning) {
        this.skipSigning = skipSigning;
    }

    public void setNaming(Naming naming) {
        this.naming = naming;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void setMaximumSupportedRpmVersion(RpmBuilder.Version maximumSupportedRpmVersion) {
        this.maximumSupportedRpmVersion = maximumSupportedRpmVersion;
    }

    public void setMaximumSupportedRpmVersion(String maximumSupportedRpmVersion) {
        this.maximumSupportedRpmVersion = (RpmBuilder.Version)RpmBuilder.Version.fromVersionString((String)maximumSupportedRpmVersion).orElseThrow(() -> new IllegalArgumentException(String.format("Version '%s' is unknown", maximumSupportedRpmVersion)));
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logger = new Logger(this.getLog());
        if (this.skip) {
            this.logger.debug("Skipping execution", new Object[0]);
            return;
        }
        this.eval = new RulesetEvaluator(this.rulesets);
        Path targetDir = this.targetDir != null ? this.targetDir.toPath() : Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        if (!Files.exists(targetDir, new LinkOption[0])) {
            try {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException ioe) {
                this.logger.debug("Unable to create target directory {}", targetDir);
                throw new MojoExecutionException("RPM build failed.", (Exception)ioe);
            }
        }
        Path targetFile = this.makeTargetFile(targetDir);
        this.logger.debug("Max supported RPM version: %s", this.maximumSupportedRpmVersion);
        this.logger.info("Writing to target to: %s", targetFile);
        this.logger.debug("Default script interpreter: %s", this.defaultScriptInterpreter);
        this.logger.debug("Default ruleset: %s", this.defaultRuleset);
        String packageName = this.makePackageName();
        RpmVersion version = this.makeVersion();
        this.logger.info("RPM base information - name: %s, version: %s, arch: %s", packageName, version, this.architecture);
        this.testLeadFlags();
        try (RpmBuilder builder = new RpmBuilder(packageName, version, this.architecture, targetFile, new OpenOption[0]);){
            SignatureProcessor signer;
            this.logger.info("Writing target file: %s", builder.getTargetFile());
            if (this.leadOverrideArchitecture != null) {
                this.logger.info("Override RPM lead architecture: %s", this.leadOverrideArchitecture);
                builder.setLeadOverrideArchitecture(this.leadOverrideArchitecture);
            }
            if (this.leadOverrideOperatingSystem != null) {
                this.logger.info("Override RPM lead operating system: %s", this.leadOverrideOperatingSystem);
                builder.setLeadOverrideOperatingSystem(this.leadOverrideOperatingSystem);
            }
            this.fillPackageInformation(builder);
            this.fillScripts(builder);
            this.fillDependencies(builder);
            this.fillPayload(builder);
            this.fillPrefixes(builder);
            if (!this.skipSigning && this.signature != null && (signer = this.makeRsaSigner(this.signature)) != null) {
                builder.addSignatureProcessor(signer);
            }
            builder.build();
            this.checkVersion(builder);
            if (this.attach) {
                this.projectHelper.attachArtifact(this.project, "rpm", this.classifier, builder.getTargetFile().toFile());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write RPM", (Exception)e);
        }
    }

    private Path makeTargetFile(Path targetDir) {
        String outputFileName = this.outputFileName;
        if (outputFileName == null || outputFileName.isEmpty()) {
            switch (this.naming.getDefaultFormat()) {
                case LEGACY: {
                    outputFileName = RpmFileNameProvider.LEGACY_FILENAME_PROVIDER.getRpmFileName(this.makePackageName(), this.makeVersion(), this.architecture);
                    break;
                }
                default: {
                    outputFileName = RpmFileNameProvider.DEFAULT_FILENAME_PROVIDER.getRpmFileName(this.makePackageName(), this.makeVersion(), this.architecture);
                }
            }
            this.logger.debug("Using generated file name - %s", outputFileName, outputFileName);
        }
        Path targetFile = targetDir.resolve(outputFileName);
        this.logger.debug("Resolved output file name - fileName: %s, fullName: %s", this.outputFileName, targetFile);
        return targetFile;
    }

    protected void checkVersion(RpmBuilder builder) throws MojoFailureException {
        RpmBuilder.Version version = builder.getRequiredRpmVersion();
        this.logger.info("Required RPM version: %s", version);
        if (this.maximumSupportedRpmVersion == null) {
            return;
        }
        if (version.compareTo((Enum)this.maximumSupportedRpmVersion) > 0) {
            throw new MojoFailureException((Object)builder.getTargetFile(), "Generated RPM file not compatible with version " + this.maximumSupportedRpmVersion, String.format("The generated RPM package would require at least version %1$s, however the build limits the supported RPM version to %2$s. Either raise the support RPM version or remove features requiring a more recent version of RPM.", version, this.maximumSupportedRpmVersion));
        }
    }

    private void testLeadFlags() {
        Optional os;
        Optional arch;
        if (this.leadOverrideArchitecture == null && !(arch = Architecture.fromAlias((String)this.architecture)).isPresent()) {
            this.logger.warn("Architecture '%s' cannot be mapped to lead information. Consider using setting 'leadOverrideArchitecture'.", this.architecture);
        }
        if (this.leadOverrideOperatingSystem == null && !(os = OperatingSystem.fromAlias((String)this.operatingSystem)).isPresent()) {
            this.logger.warn("OperatingSystem '%s' cannot be mapped to lead information. Consider using setting 'leadOverrideOperatingSystem'.", this.operatingSystem);
        }
    }

    private SignatureProcessor makeRsaSigner(Signature signature) throws MojoExecutionException, MojoFailureException {
        PGPPrivateKey privateKey = SigningHelper.loadKey(signature, this.logger);
        if (privateKey == null) {
            return null;
        }
        return new RsaHeaderSignatureProcessor(privateKey, HashAlgorithm.from((String)signature.getHashAlgorithm()));
    }

    private void fillDependencies(RpmBuilder builder) {
        this.addAllDependencies("require", this.requires, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addRequirement(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
        this.addAllDependencies("prerequire", this.prerequisites, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addRequirement(arg_0, arg_1, arg_2), RpmMojo::validateName, flags -> flags.add(RpmDependencyFlags.PREREQ));
        this.addAllDependencies("provide", this.provides, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addProvides(arg_0, arg_1, arg_2), ((Consumer<SimpleDependency>)RpmMojo::validateName).andThen(this::validateNoVersion), null);
        this.addAllDependencies("conflict", this.conflicts, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addConflicts(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
        this.addAllDependencies("obsolete", this.obsoletes, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addObsoletes(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
        this.addAllDependencies("suggest", this.suggests, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addSuggests(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
        this.addAllDependencies("enhance", this.enhances, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addEnhances(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
        this.addAllDependencies("supplement", this.supplements, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addSupplements(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
        this.addAllDependencies("recommends", this.recommends, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addRecommends(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
    }

    private static void validateName(SimpleDependency dep) {
        if (Strings.isNullOrEmpty((String)dep.getName())) {
            throw new IllegalStateException("'name' of dependency must be set");
        }
    }

    private void validateNoVersion(SimpleDependency dep) {
        if (!Strings.isNullOrEmpty((String)dep.getVersion())) {
            this.getLog().warn((CharSequence)String.format("Provides should not have a version: %s : %s. Use at your own risk!", dep.getName(), dep.getVersion()));
        }
    }

    private <T extends SimpleDependency> void addAllDependencies(String depName, List<T> deps, DependencyAdder adder, Consumer<T> validator, Consumer<Set<RpmDependencyFlags>> flagsCustomizer) {
        if (deps == null) {
            return;
        }
        for (SimpleDependency dep : deps) {
            validator.accept(dep);
            String name = dep.getName();
            String version = dep.getVersion();
            Set<RpmDependencyFlags> flags = dep.getFlags();
            if (flagsCustomizer != null) {
                flagsCustomizer.accept(flags);
            }
            this.logger.info("Adding dependency [%s]: name = %s, version = %s, flags = %s", depName, name, version, flags);
            adder.add(name, version, flags.toArray(new RpmDependencyFlags[0]));
        }
    }

    private void fillScripts(RpmBuilder builder) throws IOException {
        this.setScript("prein", this.beforeInstallation, (arg_0, arg_1) -> ((RpmBuilder)builder).setPreInstallationScript(arg_0, arg_1));
        this.setScript("postin", this.afterInstallation, (arg_0, arg_1) -> ((RpmBuilder)builder).setPostInstallationScript(arg_0, arg_1));
        this.setScript("prerm", this.beforeRemoval, (arg_0, arg_1) -> ((RpmBuilder)builder).setPreRemoveScript(arg_0, arg_1));
        this.setScript("postrm", this.afterRemoval, (arg_0, arg_1) -> ((RpmBuilder)builder).setPostRemoveScript(arg_0, arg_1));
    }

    private void setScript(String scriptName, Script script, ScriptSetter setter) throws IOException {
        if (script == null) {
            return;
        }
        String scriptContent = script.makeScriptContent();
        if (Strings.isNullOrEmpty((String)scriptContent)) {
            return;
        }
        String interpreter = script.getInterpreter();
        this.logger.debug("[script %s:]: explicit interpreter: %s", scriptName, interpreter);
        if (Strings.isNullOrEmpty((String)interpreter)) {
            interpreter = this.detectInterpreter(scriptContent);
            this.logger.debug("[script %s:]: detected interpreter: %s", scriptName, interpreter);
        }
        if (Strings.isNullOrEmpty((String)interpreter)) {
            interpreter = this.defaultScriptInterpreter;
            this.logger.debug("[script %s:]: default interpreter: %s", scriptName, interpreter);
        }
        this.logger.info("[script %s]: Using script interpreter: %s", scriptName, interpreter);
        this.logger.debug("[script %s]: %s", scriptName, scriptContent);
        setter.accept(interpreter, scriptContent);
    }

    private String detectInterpreter(String scriptContent) throws IOException {
        String firstLine = CharSource.wrap((CharSequence)scriptContent).readFirstLine();
        if (Strings.isNullOrEmpty((String)firstLine)) {
            return null;
        }
        if (firstLine.startsWith("#!") && firstLine.length() > 2) {
            return firstLine.substring(2);
        }
        return null;
    }

    protected void fillPayload(RpmBuilder builder) throws MojoFailureException, IOException {
        if (this.entries == null) {
            return;
        }
        BuilderContext ctx = builder.newContext();
        this.logger.debug("Building payload:", new Object[0]);
        for (PackageEntry entry : this.entries) {
            if (entry.getSkip().booleanValue()) continue;
            try {
                entry.validate();
            }
            catch (IllegalStateException e) {
                throw new MojoFailureException(e.getMessage());
            }
            this.fillFromEntry(ctx, entry);
        }
    }

    private void fillPrefixes(RpmBuilder builder) {
        if (this.prefixes == null || this.prefixes.isEmpty()) {
            return;
        }
        this.logger.debug("Building relocatable package: {}", this.prefixes);
        builder.setHeaderCustomizer(rpmTagHeader -> {
            int RPMTAG_PREFIXES = 1098;
            rpmTagHeader.putStringArray(1098, this.prefixes.toArray(new String[0]));
        });
    }

    private void fillFromEntry(BuilderContext ctx, PackageEntry entry) throws IOException {
        this.logger.debug("  %s:", entry.getName());
        if (entry.getDirectory() != null && entry.getDirectory().booleanValue()) {
            this.fillFromEntryDirectory(ctx, entry);
        } else if (entry.getFile() != null) {
            this.fillFromEntryFile(ctx, entry);
        } else if (entry.getLinkTo() != null) {
            this.fillFromEntryLinkTo(ctx, entry);
        } else if (entry.getCollect() != null) {
            this.fillFromEntryCollect(ctx, entry);
        }
    }

    private void fillFromEntryDirectory(BuilderContext ctx, PackageEntry entry) throws IOException {
        this.logger.debug("    as directory:", new Object[0]);
        ctx.addDirectory(entry.getName(), (FileInformationProvider)this.makeProvider(entry, "      - "));
    }

    private void fillFromEntryFile(BuilderContext ctx, PackageEntry entry) throws IOException {
        this.logger.debug("    as file:", new Object[0]);
        Path source = entry.getFile().toPath().toAbsolutePath();
        this.logger.debug("      - source: %s", source);
        ctx.addFile(entry.getName(), source, (FileInformationProvider)this.makeProvider(entry, "      - "));
    }

    private void fillFromEntryLinkTo(BuilderContext ctx, PackageEntry entry) throws IOException {
        this.logger.debug("    as symbolic link:", new Object[0]);
        this.logger.debug("      - linkTo: %s", entry.getLinkTo());
        ctx.addSymbolicLink(entry.getName(), entry.getLinkTo(), (FileInformationProvider)this.makeProvider(entry, "      - "));
    }

    private void fillFromEntryCollect(BuilderContext ctx, PackageEntry entry) throws IOException {
        this.logger.debug("    as collector:", new Object[0]);
        PackageEntry.Collector collector = entry.getCollect();
        this.logger.debug("      - configuration: %s", collector);
        String padding = "          ";
        Path from = collector.getFrom().toPath();
        String targetPrefix = entry.getName().endsWith("/") ? entry.getName() : entry.getName() + "/";
        this.logger.debug("      - files:", new Object[0]);
        MojoFileInformationProvider provider = this.makeProvider(entry, "            - ");
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(from.toFile());
        scanner.setCaseSensitive(true);
        scanner.setFollowSymlinks(true);
        scanner.setIncludes(collector.getIncludes());
        scanner.setExcludes(collector.getExcludes());
        scanner.scan();
        if (collector.isDirectories()) {
            for (String directory : scanner.getIncludedDirectories()) {
                Path dir = from.resolve(directory);
                if (dir.equals(from)) continue;
                this.logger.debug("%s%s (dir)", "          ", dir);
                Path relative = from.relativize(dir);
                String targetName = this.makeUnix(targetPrefix + relative.toString());
                this.logger.debug("%s  - target: %s", "          ", targetName);
                ctx.addDirectory(targetName, (FileInformationProvider)provider);
            }
        }
        for (String relative : scanner.getIncludedFiles()) {
            Path file = from.resolve(relative);
            String targetName = this.makeUnix(targetPrefix + relative);
            if (Files.isSymbolicLink(file)) {
                this.logger.debug("%s%s (symlink)", "          ", file);
                if (collector.isSymbolicLinks()) {
                    Path sym = Files.readSymbolicLink(file);
                    this.logger.debug("%s%s (symlink)", "          ", file);
                    this.logger.debug("%s  - target: %s", "          ", targetName);
                    this.logger.debug("%s  - linkTo: %s", "          ", sym.toString());
                    continue;
                }
                this.logger.debug("%s%s (symlink) - ignoring symbolic links", "          ", file);
                continue;
            }
            this.logger.debug("%s%s (file)", "          ", file);
            this.logger.debug("%s  - target: %s", "          ", targetName);
            ctx.addFile(targetName, file, (FileInformationProvider)provider);
        }
    }

    protected String makeUnix(String path) {
        return path.replace("\\", "/");
    }

    private MojoFileInformationProvider makeProvider(PackageEntry entry, String padding) {
        String ruleset = this.defaultRuleset;
        if (entry.getRuleset() != null && !entry.getRuleset().isEmpty()) {
            this.logger.debug("Using specified ruleset: '%s'", entry.getRuleset());
            ruleset = entry.getRuleset();
        } else if (this.defaultRuleset != null && !this.defaultRuleset.isEmpty()) {
            this.logger.debug("Using default ruleset: '%s'", this.defaultRuleset);
        }
        return new MojoFileInformationProvider(this.eval, ruleset, entry, l -> this.logger.debug("%s%s", padding, l));
    }

    private String makePackageName() {
        Naming.Case nameCase;
        if (this.naming == null) {
            nameCase = Naming.Case.UNMODIFIED;
            if (!this.packageName.toLowerCase().equals(this.packageName)) {
                this.getLog().warn((CharSequence)"Since version 0.9.0 of the RPM builder mojo the default behavior of forcing a lower case package name was removed. This package name seems to contain non-lowercase characters. It is possible to restore the previous behavior by setting the 'case' value in the 'naming' element.");
            }
        } else {
            nameCase = this.naming.getCase();
        }
        switch (nameCase) {
            case LOWERCASE: {
                return this.packageName.trim().toLowerCase();
            }
        }
        return this.packageName.trim();
    }

    private RpmVersion makeVersion() {
        if (!this.forceRelease && this.isSnapshotVersion()) {
            this.logger.info("Building with SNAPSHOT version", new Object[0]);
            String baseVersion = this.project.getVersion().substring(0, this.project.getVersion().length() - SNAPSHOT_SUFFIX.length());
            return new RpmVersion(this.epoch, baseVersion, this.makeSnapshotReleaseString());
        }
        return new RpmVersion(this.epoch, this.version, this.release);
    }

    private boolean isSnapshotVersion() {
        return this.project.getVersion().endsWith(SNAPSHOT_SUFFIX);
    }

    private String makeSnapshotReleaseString() {
        if (this.snapshotBuildId == null || this.snapshotBuildId.isEmpty()) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmm", Locale.ROOT);
            return this.snapshotReleasePrefix + formatter.format(Instant.now().atOffset(ZoneOffset.UTC));
        }
        return this.snapshotReleasePrefix + this.snapshotBuildId;
    }

    protected void fillPackageInformation(RpmBuilder builder) {
        RpmBuilder.PackageInformation pinfo = builder.getInformation();
        if ((this.sourcePackage == null || this.sourcePackage.isEmpty()) && this.generateDefaultSourcePackage) {
            String sourcePackage = this.generateDefaultSourcePackageName();
            this.logger.debug("Using generated source package name of '%s'. You can disable this by setting 'generateDefaultSourcePackage' to false.", sourcePackage);
            this.sourcePackage = sourcePackage;
        }
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setDescription(arg_0), this.description, new StringSupplier[0]);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setSummary(arg_0), this.summary, new StringSupplier[0]);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setGroup(arg_0), this.group, new StringSupplier[0]);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setDistribution(arg_0), this.distribution, new StringSupplier[0]);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setOperatingSystem(arg_0), this.operatingSystem, new StringSupplier[0]);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setSourcePackage(arg_0), this.sourcePackage, new StringSupplier[0]);
        if (this.evalHostname) {
            RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setBuildHost(arg_0), this.makeHostname(), new StringSupplier[0]);
        }
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setUrl(arg_0), this.project.getUrl(), new StringSupplier[0]);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setVendor(arg_0), this.vendor, this::makeVendor);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setPackager(arg_0), this.packager, this::makePackager);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setLicense(arg_0), this.license, this::makeLicense);
    }

    private String generateDefaultSourcePackageName() {
        return RpmLead.toLeadName((String)this.makePackageName(), (RpmVersion)this.makeVersion()) + ".src.rpm";
    }

    private String makeVendor() {
        if (this.project.getOrganization() != null) {
            return this.project.getOrganization().getName();
        }
        return null;
    }

    private String makePackager() {
        if (this.project.getOrganization() == null) {
            return null;
        }
        String org = this.project.getOrganization().getName();
        String url = this.project.getOrganization().getUrl();
        if (org == null || url == null || org.isEmpty() || url.isEmpty()) {
            return null;
        }
        return String.format("%s <%s>", org, url);
    }

    private String makeLicense() {
        return this.project.getLicenses().stream().map(License::getName).collect(Collectors.joining(", "));
    }

    private String makeHostname() {
        String hostname;
        try {
            hostname = com.google.common.io.Files.readFirstLine((File)new File("/etc/hostname"), (Charset)StandardCharsets.US_ASCII);
            if (hostname != null && !hostname.isEmpty()) {
                this.logger.debug("Hostname: from /etc/hostname -> '%s'", hostname);
                return hostname;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        hostname = System.getenv("COMPUTERNAME");
        if (hostname != null && !hostname.isEmpty()) {
            this.logger.debug("Hostname: from COMPUTERNAME -> '%s'", hostname);
            return hostname.toLowerCase();
        }
        hostname = System.getenv("hostname");
        if (hostname != null && !hostname.isEmpty()) {
            this.logger.debug("Hostname: from hostname -> '%s'", hostname);
            return hostname;
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            this.logger.debug("Hostname: from lookup -> '%s'", hostname);
            return hostname;
        }
        catch (UnknownHostException e) {
            this.logger.debug("Hostname: Falling back to 'localhost'", new Object[0]);
            return "localhost";
        }
    }

    private static void ifSet(Consumer<String> setter, String value, StringSupplier ... suppliers) {
        if (value != null && !value.isEmpty()) {
            setter.accept(value);
            return;
        }
        for (StringSupplier sup : suppliers) {
            String v = (String)sup.get();
            if (v == null || v.isEmpty()) continue;
            setter.accept(v);
            return;
        }
    }

    private static interface StringSupplier
    extends Supplier<String> {
    }

    @FunctionalInterface
    private static interface DependencyAdder {
        public void add(String var1, String var2, RpmDependencyFlags[] var3);
    }
}

