/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.adapter.swt;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.cwt.swt.environment.CwtSwtGraphicsContext;
import de.intarsys.cwt.swt.environment.CwtSwtGraphicsEnvironment;
import de.intarsys.cwt.swt.image.CwtSwtImage;
import de.intarsys.cwt.swt.image.ImageConverterAwt2Swt;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.pd.PDAxialShading;
import de.intarsys.pdf.pd.PDFunction;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDTilingPattern;
import de.intarsys.pdf.platform.cwt.adapter.CommonGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.adapter.awt.AwtGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpace;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import de.intarsys.pdf.platform.cwt.image.swt.ImageConverterPdf2Swt;
import de.intarsys.pdf.platform.cwt.paint.ColorPaint;
import de.intarsys.pdf.platform.cwt.paint.PatternPaint;
import de.intarsys.pdf.platform.cwt.paint.ShadingPaint;
import de.intarsys.pdf.platform.cwt.rendering.CSPlatformRenderer;
import de.intarsys.tools.attribute.Attribute;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Transform;

public class SwtGraphicsEnvironmentAdapter
extends CommonGraphicsEnvironmentAdapter {
    private static SwtGraphicsEnvironmentAdapter ACTIVE;
    private static final Attribute ATTR_EXCEPTION;
    private static final Attribute ATTR_IMAGE;

    static {
        ATTR_EXCEPTION = new Attribute("swtException");
        ATTR_IMAGE = new Attribute("swtImage");
    }

    public static SwtGraphicsEnvironmentAdapter get() {
        return ACTIVE;
    }

    public SwtGraphicsEnvironmentAdapter() {
        ACTIVE = this;
    }

    protected synchronized ImageData createImage(PDImage pdImage) {
        ImageData result = (ImageData)pdImage.getAttribute((Object)ATTR_IMAGE);
        if (result == null) {
            RuntimeException ex = (RuntimeException)pdImage.getAttribute((Object)ATTR_EXCEPTION);
            if (ex != null) {
                throw ex;
            }
            ImageConverterPdf2Swt converter = new ImageConverterPdf2Swt(pdImage);
            try {
                result = converter.getImageData();
                pdImage.setAttribute((Object)ATTR_IMAGE, (Object)result);
            }
            catch (RuntimeException e) {
                pdImage.setAttribute((Object)ATTR_EXCEPTION, (Object)e);
                throw e;
            }
        }
        return result;
    }

    protected ImageData createImage(PDImage pdImage, float[] rgb) {
        ImageData image;
        int red = (int)(rgb[0] * 255.0f);
        int green = (int)(rgb[1] * 255.0f);
        int blue = (int)(rgb[2] * 255.0f);
        String key = "swt-iimage-" + (red << 16 | green << 8 | blue);
        SoftReference ref = (SoftReference)pdImage.getAttribute((Object)key);
        if (ref != null && (image = (ImageData)ref.get()) != null) {
            return image;
        }
        BufferedImage bufferedImage = AwtGraphicsEnvironmentAdapter.get().createImage(pdImage, rgb);
        ImageConverterAwt2Swt converter = new ImageConverterAwt2Swt(bufferedImage);
        image = converter.getImageData();
        pdImage.setAttribute((Object)key, new SoftReference<ImageData>(image));
        return image;
    }

    protected Color createResourceColorPaint(Device device, ColorPaint paint) {
        float[] rgb;
        AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(paint.getPdColorSpace());
        float[] colorValues = paint.getColorValues();
        if (colorValues == null) {
            rgb = new float[]{0.0f, 0.0f, 0.0f};
        } else {
            try {
                rgb = awtColorSpace.getRGB(colorValues);
            }
            catch (RuntimeException ex) {
                rgb = AwtColorSpace.FALLBACK.toRGB(colorValues);
            }
        }
        Color rgbColor = new Color(device, (int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f));
        return rgbColor;
    }

    protected Pattern createResourceDummyPaint(Device device) {
        Color rgbColor = new Color(device, 128, 128, 128);
        Pattern pattern = new Pattern(device, 0.0f, 0.0f, 1.0f, 0.0f, rgbColor, 128, rgbColor, 128);
        rgbColor.dispose();
        return pattern;
    }

    protected Pattern createResourcePatternPaint(Device device, PatternPaint patternPaint) {
        Image image;
        block6: {
            if (!(patternPaint.getPdPattern() instanceof PDTilingPattern)) {
                return this.createResourceDummyPaint(device);
            }
            PDTilingPattern tilingPattern = (PDTilingPattern)patternPaint.getPdPattern();
            image = new Image(device, (int)tilingPattern.getXStep(), (int)tilingPattern.getYStep());
            GC gc = new GC((Drawable)image);
            CwtSwtGraphicsContext cwtGc = new CwtSwtGraphicsContext(gc, device);
            try {
                try {
                    cwtGc.scale(1.0f, -1.0f);
                    cwtGc.translate(0.0f, (float)(0 - (int)tilingPattern.getYStep()));
                    cwtGc.setClip((Shape)tilingPattern.getBoundingBox().toNormalizedRectangle());
                    CSPlatformRenderer renderer = new CSPlatformRenderer(new HashMap(), (IGraphicsContext)cwtGc);
                    renderer.process(tilingPattern.getContentStream(), tilingPattern.getResources());
                }
                catch (CSException cSException) {
                    cwtGc.dispose();
                    gc.dispose();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                cwtGc.dispose();
                gc.dispose();
                throw throwable;
            }
            cwtGc.dispose();
            gc.dispose();
        }
        ImagePattern pattern = new ImagePattern(device, image);
        return pattern;
    }

    protected Pattern createResourceShadingPaint(Device device, ShadingPaint paint) {
        if (!(paint.getPdShading() instanceof PDAxialShading)) {
            return this.createResourceDummyPaint(device);
        }
        PDAxialShading axialShading = (PDAxialShading)paint.getPdShading();
        float[] coords = axialShading.getCoords();
        float[] domain = axialShading.getDomain();
        PDFunction function = axialShading.getFunction();
        AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(paint.getPdShading().getColorSpace());
        float[] rgb = awtColorSpace.getRGB(function.evaluate(new float[]{domain[0]}));
        Color rgbColor1 = new Color(device, (int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f));
        rgb = awtColorSpace.getRGB(function.evaluate(new float[]{domain[1]}));
        Color rgbColor2 = new Color(device, (int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f));
        Pattern pattern = new Pattern(device, coords[0], coords[1], coords[2], coords[3], rgbColor1, (int)(paint.getAlphaValue() * 255.0f), rgbColor2, (int)(paint.getAlphaValue() * 255.0f));
        rgbColor1.dispose();
        rgbColor2.dispose();
        return pattern;
    }

    public void drawImage(IGraphicsContext graphicsContext, PDImage pdImage, float x, float y) {
        ImageData imageData = this.createImage(pdImage);
        if (pdImage.isImageMask()) {
            float[] rgb = graphicsContext.getBackgroundColor().getRGBColorComponents(null);
            imageData = this.createImage(pdImage, rgb);
        }
        float definedWidth = pdImage.getWidth();
        float definedHeight = pdImage.getHeight();
        float realWidth = imageData.width;
        float realHeight = imageData.height;
        float scaledX = x;
        float scaledY = y;
        Transform original = null;
        Transform temporary = null;
        GC gc = ((CwtSwtGraphicsContext)graphicsContext).getGc();
        if (definedHeight < realHeight || definedWidth < realWidth) {
            original = new Transform(gc.getDevice());
            gc.getTransform(original);
            float[] elements = new float[6];
            original.getElements(elements);
            temporary = new Transform(gc.getDevice(), elements);
            float xScale = definedWidth / realWidth;
            float yScale = definedHeight / realHeight;
            temporary.scale(xScale, yScale);
            scaledX = x / xScale;
            scaledY = y / yScale;
            gc.setTransform(temporary);
            temporary.dispose();
        }
        try {
            new CwtSwtImage(imageData).drawFromGraphicsContext(graphicsContext, scaledX, scaledY);
        }
        finally {
            if (original != null) {
                gc.setTransform(original);
                original.dispose();
            }
        }
    }

    public IGraphicsEnvironment getGraphicsEnvironment() {
        return CwtSwtGraphicsEnvironment.get();
    }

    public void setBackgroundColorPaint(IGraphicsContext graphicsContext, ColorPaint paint) {
        CwtSwtGraphicsContext swtGC = (CwtSwtGraphicsContext)graphicsContext;
        Color resource = this.createResourceColorPaint(swtGC.getDevice(), paint);
        swtGC.setBackgroundColor(resource);
    }

    public void setBackgroundPatternPaint(IGraphicsContext graphicsContext, PatternPaint paint) {
        CwtSwtGraphicsContext swtGC = (CwtSwtGraphicsContext)graphicsContext;
        Pattern resource = this.createResourcePatternPaint(swtGC.getDevice(), paint);
        swtGC.setBackgroundPattern(resource);
    }

    public void setBackgroundShadingPaint(IGraphicsContext graphicsContext, ShadingPaint paint) {
        CwtSwtGraphicsContext swtGC = (CwtSwtGraphicsContext)graphicsContext;
        Pattern resource = this.createResourceShadingPaint(swtGC.getDevice(), paint);
        swtGC.setBackgroundPattern(resource);
    }

    public void setForegroundColorPaint(IGraphicsContext graphicsContext, ColorPaint paint) {
        CwtSwtGraphicsContext swtGC = (CwtSwtGraphicsContext)graphicsContext;
        Color resource = this.createResourceColorPaint(swtGC.getDevice(), paint);
        swtGC.setForegroundColor(resource);
    }

    public void setForegroundPatternPaint(IGraphicsContext graphicsContext, PatternPaint paint) {
        CwtSwtGraphicsContext swtGC = (CwtSwtGraphicsContext)graphicsContext;
        Pattern resource = this.createResourcePatternPaint(swtGC.getDevice(), paint);
        swtGC.setForegroundPattern(resource);
    }

    public void setForegroundShadingPaint(IGraphicsContext graphicsContext, ShadingPaint paint) {
        CwtSwtGraphicsContext swtGC = (CwtSwtGraphicsContext)graphicsContext;
        Pattern resource = this.createResourceShadingPaint(swtGC.getDevice(), paint);
        swtGC.setForegroundPattern(resource);
    }

    static class ImagePattern
    extends Pattern {
        private Image image;

        public ImagePattern(Device device, Image pImage) {
            super(device, pImage);
            this.image = pImage;
        }

        public void dispose() {
            super.dispose();
            this.image.dispose();
        }
    }
}

