/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpace;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import java.awt.Color;

public class AwtColorTools {
    public static Color getBorderColor(PDWidgetAnnotation annotation) {
        return AwtColorTools.toColor(PDAnnotationTools.getBorderColor((PDWidgetAnnotation)annotation));
    }

    public static float[] getBorderColorRGB(PDWidgetAnnotation annotation) {
        return AwtColorTools.toRGB(PDAnnotationTools.getBorderColor((PDWidgetAnnotation)annotation));
    }

    public static Color getFillColor(PDWidgetAnnotation annotation) {
        return AwtColorTools.toColor(PDAnnotationTools.getFillColor((PDWidgetAnnotation)annotation));
    }

    public static float[] getFillColorRGB(PDWidgetAnnotation annotation) {
        return AwtColorTools.toRGB(PDAnnotationTools.getFillColor((PDWidgetAnnotation)annotation));
    }

    public static Color toColor(float[] color) {
        if (color == null) {
            return null;
        }
        if (color.length == 1) {
            PDColorSpace pdColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceGray);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pdColorSpace);
            float[] rgb = awtColorSpace.getRGB(color);
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        if (color.length == 4) {
            PDColorSpace pdColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceCMYK);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pdColorSpace);
            float[] rgb = awtColorSpace.getRGB(color);
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        if (color.length == 3) {
            return new Color(color[0], color[1], color[2]);
        }
        return null;
    }

    public static Color toColor(int[] color) {
        if (color == null) {
            return null;
        }
        if (color.length == 1) {
            PDColorSpace pdColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceGray);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pdColorSpace);
            float[] rgb = awtColorSpace.getRGB(new float[]{(float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f});
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        if (color.length == 4) {
            PDColorSpace pdColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceCMYK);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pdColorSpace);
            float[] rgb = awtColorSpace.getRGB(new float[]{(float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f});
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        if (color.length == 3) {
            return new Color(color[0], color[1], color[2]);
        }
        return null;
    }

    public static float[] toFloatArray(Color color) {
        if (color == null) {
            return null;
        }
        return color.getRGBColorComponents(null);
    }

    public static int[] toIntArray(Color color) {
        if (color == null) {
            return null;
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public static float[] toRGB(float[] color) {
        if (color == null) {
            return null;
        }
        if (color.length == 1) {
            PDColorSpace pdColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceGray);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pdColorSpace);
            return awtColorSpace.getRGB(color);
        }
        if (color.length == 4) {
            PDColorSpace pdColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceCMYK);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pdColorSpace);
            return awtColorSpace.getRGB(color);
        }
        if (color.length == 3) {
            return color;
        }
        return null;
    }

    public static int[] toRGB(int[] color) {
        if (color == null) {
            return null;
        }
        if (color.length == 1) {
            PDColorSpace pdColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceGray);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pdColorSpace);
            float[] rgb = awtColorSpace.getRGB(new float[]{(float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f});
            return new int[]{(int)((double)(rgb[0] * 255.0f) + 0.5), (int)((double)(rgb[1] * 255.0f) + 0.5), (int)((double)(rgb[2] * 255.0f) + 0.5)};
        }
        if (color.length == 4) {
            PDColorSpace pdColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceCMYK);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pdColorSpace);
            float[] rgb = awtColorSpace.getRGB(new float[]{(float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f});
            return new int[]{(int)((double)(rgb[0] * 255.0f) + 0.5), (int)((double)(rgb[1] * 255.0f) + 0.5), (int)((double)(rgb[2] * 255.0f) + 0.5)};
        }
        if (color.length == 3) {
            return color;
        }
        return null;
    }
}

