/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.swt;

import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import de.intarsys.pdf.platform.cwt.color.swt.SwtCSSpecial;
import java.awt.color.ColorSpace;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class SwtCSIndexed
extends SwtCSSpecial {
    public SwtCSIndexed(PDColorSpace pdColorSpace) {
        super(pdColorSpace);
    }

    protected RGB[] extractRGBs() {
        if (this.myPDColorSpace().getBaseColorSpace() instanceof PDCSDeviceRGB) {
            return this.extractRGBsDirect();
        }
        return this.extractRGBsOther();
    }

    protected RGB[] extractRGBsDirect() {
        RGB[] rgbs = new RGB[this.myPDColorSpace().getColorCount()];
        int index = 0;
        while (index < rgbs.length) {
            rgbs[index] = new RGB(this.myPDColorSpace().getColorBytes()[index * 3] & 0xFF, this.myPDColorSpace().getColorBytes()[index * 3 + 1] & 0xFF, this.myPDColorSpace().getColorBytes()[index * 3 + 2] & 0xFF);
            ++index;
        }
        return rgbs;
    }

    protected RGB[] extractRGBsOther() {
        PDColorSpace pdBaseColorSpace = this.myPDColorSpace().getBaseColorSpace();
        ColorSpace colorSpace = AwtColorSpaceFactory.get().createColorSpace(pdBaseColorSpace).getColorSpace();
        int numComponents = colorSpace.getNumComponents();
        RGB[] rgbs = new RGB[this.myPDColorSpace().getColorCount()];
        int index = 0;
        while (index < rgbs.length) {
            float[] input = new float[numComponents];
            int component = 0;
            while (component < numComponents) {
                input[component] = (float)(0xFF & this.myPDColorSpace().getColorBytes()[index * numComponents + component]) / 255.0f;
                ++component;
            }
            float[] output = colorSpace.toRGB(input);
            rgbs[index] = new RGB((int)(output[0] * 255.0f), (int)(output[1] * 255.0f), (int)(output[2] * 255.0f));
            ++index;
        }
        return rgbs;
    }

    public int getNumComponents() {
        return 1;
    }

    public PaletteData getPalette(PDImage pdImage) {
        return new PaletteData(this.extractRGBs());
    }

    protected PDCSIndexed myPDColorSpace() {
        return (PDCSIndexed)this.getPDColorSpace();
    }
}

