/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.FontQuery;
import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontProgram;
import de.intarsys.cwt.font.IFontQuery;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontAny;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.platform.cwt.font.PDFontTrueTypeTools;
import de.intarsys.pdf.platform.cwt.font.PDFontType1Tools;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;

public class PlatformFontTools {
    private static final Attribute ATTR_CWTFONT = new Attribute("cwtfont");

    public static boolean embedFontFile(PDFont pdFont) throws IOException {
        if (pdFont.isEmbedded()) {
            return true;
        }
        IFont font = PlatformFontTools.getCWTFont(pdFont);
        if (font == null) {
            return false;
        }
        ILocator locator = font.getFontProgram().getLocator();
        if (locator == null) {
            return false;
        }
        return PlatformFontTools.embedFontFile(pdFont, locator);
    }

    public static boolean embedFontFile(PDFont pdFont, ILocator locator) throws IOException {
        if (pdFont instanceof PDFontTrueType) {
            PDFontTrueTypeTools.embedFontFile(pdFont, locator);
            return true;
        }
        if (pdFont instanceof PDFontType1) {
            PDFontType1Tools.embedFontFile(pdFont, locator);
            return true;
        }
        return false;
    }

    public static IFont getCWTFont(PDFont pdFont) {
        if (pdFont == null) {
            return null;
        }
        if (pdFont instanceof PDFontAny) {
            return null;
        }
        IFont cwtFont = (IFont)pdFont.getAttribute((Object)ATTR_CWTFONT);
        if (cwtFont != null) {
            return cwtFont;
        }
        FontQuery query = new FontQuery();
        query.setFontType(pdFont.getFontType());
        query.setFontName(pdFont.getLookupFontName());
        query.setFontFamilyName(pdFont.getLookupFontFamilyName());
        PDFontStyle fontStyle = pdFont.getLookupFontStyle();
        FontStyle cwtFontStyle = FontStyle.getFontStyle((String)fontStyle.getLabel());
        query.setFontStyle(cwtFontStyle);
        cwtFont = FontTools.lookupFont((IFontQuery)query);
        if (cwtFont != null) {
            PlatformFontTools.setCWTFont(pdFont, cwtFont);
            return cwtFont;
        }
        if (cwtFontStyle != FontStyle.REGULAR) {
            query.setFontStyle(FontStyle.REGULAR);
            cwtFont = FontTools.lookupFont((IFontQuery)query);
            if (cwtFont != null) {
                PlatformFontTools.setCWTFont(pdFont, cwtFont);
                return cwtFont;
            }
        }
        query.setFontType("Any");
        query.setFontStyle(cwtFontStyle);
        cwtFont = FontTools.lookupFont((IFontQuery)query);
        if (cwtFont != null) {
            PlatformFontTools.setCWTFont(pdFont, cwtFont);
            return cwtFont;
        }
        if (cwtFontStyle != FontStyle.REGULAR) {
            query.setFontStyle(FontStyle.REGULAR);
            cwtFont = FontTools.lookupFont((IFontQuery)query);
            if (cwtFont != null) {
                PlatformFontTools.setCWTFont(pdFont, cwtFont);
                return cwtFont;
            }
        }
        if (pdFont instanceof PDFontTrueType) {
            query = new FontQuery();
            query.setFontType("TrueType");
            query.setFontName("Arial");
            query.setFontFamilyName("Arial");
            query.setFontStyle(cwtFontStyle);
            cwtFont = FontTools.lookupFont((IFontQuery)query);
            if (cwtFont != null) {
                PlatformFontTools.setCWTFont(pdFont, cwtFont);
                return cwtFont;
            }
        }
        query = new FontQuery();
        query.setFontType("Type1");
        query.setFontName("Helvetica");
        query.setFontFamilyName("Helvetica");
        query.setFontStyle(cwtFontStyle);
        cwtFont = FontTools.lookupFont((IFontQuery)query);
        PlatformFontTools.setCWTFont(pdFont, cwtFont);
        return cwtFont;
    }

    public static ILocator getFontFile(PDFont pdFont) {
        IFont font;
        PDFontDescriptor pdDescriptor = pdFont.getFontDescriptor();
        if (pdDescriptor != null) {
            byte[] bytes = null;
            bytes = pdDescriptor.getFontFile();
            if (bytes == null) {
                bytes = pdDescriptor.getFontFile2();
            }
            if (bytes == null) {
                bytes = pdDescriptor.getFontFile3();
            }
            if (bytes != null) {
                return new ByteArrayLocator(bytes, pdFont.getFontName(), "dat");
            }
        }
        if ((font = PlatformFontTools.getCWTFont(pdFont)) != null) {
            IFontProgram fontProgram = font.getFontProgram();
            return fontProgram.getLocator();
        }
        return null;
    }

    public static void setCWTFont(PDFont pdFont, IFont cwtFont) {
        pdFont.setAttribute((Object)ATTR_CWTFONT, (Object)cwtFont);
    }
}

