/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image;

import de.intarsys.pdf.platform.cwt.image.IPlatformImageFactory;
import de.intarsys.pdf.platform.cwt.image.NullPlatformImageFactory;
import java.util.Iterator;
import sun.misc.Service;

public class PlatformImageFactory {
    private static IPlatformImageFactory Unique;
    private static boolean lookupProviders;

    static {
        lookupProviders = true;
    }

    protected static IPlatformImageFactory findProviders() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = IPlatformImageFactory.class.getClassLoader();
        }
        Iterator ps = Service.providers(IPlatformImageFactory.class, (ClassLoader)loader);
        while (ps.hasNext()) {
            try {
                return (IPlatformImageFactory)ps.next();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized IPlatformImageFactory get() {
        if (Unique == null) {
            PlatformImageFactory.init();
        }
        return Unique;
    }

    protected static void init() {
        if (lookupProviders) {
            Unique = PlatformImageFactory.findProviders();
        }
        if (Unique == null) {
            Unique = new NullPlatformImageFactory();
        }
    }

    public static boolean isLookupProviders() {
        return lookupProviders;
    }

    public static void set(IPlatformImageFactory unique) {
        Unique = unique;
    }

    public static void setLookupProviders(boolean pLookupProviders) {
        lookupProviders = pLookupProviders;
    }
}

