/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.rendering;

import de.intarsys.cwt.common.BlendMode;
import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.content.CSBasicDevice;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.pd.PDCSPattern;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.PlatformFontFactory;
import de.intarsys.pdf.platform.cwt.image.IPlatformImage;
import de.intarsys.pdf.platform.cwt.image.PlatformImageFactory;
import de.intarsys.pdf.platform.cwt.paint.ColorPaint;
import de.intarsys.pdf.platform.cwt.paint.PatternPaint;
import de.intarsys.pdf.platform.cwt.paint.ShadingPaint;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.geometry.ShapeTools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Map;

public class CSPlatformDevice
extends CSBasicDevice
implements ICSPlatformDevice {
    protected static final Attribute ATTR_DEVICECLIP = new Attribute("deviceClip");
    protected static final Attribute ATTR_DEVICETRANSFORM = new Attribute("deviceTransform");
    protected static final Attribute ATTR_NONSTROKEPAINT = new Attribute("nonStrokePaint");
    protected static final Attribute ATTR_STROKEPAINT = new Attribute("strokePaint");
    private boolean applyLineAttributes = true;
    private boolean applyPaint = true;
    private IGraphicsContext graphicsContext;
    private Shape textClip;
    private AffineTransform userSpace;

    public CSPlatformDevice(IGraphicsContext graphics) {
        this.graphicsContext = graphics;
    }

    public void addTextClip(Shape shape) {
        Shape transformed = this.graphicsContext.getTransform().createTransformedShape(shape);
        if (this.textClip == null) {
            this.textClip = transformed;
        } else {
            Area area = this.textClip instanceof Area ? (Area)this.textClip : new Area(this.textClip);
            area.add(new Area(transformed));
            this.textClip = area;
        }
    }

    protected void applyLineAttributes() {
        if (this.applyLineAttributes) {
            BasicStroke result = null;
            result = this.graphicsState.dashPattern.length == 0 ? new BasicStroke(this.graphicsState.lineWidth, this.getGSDeviceCapStyle(this.graphicsState), this.getGSDeviceJoinStyle(this.graphicsState), this.graphicsState.miterLimit) : new BasicStroke(this.graphicsState.lineWidth, this.getGSDeviceCapStyle(this.graphicsState), this.getGSDeviceJoinStyle(this.graphicsState), this.graphicsState.miterLimit, this.graphicsState.dashPattern, this.graphicsState.dashPhase);
            this.graphicsContext.setStroke((Stroke)result);
            this.applyLineAttributes = false;
        }
    }

    protected void applyPaint() {
        if (this.applyPaint) {
            this.graphicsContext.setBackgroundPaint(this.preparePaint(this.getGSNonStrokePaint(this.graphicsState)));
            this.graphicsContext.setForegroundPaint(this.preparePaint(this.getGSStrokePaint(this.graphicsState)));
            this.applyPaint = false;
        }
    }

    protected void basicClip(Shape shape) {
        this.graphicsContext.clip(shape);
    }

    protected void basicDraw(Shape shape) {
        this.applyLineAttributes();
        this.applyPaint();
        this.graphicsContext.draw(shape);
    }

    protected void basicFill(Shape shape) {
        this.applyPaint();
        IPaint paint = this.getGSNonStrokePaint(this.graphicsState);
        if (paint instanceof PatternPaint) {
            PDPattern pattern = ((PatternPaint)paint).getPdPattern();
            CDSMatrix matrix = pattern.getMatrix();
            if (matrix == null) {
                this.graphicsContext.fill(shape);
            } else {
                AffineTransform matrixTransform = matrix.toTransform();
                try {
                    AffineTransform inverseTransform = matrixTransform.createInverse();
                    AffineTransform originalTransform = this.graphicsContext.getTransform();
                    this.graphicsContext.transform(matrixTransform);
                    try {
                        Shape inverseShape = inverseTransform.createTransformedShape(shape);
                        this.graphicsContext.fill(inverseShape);
                    }
                    finally {
                        this.graphicsContext.setTransform(originalTransform);
                    }
                }
                catch (NoninvertibleTransformException ex) {
                    this.graphicsContext.fill(shape);
                }
            }
        } else {
            Area clip = ShapeTools.createArea((Shape)this.graphicsContext.getClip(), (boolean)false);
            if (clip == null || clip.isRectangular()) {
                this.graphicsContext.fill(shape);
            } else {
                this.graphicsContext.setClip(null);
                try {
                    Area intersectArea = ShapeTools.createArea((Shape)shape, (boolean)false);
                    intersectArea.intersect(clip);
                    this.graphicsContext.fill((Shape)intersectArea);
                }
                finally {
                    this.graphicsContext.setClip((Shape)clip);
                }
            }
        }
    }

    protected void basicFillDegenerated(Shape shape) {
        this.graphicsContext.setStroke((Stroke)new BasicStroke(0.0f));
        this.applyLineAttributes = true;
        this.graphicsContext.setForegroundColor(this.graphicsContext.getBackgroundColor());
        this.applyPaint = true;
        this.graphicsContext.draw(shape);
    }

    protected void basicSetNonStrokeColorSpace(PDColorSpace pdColorSpace) {
        super.basicSetNonStrokeColorSpace(pdColorSpace);
        this.applyPaint = true;
        if (pdColorSpace instanceof PDCSPattern) {
            this.setGSNonStrokePaint(this.graphicsState, new PatternPaint());
        } else {
            this.setGSNonStrokePaint(this.graphicsState, new ColorPaint(pdColorSpace));
        }
    }

    protected void basicSetNonStrokeColorValues(float[] values) {
        super.basicSetNonStrokeColorValues(values);
        this.applyPaint = true;
        ((ColorPaint)this.getGSNonStrokePaint(this.graphicsState)).setColorValues(values);
    }

    protected void basicSetStrokeColorSpace(PDColorSpace pdColorSpace) {
        super.basicSetStrokeColorSpace(pdColorSpace);
        this.applyPaint = true;
        if (pdColorSpace instanceof PDCSPattern) {
            this.setGSStrokePaint(this.graphicsState, new PatternPaint());
        } else {
            this.setGSStrokePaint(this.graphicsState, new ColorPaint(pdColorSpace));
        }
    }

    protected void basicSetStrokeColorValues(float[] values) {
        super.basicSetStrokeColorValues(values);
        this.applyPaint = true;
        ((ColorPaint)this.getGSStrokePaint(this.graphicsState)).setColorValues(values);
    }

    protected void basicTextShowGlyphs(PDGlyphs glyphs, float advance) throws CSException {
        if (this.textState.fontSize > 0.0f) {
            try {
                IPlatformFont pfFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
                IPlatformGlyphs pg = pfFont.createPlatformGlyphs(glyphs);
                pg.render(this);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        super.basicTextShowGlyphs(glyphs, advance);
    }

    protected void doImage(COSName name, PDImage image) throws CSException {
        double scaleX = image.getWidth();
        double scaleY = image.getHeight();
        AffineTransform tempTransform = this.graphicsContext.getTransform();
        double[] pts = new double[]{scaleX, scaleY};
        tempTransform.deltaTransform(pts, 0, pts, 0, 1);
        pts[0] = Math.abs(pts[0]);
        pts[1] = Math.abs(pts[1]);
        if (pts[0] < 1.0) {
            scaleX = pts[0];
        }
        if (pts[1] < 1.0) {
            scaleY = pts[1];
        }
        AffineTransform transform = new AffineTransform();
        transform.translate(0.0, 1.0);
        transform.scale(1.0 / scaleX, -1.0 / scaleY);
        this.graphicsContext.transform(transform);
        Object interpolation = null;
        if (!image.isInterpolate() && this.graphicsContext.getTransform().getDeterminant() >= 1.0) {
            RenderingHints hints = this.graphicsContext.getRenderingHints();
            interpolation = hints.remove(RenderingHints.KEY_INTERPOLATION);
            this.graphicsContext.setRenderingHints((Map)hints);
        }
        try {
            try {
                this.applyPaint();
                IPlatformImage platformImage = PlatformImageFactory.get().createPlatformImage(image);
                platformImage.doImage(this);
            }
            catch (Exception e) {
                this.graphicsContext.setForegroundColor(Color.DARK_GRAY);
                this.graphicsContext.draw((Shape)new Line2D.Double(0.0, 0.0, image.getWidth(), image.getHeight()));
                this.graphicsContext.draw((Shape)new Line2D.Double(image.getWidth(), 0.0, 0.0, image.getHeight()));
                throw new CSError("Image can't be rendered (" + e.getLocalizedMessage() + ")", (Throwable)e);
            }
            catch (OutOfMemoryError e) {
                this.graphicsContext.setForegroundColor(Color.DARK_GRAY);
                this.graphicsContext.draw((Shape)new Line2D.Double(0.0, 0.0, image.getWidth(), image.getHeight()));
                this.graphicsContext.draw((Shape)new Line2D.Double(image.getWidth(), 0.0, 0.0, image.getHeight()));
                throw new CSError("Image too large", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.graphicsContext.setTransform(tempTransform);
            if (interpolation != null) {
                this.graphicsContext.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
            }
            throw throwable;
        }
        this.graphicsContext.setTransform(tempTransform);
        if (interpolation != null) {
            this.graphicsContext.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
        }
    }

    public void doShading(COSName name, PDShading shading) {
        if (shading == null) {
            return;
        }
        ShadingPaint paint = new ShadingPaint(shading);
        this.graphicsContext.setBackgroundPaint((IPaint)paint);
        if (shading.getBoundingBox() == null) {
            Shape shape = this.graphicsContext.getClip();
            if (shape != null) {
                this.graphicsContext.fill(shape);
            }
        } else {
            this.graphicsContext.fill((Shape)shading.getBoundingBox().toNormalizedRectangle());
        }
        this.applyPaint = true;
    }

    public IGraphicsContext getGraphicsContext() {
        return this.graphicsContext;
    }

    private final BlendMode getGSDeviceBlendMode(GraphicsState pState) {
        if (pState.extState == null) {
            return (BlendMode)BlendMode.META.getDefault();
        }
        if (pState.extState.isBlendModeNormal()) {
            return BlendMode.NORMAL;
        }
        if (pState.extState.isBlendModeMultiply()) {
            return BlendMode.MULTIPLY;
        }
        return (BlendMode)BlendMode.META.getDefault();
    }

    private final int getGSDeviceCapStyle(GraphicsState pState) {
        switch (pState.capStyle) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    private final Shape getGSDeviceClip(GraphicsState pState) {
        return (Shape)pState.getAttribute((Object)ATTR_DEVICECLIP);
    }

    private final int getGSDeviceJoinStyle(GraphicsState pState) {
        switch (pState.joinStyle) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    private final AffineTransform getGSDeviceTransform(GraphicsState pState) {
        return (AffineTransform)pState.getAttribute((Object)ATTR_DEVICETRANSFORM);
    }

    private final IPaint getGSNonStrokePaint(GraphicsState pState) {
        return (IPaint)pState.getAttribute((Object)ATTR_NONSTROKEPAINT);
    }

    private final IPaint getGSStrokePaint(GraphicsState pState) {
        return (IPaint)pState.getAttribute((Object)ATTR_STROKEPAINT);
    }

    protected GraphicsState graphicsStateCopy(GraphicsState oldState) {
        GraphicsState newState = super.graphicsStateCopy(oldState);
        this.setGSStrokePaint(newState, this.getGSStrokePaint(oldState).copy());
        this.setGSNonStrokePaint(newState, this.getGSNonStrokePaint(oldState).copy());
        if (this.textState.font != null) {
            try {
                IPlatformFont pfFont = PlatformFontFactory.get().createPlatformFont(oldState.textState.font);
                pfFont.saveState(this, oldState, newState);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        return newState;
    }

    public void inlineImage(PDImage img) {
        this.doImage(null, img);
    }

    protected IPaint preparePaint(IPaint paint) {
        BlendMode blendMode = this.getGSDeviceBlendMode(this.graphicsState);
        if (blendMode == BlendMode.MULTIPLY) {
            ColorPaint cPaint;
            float[] colorValues;
            float alphaFactor = 0.5f;
            if (paint instanceof ColorPaint && (colorValues = (cPaint = (ColorPaint)paint).getColorValues()) != null) {
                float luminance = 0.0f;
                int i = 0;
                while (i < colorValues.length) {
                    luminance += colorValues[i];
                    ++i;
                }
                alphaFactor = 1.0f - (luminance /= (float)colorValues.length);
            }
            paint = paint.copy();
            paint.setAlphaValue(paint.getAlphaValue() * alphaFactor);
        }
        return paint;
    }

    public void restoreState() {
        super.restoreState();
        this.graphicsContext.setTransform(this.getGSDeviceTransform(this.graphicsState));
        this.graphicsContext.setClip(this.getGSDeviceClip(this.graphicsState));
        this.applyLineAttributes = true;
        this.applyPaint = true;
    }

    public void saveState() {
        this.setGSDeviceTransform(this.graphicsState, this.graphicsContext.getTransform());
        this.setGSDeviceClip(this.graphicsState, this.graphicsContext.getClip());
        super.saveState();
    }

    public void setExtendedState(COSName name, PDExtGState gstate) {
        float oldStrokeAlpha = this.graphicsState.strokeAlphaValue;
        float oldNonStrokeAlpha = this.graphicsState.nonStrokeAlphaValue;
        super.setExtendedState(name, gstate);
        this.applyLineAttributes = true;
        if (oldStrokeAlpha != this.graphicsState.strokeAlphaValue || oldNonStrokeAlpha != this.graphicsState.nonStrokeAlphaValue) {
            this.getGSNonStrokePaint(this.graphicsState).setAlphaValue(this.graphicsState.nonStrokeAlphaValue);
            this.getGSStrokePaint(this.graphicsState).setAlphaValue(this.graphicsState.strokeAlphaValue);
            this.applyPaint = true;
        }
    }

    private final void setGSDeviceClip(GraphicsState pState, Shape clip) {
        pState.setAttribute((Object)ATTR_DEVICECLIP, (Object)clip);
    }

    private final void setGSDeviceTransform(GraphicsState pState, AffineTransform transform) {
        pState.setAttribute((Object)ATTR_DEVICETRANSFORM, (Object)transform);
    }

    private final void setGSNonStrokePaint(GraphicsState pState, IPaint paint) {
        paint.setAlphaValue(pState.nonStrokeAlphaValue);
        pState.setAttribute((Object)ATTR_NONSTROKEPAINT, (Object)paint);
    }

    private final void setGSStrokePaint(GraphicsState pState, IPaint paint) {
        paint.setAlphaValue(pState.strokeAlphaValue);
        pState.setAttribute((Object)ATTR_STROKEPAINT, (Object)paint);
    }

    public void setLineCap(int capStyle) {
        super.setLineCap(capStyle);
        this.applyLineAttributes = true;
    }

    public void setLineDash(float[] pattern, float phase) {
        super.setLineDash(pattern, phase);
        this.applyLineAttributes = true;
    }

    public void setLineJoin(int joinStyle) {
        super.setLineJoin(joinStyle);
        this.applyLineAttributes = true;
    }

    public void setLineWidth(float lineWidth) {
        super.setLineWidth(lineWidth);
        this.applyLineAttributes = true;
    }

    public void setMiterLimit(float miterLimit) {
        super.setMiterLimit(miterLimit);
        this.applyLineAttributes = true;
    }

    public void setNonStrokeColorValues(float[] values, COSName name, PDPattern pattern) {
        this.applyPaint = true;
        ((PatternPaint)this.getGSNonStrokePaint(this.graphicsState)).setPatternValues(values, pattern);
    }

    public void setStrokeColorValues(float[] values, COSName name, PDPattern pattern) {
        this.applyPaint = true;
        ((PatternPaint)this.getGSStrokePaint(this.graphicsState)).setPatternValues(values, pattern);
    }

    public void textBegin() {
        this.userSpace = this.graphicsContext.getTransform();
        super.textBegin();
        if (this.textState.font != null) {
            try {
                IPlatformFont pfFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
                pfFont.textStateChanged(this);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
    }

    public void textEnd() {
        super.textEnd();
        if (this.textState.font != null) {
            try {
                IPlatformFont pfFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
                pfFont.textStateChanged(this);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        if (this.textClip != null) {
            this.graphicsContext.setTransform(new AffineTransform());
            this.basicClip(this.textClip);
            this.textClip = null;
        }
        this.graphicsContext.setTransform(this.userSpace);
    }

    public void textLineMove(float dx, float dy) {
        super.textLineMove(dx, dy);
        this.graphicsContext.setTransform(this.userSpace);
        this.graphicsContext.transform(this.textState.transform);
    }

    public void textLineNew() {
        super.textLineNew();
        this.graphicsContext.setTransform(this.userSpace);
        this.graphicsContext.transform(this.textState.transform);
    }

    public void textMove(float dx, float dy) {
        super.textMove(dx, dy);
        this.graphicsContext.translate(dx, dy);
    }

    public void textSetFont(COSName name, PDFont font, float size) {
        IPlatformFont pfFont = null;
        if (this.textState.font != null) {
            try {
                pfFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        super.textSetFont(name, font, size);
        if (pfFont != null) {
            pfFont.textStateChanged(this);
        }
        try {
            pfFont = PlatformFontFactory.get().createPlatformFont(font);
            pfFont.textStateChanged(this);
        }
        catch (PlatformFontException platformFontException) {
            // empty catch block
        }
    }

    public void textSetHorizontalScaling(float scaling) {
        IPlatformFont pfFont = null;
        if (this.textState.font != null) {
            try {
                pfFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        super.textSetHorizontalScaling(scaling);
        if (pfFont != null) {
            pfFont.textStateChanged(this);
        }
    }

    public void textSetRenderingMode(int renderingMode) {
        IPlatformFont pfFont = null;
        if (this.textState.font != null) {
            try {
                pfFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        super.textSetRenderingMode(renderingMode);
        if (pfFont != null) {
            pfFont.textStateChanged(this);
        }
    }

    public void textSetRise(float rise) {
        IPlatformFont pfFont = null;
        if (this.textState.font != null) {
            try {
                pfFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        super.textSetRise(rise);
        if (pfFont != null) {
            pfFont.textStateChanged(this);
        }
    }

    public void textSetTransform(float a, float b, float c, float d, float e, float f) {
        IPlatformFont pfFont = null;
        if (this.textState.font != null) {
            try {
                pfFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        super.textSetTransform(a, b, c, d, e, f);
        this.graphicsContext.setTransform(this.userSpace);
        this.graphicsContext.transform(this.textState.transform);
        if (pfFont != null) {
            pfFont.textStateChanged(this);
        }
    }

    public void textShow(byte[] bytes, int offset, int length) {
        this.applyLineAttributes();
        this.applyPaint();
        super.textShow(bytes, offset, length);
    }

    public void transform(float a, float b, float c, float d, float e, float f) {
        super.transform(a, b, c, d, e, f);
        this.graphicsContext.transform(new AffineTransform(a, b, c, d, e, f));
    }
}

