/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.ChunkTagHandlerAdapter2;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ConfidenceChunker;
import com.aliasi.chunk.NBestChunker;
import com.aliasi.hmm.HmmDecoder;
import com.aliasi.symbol.SymbolTable;
import com.aliasi.tag.ScoredTagging;
import com.aliasi.tag.TagLattice;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Iterators;
import com.aliasi.util.Math;
import com.aliasi.util.Scored;
import com.aliasi.util.ScoredObject;
import com.aliasi.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class HmmChunker
implements NBestChunker,
ConfidenceChunker {
    private final TokenizerFactory mTokenizerFactory;
    private final HmmDecoder mDecoder;

    public HmmChunker(TokenizerFactory tokenizerFactory, HmmDecoder decoder) {
        this.mTokenizerFactory = tokenizerFactory;
        this.mDecoder = decoder;
    }

    public HmmDecoder getDecoder() {
        return this.mDecoder;
    }

    public TokenizerFactory getTokenizerFactory() {
        return this.mTokenizerFactory;
    }

    @Override
    public Chunking chunk(char[] cs, int start, int end) {
        Strings.checkArgsStartEnd(cs, start, end);
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, end - start);
        ArrayList<String> tokList = new ArrayList<String>();
        ArrayList<String> whiteList = new ArrayList<String>();
        tokenizer.tokenize(tokList, whiteList);
        String[] toks = HmmChunker.toStringArray(tokList);
        String[] whites = HmmChunker.toStringArray(whiteList);
        String[] tags = this.mDecoder.tag((List<String>)tokList).tags().toArray(Strings.EMPTY_STRING_ARRAY);
        HmmChunker.decodeNormalize(tags);
        return ChunkTagHandlerAdapter2.toChunkingBIO(toks, whites, tags);
    }

    @Override
    public Chunking chunk(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.chunk(cs, 0, cs.length);
    }

    @Override
    public Iterator<ScoredObject<Chunking>> nBest(char[] cs, int start, int end, int maxNBest) {
        Strings.checkArgsStartEnd(cs, start, end);
        if (maxNBest < 1) {
            String msg = "Maximum n-best value must be greater than zero. Found maxNBest=" + maxNBest;
            throw new IllegalArgumentException(msg);
        }
        String[][] toksWhites = this.getToksWhites(cs, start, end);
        Iterator<ScoredTagging<String>> it = this.mDecoder.tagNBest(Arrays.asList(toksWhites[0]), maxNBest);
        return new NBestIt(it, toksWhites);
    }

    public Iterator<ScoredObject<Chunking>> nBestConditional(char[] cs, int start, int end, int maxNBest) {
        Strings.checkArgsStartEnd(cs, start, end);
        if (maxNBest < 1) {
            String msg = "Maximum n-best value must be greater than zero. Found maxNBest=" + maxNBest;
            throw new IllegalArgumentException(msg);
        }
        String[][] toksWhites = this.getToksWhites(cs, start, end);
        Iterator<ScoredTagging<String>> it = this.mDecoder.tagNBestConditional(Arrays.asList(toksWhites[0]), maxNBest);
        return new NBestIt(it, toksWhites);
    }

    @Override
    public Iterator<Chunk> nBestChunks(char[] cs, int start, int end, int maxNBest) {
        String[][] toksWhites = this.getToksWhites(cs, start, end);
        TagLattice<String> lattice = this.mDecoder.tagMarginal(Arrays.asList(toksWhites[0]));
        return new NBestChunkIt(lattice, toksWhites[1], maxNBest);
    }

    String[][] getToksWhites(char[] cs, int start, int end) {
        Strings.checkArgsStartEnd(cs, start, end);
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, end - start);
        ArrayList<String> tokList = new ArrayList<String>();
        ArrayList<String> whiteList = new ArrayList<String>();
        tokenizer.tokenize(tokList, whiteList);
        String[] toks = HmmChunker.toStringArray(tokList);
        String[] whites = HmmChunker.toStringArray(whiteList);
        return new String[][]{toks, whites};
    }

    private static String[] toStringArray(Collection<String> c) {
        return c.toArray(Strings.EMPTY_STRING_ARRAY);
    }

    private static int[] toIntArray(Collection<Integer> c) {
        int[] result = new int[c.size()];
        Iterator<Integer> it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            Integer nextVal = it.next();
            result[i] = nextVal;
            ++i;
        }
        return result;
    }

    static String baseTag(String tag) {
        if (ChunkTagHandlerAdapter2.isOutTag(tag)) {
            return tag;
        }
        return tag.substring(2);
    }

    static String[] trainNormalize(String[] tags) {
        if (tags.length == 0) {
            return tags;
        }
        String[] normalTags = new String[tags.length];
        int i = 0;
        while (i < normalTags.length) {
            String prevTag = i - 1 >= 0 ? tags[i - 1] : "W_BOS";
            String nextTag = i + 1 < tags.length ? tags[i + 1] : "W_BOS";
            normalTags[i] = HmmChunker.trainNormalize(prevTag, tags[i], nextTag);
            ++i;
        }
        return normalTags;
    }

    private static void decodeNormalize(String[] tags) {
        int i = 0;
        while (i < tags.length) {
            tags[i] = HmmChunker.decodeNormalize(tags[i]);
            ++i;
        }
    }

    static String trainNormalize(String prevTag, String tag, String nextTag) {
        if (ChunkTagHandlerAdapter2.isOutTag(tag)) {
            if (ChunkTagHandlerAdapter2.isOutTag(prevTag)) {
                if (ChunkTagHandlerAdapter2.isOutTag(nextTag)) {
                    return "MM_O";
                }
                return "EE_O_" + HmmChunker.baseTag(nextTag);
            }
            if (ChunkTagHandlerAdapter2.isOutTag(nextTag)) {
                return "BB_O_" + HmmChunker.baseTag(prevTag);
            }
            return "WW_O_" + HmmChunker.baseTag(nextTag);
        }
        if (ChunkTagHandlerAdapter2.isBeginTag(tag)) {
            if (ChunkTagHandlerAdapter2.isInTag(nextTag)) {
                return "B_" + HmmChunker.baseTag(tag);
            }
            return "W_" + HmmChunker.baseTag(tag);
        }
        if (ChunkTagHandlerAdapter2.isInTag(tag)) {
            if (ChunkTagHandlerAdapter2.isInTag(nextTag)) {
                return "M_" + HmmChunker.baseTag(tag);
            }
            return "E_" + HmmChunker.baseTag(tag);
        }
        String msg = "Unknown tag triple. prevTag=" + prevTag + " tag=" + tag + " nextTag=" + nextTag;
        throw new IllegalArgumentException(msg);
    }

    private static String decodeNormalize(String tag) {
        if (tag.startsWith("B_") || tag.startsWith("W_")) {
            String baseTag = tag.substring(2);
            return ChunkTagHandlerAdapter2.toBeginTag(baseTag);
        }
        if (tag.startsWith("M_") || tag.startsWith("E_")) {
            String baseTag = tag.substring(2);
            return ChunkTagHandlerAdapter2.toInTag(baseTag);
        }
        return ChunkTagHandlerAdapter2.OUT_TAG;
    }

    private static class ChunkItState
    implements Scored {
        final int mStartCharPos;
        final int mTokPos;
        final String mTag;
        final double mForward;
        final double mBack;
        final double mScore;
        final int mCurrentTagId;
        final int mMidTagId;
        final int mEndTagId;

        ChunkItState(int startCharPos, int tokPos, String tag, int currentTagId, int midTagId, int endTagId, double forward, double back) {
            this.mStartCharPos = startCharPos;
            this.mTokPos = tokPos;
            this.mTag = tag;
            this.mCurrentTagId = currentTagId;
            this.mMidTagId = midTagId;
            this.mEndTagId = endTagId;
            this.mForward = forward;
            this.mBack = back;
            this.mScore = forward + back;
        }

        @Override
        public double score() {
            return this.mScore;
        }
    }

    private static class NBestChunkIt
    extends Iterators.Buffered<Chunk> {
        final TagLattice<String> mLattice;
        final String[] mWhites;
        final int mMaxNBest;
        final int[] mTokenStartIndexes;
        final int[] mTokenEndIndexes;
        String[] mBeginTags;
        int[] mBeginTagIds;
        int[] mMidTagIds;
        int[] mEndTagIds;
        String[] mWholeTags;
        int[] mWholeTagIds;
        final BoundedPriorityQueue<Scored> mQueue;
        final int mNumToks;
        final double mTotal;
        int mCount = 0;

        NBestChunkIt(TagLattice<String> lattice, String[] whites, int maxNBest) {
            this.mTotal = Math.naturalLogToBase2Log(lattice.logZ());
            this.mLattice = lattice;
            this.mWhites = whites;
            String[] toks = lattice.tokenList().toArray(Strings.EMPTY_STRING_ARRAY);
            this.mNumToks = toks.length;
            this.mTokenStartIndexes = new int[this.mNumToks];
            this.mTokenEndIndexes = new int[this.mNumToks];
            int pos = 0;
            int i = 0;
            while (i < this.mNumToks) {
                this.mTokenStartIndexes[i] = pos += whites[i].length();
                this.mTokenEndIndexes[i] = pos += toks[i].length();
                ++i;
            }
            this.mMaxNBest = maxNBest;
            this.mQueue = new BoundedPriorityQueue(ScoredObject.comparator(), maxNBest);
            this.initializeTags();
            this.initializeQueue();
        }

        void initializeTags() {
            SymbolTable tagTable = this.mLattice.tagSymbolTable();
            ArrayList<String> beginTagList = new ArrayList<String>();
            ArrayList<Integer> beginTagIdList = new ArrayList<Integer>();
            ArrayList<Integer> midTagIdList = new ArrayList<Integer>();
            ArrayList<Integer> endTagIdList = new ArrayList<Integer>();
            ArrayList<String> wholeTagList = new ArrayList<String>();
            ArrayList<Integer> wholeTagIdList = new ArrayList<Integer>();
            int numTags = tagTable.numSymbols();
            int i = 0;
            while (i < numTags) {
                String baseTag;
                String tag = tagTable.idToSymbol(i);
                if (tag.startsWith("B_")) {
                    baseTag = tag.substring(2);
                    beginTagList.add(baseTag);
                    beginTagIdList.add(i);
                    String midTag = "M_" + baseTag;
                    int midTagId = tagTable.symbolToID(midTag);
                    midTagIdList.add(midTagId);
                    String endTag = "E_" + baseTag;
                    int endTagId = tagTable.symbolToID(endTag);
                    endTagIdList.add(endTagId);
                } else if (tag.startsWith("W_")) {
                    baseTag = tag.substring(2);
                    wholeTagList.add(baseTag);
                    wholeTagIdList.add(i);
                }
                ++i;
            }
            this.mBeginTags = HmmChunker.toStringArray(beginTagList);
            this.mBeginTagIds = HmmChunker.toIntArray(beginTagIdList);
            this.mMidTagIds = HmmChunker.toIntArray(midTagIdList);
            this.mEndTagIds = HmmChunker.toIntArray(endTagIdList);
            this.mWholeTags = HmmChunker.toStringArray(wholeTagList);
            this.mWholeTagIds = HmmChunker.toIntArray(wholeTagIdList);
        }

        void initializeQueue() {
            int len = this.mWhites.length - 1;
            int i = 0;
            while (i < len) {
                int j = 0;
                while (j < this.mBeginTagIds.length) {
                    this.initializeBeginTag(i, j);
                    ++j;
                }
                j = 0;
                while (j < this.mWholeTagIds.length) {
                    this.initializeWholeTag(i, j);
                    ++j;
                }
                ++i;
            }
        }

        void initializeBeginTag(int tokPos, int j) {
            int startCharPos = this.mTokenStartIndexes[tokPos];
            String tag = this.mBeginTags[j];
            int beginTagId = this.mBeginTagIds[j];
            int midTagId = this.mMidTagIds[j];
            int endTagId = this.mEndTagIds[j];
            double forward = Math.naturalLogToBase2Log(this.mLattice.logForward(tokPos, beginTagId));
            double backward = Math.naturalLogToBase2Log(this.mLattice.logBackward(tokPos, beginTagId));
            ChunkItState state = new ChunkItState(startCharPos, tokPos, tag, beginTagId, midTagId, endTagId, forward, backward);
            this.mQueue.offer(state);
        }

        void initializeWholeTag(int tokPos, int j) {
            int start = this.mTokenStartIndexes[tokPos];
            int end = this.mTokenEndIndexes[tokPos];
            String tag = this.mWholeTags[j];
            double log2Score = Math.naturalLogToBase2Log(this.mLattice.logProbability(tokPos, this.mWholeTagIds[j]));
            Chunk chunk = ChunkFactory.createChunk(start, end, tag, log2Score);
            this.mQueue.offer(chunk);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Chunk bufferNext() {
            if (this.mCount <= this.mMaxNBest) ** GOTO lbl11
            return null;
lbl-1000:
            // 1 sources

            {
                next = this.mQueue.poll();
                if (next instanceof Chunk) {
                    ++this.mCount;
                    result = (Chunk)next;
                    return ChunkFactory.createChunk(result.start(), result.end(), result.type(), result.score() - this.mTotal);
                }
                state = (ChunkItState)next;
                this.addNextMidState(state);
                this.addNextEndState(state);
lbl11:
                // 2 sources

                ** while (!this.mQueue.isEmpty())
            }
lbl12:
            // 1 sources

            return null;
        }

        void addNextMidState(ChunkItState state) {
            int nextTokPos = state.mTokPos + 1;
            if (nextTokPos + 1 >= this.mNumToks) {
                return;
            }
            int midTagId = state.mMidTagId;
            double transition = Math.naturalLogToBase2Log(this.mLattice.logTransition(nextTokPos - 1, state.mCurrentTagId, midTagId));
            double forward = state.mForward + transition;
            double backward = Math.naturalLogToBase2Log(this.mLattice.logBackward(nextTokPos, midTagId));
            ChunkItState nextState = new ChunkItState(state.mStartCharPos, nextTokPos, state.mTag, midTagId, state.mMidTagId, state.mEndTagId, forward, backward);
            this.mQueue.offer(nextState);
        }

        void addNextEndState(ChunkItState state) {
            int nextTokPos = state.mTokPos + 1;
            if (nextTokPos >= this.mNumToks) {
                return;
            }
            int endTagId = state.mEndTagId;
            double transition = Math.naturalLogToBase2Log(this.mLattice.logTransition(nextTokPos - 1, state.mCurrentTagId, endTagId));
            double forward = state.mForward + transition;
            double backward = Math.naturalLogToBase2Log(this.mLattice.logBackward(nextTokPos, endTagId));
            double log2Prob = forward + backward;
            Chunk chunk = ChunkFactory.createChunk(state.mStartCharPos, this.mTokenEndIndexes[nextTokPos], state.mTag, log2Prob);
            this.mQueue.offer(chunk);
        }
    }

    private static class NBestIt
    implements Iterator<ScoredObject<Chunking>> {
        final Iterator<ScoredTagging<String>> mIt;
        final String[] mWhites;
        final String[] mToks;

        NBestIt(Iterator<ScoredTagging<String>> it, String[][] toksWhites) {
            this.mIt = it;
            this.mToks = toksWhites[0];
            this.mWhites = toksWhites[1];
        }

        @Override
        public boolean hasNext() {
            return this.mIt.hasNext();
        }

        @Override
        public ScoredObject<Chunking> next() {
            ScoredTagging<String> so = this.mIt.next();
            double score = so.score();
            String[] tags = so.tags().toArray(Strings.EMPTY_STRING_ARRAY);
            HmmChunker.decodeNormalize(tags);
            Chunking chunking = ChunkTagHandlerAdapter2.toChunkingBIO(this.mToks, this.mWhites, tags);
            return new ScoredObject<Chunking>(chunking, score);
        }

        @Override
        public void remove() {
            this.mIt.remove();
        }
    }
}

