/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.classify.LMClassifier;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.lm.LanguageModel;
import com.aliasi.lm.NGramBoundaryLM;
import com.aliasi.lm.NGramProcessLM;
import com.aliasi.lm.TokenizedLM;
import com.aliasi.stats.MultivariateDistribution;
import com.aliasi.stats.MultivariateEstimator;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DynamicLMClassifier<L extends LanguageModel.Dynamic>
extends LMClassifier<L, MultivariateEstimator>
implements ObjectHandler<Classified<CharSequence>>,
Compilable {
    public DynamicLMClassifier(String[] categories, L[] languageModels) {
        super(categories, languageModels, (MultivariateDistribution)DynamicLMClassifier.createCategoryEstimator(categories));
    }

    void train(String category, char[] cs, int start, int end) {
        this.train(category, new String(cs, start, end - start));
    }

    void train(String category, CharSequence sampleCSeq) {
        this.train(category, sampleCSeq, 1);
    }

    public void train(String category, CharSequence sampleCSeq, int count) {
        if (count < 0) {
            String msg = "Counts must be non-negative. Found count=" + count;
            throw new IllegalArgumentException(msg);
        }
        if (count == 0) {
            return;
        }
        ((LanguageModel.Dynamic)this.languageModel(category)).train(sampleCSeq, count);
        ((MultivariateEstimator)this.categoryDistribution()).train(category, count);
    }

    void handle(CharSequence charSequence, Classification classification) {
        this.train(classification.bestCategory(), charSequence);
    }

    @Override
    public void handle(Classified<CharSequence> classified) {
        this.handle(classified.getObject(), classified.getClassification());
    }

    MultivariateEstimator categoryEstimator() {
        return (MultivariateEstimator)this.mCategoryDistribution;
    }

    L lmForCategory(String category) {
        LanguageModel.Dynamic result = (LanguageModel.Dynamic)this.mCategoryToModel.get(category);
        if (result == null) {
            String msg = "Unknown category=" + category;
            throw new IllegalArgumentException(msg);
        }
        return (L)result;
    }

    @Override
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    public void resetCategory(String category, L lm, int newCount) {
        if (newCount < 0) {
            String msg = "Count must be non-negative. Found new count=" + newCount;
            throw new IllegalArgumentException(msg);
        }
        ((MultivariateEstimator)this.categoryDistribution()).resetCount(category);
        ((MultivariateEstimator)this.categoryDistribution()).train(category, newCount);
        LanguageModel.Dynamic currentLM = (LanguageModel.Dynamic)this.languageModel(category);
        int i = 0;
        while (i < ((LanguageModel.Dynamic[])this.mLanguageModels).length) {
            if (currentLM == ((LanguageModel.Dynamic[])this.mLanguageModels)[i]) {
                ((LanguageModel.Dynamic[])this.mLanguageModels)[i] = lm;
                break;
            }
            ++i;
        }
        this.mCategoryToModel.put(category, lm);
    }

    public static DynamicLMClassifier<NGramProcessLM> createNGramProcess(String[] categories, int maxCharNGram) {
        LanguageModel.Dynamic[] lms = new NGramProcessLM[categories.length];
        int i = 0;
        while (i < lms.length) {
            lms[i] = new NGramProcessLM(maxCharNGram);
            ++i;
        }
        return new DynamicLMClassifier(categories, lms);
    }

    public static DynamicLMClassifier<NGramBoundaryLM> createNGramBoundary(String[] categories, int maxCharNGram) {
        LanguageModel.Dynamic[] lms = new NGramBoundaryLM[categories.length];
        int i = 0;
        while (i < lms.length) {
            lms[i] = new NGramBoundaryLM(maxCharNGram);
            ++i;
        }
        return new DynamicLMClassifier(categories, lms);
    }

    public static DynamicLMClassifier<TokenizedLM> createTokenized(String[] categories, TokenizerFactory tokenizerFactory, int maxTokenNGram) {
        LanguageModel.Dynamic[] lms = new TokenizedLM[categories.length];
        int i = 0;
        while (i < lms.length) {
            lms[i] = new TokenizedLM(tokenizerFactory, maxTokenNGram);
            ++i;
        }
        return new DynamicLMClassifier(categories, lms);
    }

    static MultivariateEstimator createCategoryEstimator(String[] categories) {
        MultivariateEstimator estimator = new MultivariateEstimator();
        int i = 0;
        while (i < categories.length) {
            estimator.train(categories[i], 1L);
            ++i;
        }
        return estimator;
    }

    private static class Externalizer<LL extends LanguageModel.Dynamic>
    extends AbstractExternalizable {
        static final long serialVersionUID = -5411956637253735953L;
        final DynamicLMClassifier<LL> mClassifier;

        public Externalizer() {
            this.mClassifier = null;
        }

        public Externalizer(DynamicLMClassifier<LL> classifier) {
            this.mClassifier = classifier;
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeObject(this.mClassifier.categories());
            ((MultivariateEstimator)this.mClassifier.categoryDistribution()).compileTo(objOut);
            int numCategories = this.mClassifier.mCategories.length;
            int i = 0;
            while (i < numCategories) {
                ((LanguageModel.Dynamic[])this.mClassifier.mLanguageModels)[i].compileTo(objOut);
                ++i;
            }
        }

        @Override
        public Object read(ObjectInput objIn) throws ClassNotFoundException, IOException {
            String[] categories = (String[])objIn.readObject();
            MultivariateDistribution categoryEstimator = (MultivariateDistribution)objIn.readObject();
            LanguageModel[] models = new LanguageModel[categories.length];
            int i = 0;
            while (i < models.length) {
                models[i] = (LanguageModel)objIn.readObject();
                ++i;
            }
            return new LMClassifier(categories, models, categoryEstimator);
        }
    }
}

