/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.Classification;

public class RankedClassification
extends Classification {
    private final String[] mCategories;

    public RankedClassification(String[] categories) {
        super(categories.length == 0 ? null : categories[0]);
        this.mCategories = categories;
    }

    public int size() {
        return this.mCategories.length;
    }

    public String category(int rank) {
        this.checkRange(rank);
        return this.mCategories[rank];
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rank  Category\n");
        int i = 0;
        while (i < this.size()) {
            sb.append("rank " + i + "=" + this.category(i) + '\n');
            ++i;
        }
        return sb.toString();
    }

    void checkRange(int rank) {
        if (rank < 0 || rank >= this.size()) {
            String msg = "Rank out of bounds. Rank=" + rank + " size()=" + this.size();
            throw new IllegalArgumentException(msg);
        }
    }
}

