/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.cluster;

import com.aliasi.cluster.AbstractHierarchicalClusterer;
import com.aliasi.cluster.Dendrogram;
import com.aliasi.cluster.LeafDendrogram;
import com.aliasi.cluster.LinkDendrogram;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Distance;
import com.aliasi.util.ObjectToSet;
import com.aliasi.util.ScoredObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class CompleteLinkClusterer<E>
extends AbstractHierarchicalClusterer<E> {
    public CompleteLinkClusterer(double maxDistance, Distance<? super E> distance) {
        super(maxDistance, distance);
    }

    public CompleteLinkClusterer(Distance<? super E> distance) {
        this(Double.POSITIVE_INFINITY, distance);
    }

    @Override
    public Dendrogram<E> hierarchicalCluster(Set<? extends E> elementSet) {
        if (elementSet.size() == 0) {
            String msg = "Require non-empty set to form dendrogram. Found elementSet.size()=" + elementSet.size();
            throw new IllegalArgumentException(msg);
        }
        if (elementSet.size() == 1) {
            return new LeafDendrogram<E>(elementSet.iterator().next());
        }
        BoundedPriorityQueue queue = new BoundedPriorityQueue(ScoredObject.reverseComparator(), Integer.MAX_VALUE);
        ObjectToSet index = new ObjectToSet();
        E[] elements = this.toElements(elementSet);
        LeafDendrogram[] leafs = new LeafDendrogram[elements.length];
        int i = 0;
        while (i < leafs.length) {
            leafs[i] = new LeafDendrogram<E>(elements[i]);
            ++i;
        }
        double maxDistance = this.getMaxDistance();
        int i2 = 0;
        while (i2 < elements.length) {
            E eI = elements[i2];
            LeafDendrogram dI = leafs[i2];
            int j = i2 + 1;
            while (j < elements.length) {
                E eJ = elements[j];
                double score = this.distance().distance(eI, eJ);
                LeafDendrogram dJ = leafs[j];
                AbstractHierarchicalClusterer.PairScore psIJ = new AbstractHierarchicalClusterer.PairScore(dI, dJ, score);
                queue.offer(psIJ);
                index.addMember(dI, psIJ);
                index.addMember(dJ, psIJ);
                ++j;
            }
            ++i2;
        }
        while (queue.size() > 0) {
            Dendrogram dendro3;
            AbstractHierarchicalClusterer.PairScore next = (AbstractHierarchicalClusterer.PairScore)queue.poll();
            Dendrogram dendro1 = next.mDendrogram1.dereference();
            Dendrogram dendro2 = next.mDendrogram2.dereference();
            double dist12 = next.score();
            LinkDendrogram dendro12 = new LinkDendrogram(dendro1, dendro2, dist12);
            HashMap distanceBuf = new HashMap();
            Set ps3Set = (Set)index.remove(dendro1);
            queue.removeAll(ps3Set);
            for (AbstractHierarchicalClusterer.PairScore ps3 : ps3Set) {
                dendro3 = ps3.mDendrogram1 == dendro1 ? ps3.mDendrogram2 : ps3.mDendrogram1;
                ((Set)index.get(dendro3)).remove(ps3);
                double dist1_3 = ps3.score();
                distanceBuf.put(dendro3, dist1_3);
            }
            ps3Set = (Set)index.remove(dendro2);
            queue.removeAll(ps3Set);
            for (AbstractHierarchicalClusterer.PairScore ps3 : ps3Set) {
                dendro3 = ps3.mDendrogram1 == dendro2 ? ps3.mDendrogram2 : ps3.mDendrogram1;
                ((Set)index.get(dendro3)).remove(ps3);
                Double dist1_3D = (Double)distanceBuf.get(dendro3);
                if (dist1_3D == null) continue;
                double dist1_3 = dist1_3D;
                double dist2_3 = ps3.score();
                double dist12_3 = Math.max(dist1_3, dist2_3);
                AbstractHierarchicalClusterer.PairScore ps = new AbstractHierarchicalClusterer.PairScore(dendro12, dendro3, dist12_3);
                queue.offer(ps);
                index.addMember(dendro12, ps);
                index.addMember(dendro3, ps);
            }
            if (!queue.isEmpty()) continue;
            return dendro12;
        }
        Iterator it = index.keySet().iterator();
        LinkDendrogram dendro = (LinkDendrogram)it.next();
        while (it.hasNext()) {
            dendro = new LinkDendrogram(dendro, (Dendrogram)it.next(), Double.POSITIVE_INFINITY);
        }
        return dendro;
    }
}

