/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.coref;

import com.aliasi.coref.Mention;
import com.aliasi.coref.MentionChain;
import com.aliasi.coref.MentionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class WithinDocCoref {
    private final List<MentionChain> mMentionChains = new ArrayList<MentionChain>();
    private final MentionFactory mMentionFactory;
    public static final Comparator<MentionChain> SENTENCE_FINAL_COMPARATOR = new Comparator<MentionChain>(){

        @Override
        public int compare(MentionChain chain1, MentionChain chain2) {
            if (chain1.maxSentenceOffset() < chain2.maxSentenceOffset()) {
                return 1;
            }
            if (chain1.maxSentenceOffset() > chain2.maxSentenceOffset()) {
                return -1;
            }
            return 0;
        }
    };
    static final MentionChain[] EMPTY_MENTION_CHAIN_ARRAY = new MentionChain[0];

    public WithinDocCoref(MentionFactory mentionFactory) {
        this.mMentionFactory = mentionFactory;
    }

    public MentionChain[] mentionChains() {
        return this.mMentionChains.toArray(EMPTY_MENTION_CHAIN_ARRAY);
    }

    public int resolveMention(Mention mention, int offset) {
        List[] hypotheses = new List[7];
        int i = 0;
        while (i < hypotheses.length) {
            hypotheses[i] = new ArrayList();
            ++i;
        }
        MentionChain[] antecedents = this.mentionChains();
        Arrays.sort(antecedents, SENTENCE_FINAL_COMPARATOR);
        int i2 = 0;
        while (i2 < antecedents.length) {
            MentionChain nextAntecedent = antecedents[i2];
            if (this.finished(offset, nextAntecedent, hypotheses)) break;
            this.addPossibleAntecedent(mention, offset, nextAntecedent, hypotheses);
            ++i2;
        }
        return this.selectAntecedent(hypotheses, mention, offset);
    }

    private boolean finished(int mentionOffset, MentionChain chain, List<MentionChain>[] hypotheses) {
        int distance;
        int i = distance = WithinDocCoref.distanceScore(mentionOffset, chain);
        while (i > 0) {
            if (hypotheses[i].size() > 0) {
                return true;
            }
            --i;
        }
        return false;
    }

    private void addPossibleAntecedent(Mention mention, int offset, MentionChain antecedent, List<MentionChain>[] hypotheses) {
        if (antecedent.killed(mention)) {
            return;
        }
        int matchScore = antecedent.matchScore(mention);
        if (matchScore == -1) {
            return;
        }
        int totalScore = matchScore + WithinDocCoref.distanceScore(offset, antecedent);
        hypotheses[totalScore].add(antecedent);
    }

    private int selectAntecedent(List<MentionChain>[] hypotheses, Mention mention, int offset) {
        int score = 0;
        while (score < hypotheses.length) {
            if (hypotheses[score].size() == 1) {
                MentionChain antecedent = hypotheses[score].get(0);
                antecedent.add(mention, offset);
                return antecedent.identifier();
            }
            if (hypotheses[score].size() > 1) {
                return this.promoteToNewChain(mention, offset);
            }
            ++score;
        }
        return this.promoteToNewChain(mention, offset);
    }

    private int promoteToNewChain(Mention mention, int offset) {
        if (mention.isPronominal()) {
            return -1;
        }
        MentionChain chain = this.mMentionFactory.promote(mention, offset);
        this.mMentionChains.add(chain);
        return chain.identifier();
    }

    private static int distanceScore(int mentionOffset, MentionChain antecedent) {
        switch (mentionOffset - antecedent.maxSentenceOffset()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
        }
        return 2;
    }
}

