/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.dict;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.dict.Node;
import com.aliasi.dict.TrieDictionary;
import com.aliasi.spell.WeightedEditDistance;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Scored;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ApproxDictionaryChunker
implements Chunker,
Serializable {
    static final long serialVersionUID = 5364907367744655793L;
    private final TrieDictionary<String> mDictionary;
    private final TokenizerFactory mTokenizerFactory;
    private final WeightedEditDistance mEditDistance;
    private double mDistanceThreshold;
    public static final WeightedEditDistance TT_DISTANCE = new TTDistance();

    public ApproxDictionaryChunker(TrieDictionary<String> dictionary, TokenizerFactory tokenizerFactory, WeightedEditDistance editDistance, double distanceThreshold) {
        this.mDictionary = dictionary;
        this.mTokenizerFactory = tokenizerFactory;
        this.mEditDistance = editDistance;
        this.mDistanceThreshold = distanceThreshold;
    }

    public TrieDictionary<String> dictionary() {
        return this.mDictionary;
    }

    public WeightedEditDistance editDistance() {
        return this.mEditDistance;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.mTokenizerFactory;
    }

    public double distanceThreshold() {
        return this.mDistanceThreshold;
    }

    public void setMaxDistance(double distanceThreshold) {
        this.mDistanceThreshold = distanceThreshold;
    }

    @Override
    public Chunking chunk(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.chunk(cs, 0, cs.length);
    }

    @Override
    public Chunking chunk(char[] cs, int start, int end) {
        String token;
        int length = end - start;
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, length);
        boolean[] startTokens = new boolean[length];
        boolean[] endTokens = new boolean[length + 1];
        Arrays.fill(startTokens, false);
        Arrays.fill(endTokens, false);
        while ((token = tokenizer.nextToken()) != null) {
            int lastStart = tokenizer.lastTokenStartPosition();
            startTokens[lastStart] = true;
            endTokens[lastStart + token.length()] = true;
        }
        HashMap<Dp, Chunk> dpToChunk = new HashMap<Dp, Chunk>();
        HashMap<SearchState, SearchState> queue = new HashMap<SearchState, SearchState>();
        int i = 0;
        while (i < length) {
            int startPlusI = start + i;
            char c = cs[startPlusI];
            if (startTokens[i]) {
                this.add(queue, this.mDictionary.mRootNode, startPlusI, 0.0, false, dpToChunk, cs, startPlusI);
            }
            HashMap<SearchState, SearchState> nextQueue = new HashMap<SearchState, SearchState>();
            double deleteCost = -this.mEditDistance.deleteWeight(c);
            for (SearchState state : queue.values()) {
                this.add(nextQueue, state.mNode, state.mStartIndex, state.mScore + deleteCost, endTokens[i + 1], dpToChunk, cs, startPlusI);
                char[] dtrChars = ((SearchState)state).mNode.mDtrChars;
                Node<C>[] dtrNodes = ((SearchState)state).mNode.mDtrNodes;
                int j = 0;
                while (j < dtrChars.length) {
                    this.add(nextQueue, dtrNodes[j], state.mStartIndex, state.mScore - (dtrChars[j] == c ? this.mEditDistance.matchWeight(dtrChars[j]) : this.mEditDistance.substituteWeight(dtrChars[j], c)), endTokens[i + 1], dpToChunk, cs, startPlusI);
                    ++j;
                }
            }
            queue = nextQueue;
            ++i;
        }
        ChunkingImpl result = new ChunkingImpl(cs, start, end);
        for (Chunk chunk : dpToChunk.values()) {
            result.add(chunk);
        }
        return result;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    void add(Map<SearchState, SearchState> nextQueue, Node<String> node, int startIndex, double chunkScore, boolean isTokenEnd, Map<Dp, Chunk> chunking, char[] cs, int end) {
        int i;
        if (chunkScore > this.mDistanceThreshold) {
            return;
        }
        SearchState state2 = new SearchState(node, startIndex, chunkScore);
        SearchState exState = nextQueue.get(state2);
        if (exState != null && exState.mScore < chunkScore) {
            return;
        }
        nextQueue.put(state2, state2);
        if (isTokenEnd) {
            i = 0;
            while (i < node.mEntries.length) {
                Chunk newChunk = ChunkFactory.createChunk(startIndex, end + 1, ((String)node.mEntries[i].category()).toString(), chunkScore);
                Dp dpNewChunk = new Dp(newChunk);
                Chunk oldChunk = chunking.get(dpNewChunk);
                if (oldChunk == null || !(oldChunk.score() <= chunkScore)) {
                    chunking.remove(dpNewChunk);
                    chunking.put(dpNewChunk, newChunk);
                }
                ++i;
            }
        }
        i = 0;
        while (i < node.mDtrChars.length) {
            this.add(nextQueue, node.mDtrNodes[i], startIndex, chunkScore - this.mEditDistance.insertWeight(node.mDtrChars[i]), isTokenEnd, chunking, cs, end);
            ++i;
        }
    }

    static final class Dp {
        final int mStart;
        final int mEnd;
        final String mType;
        int mHashCode;

        Dp(Chunk chunk) {
            this.mStart = chunk.start();
            this.mEnd = chunk.end();
            this.mType = chunk.type();
            this.mHashCode = this.mStart + 31 * (this.mEnd + 31 * this.mType.hashCode());
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object that) {
            Dp thatDp = (Dp)that;
            return this.mStart == thatDp.mStart && this.mEnd == thatDp.mEnd && this.mType.equals(thatDp.mType);
        }
    }

    static final class SearchState
    implements Scored {
        private final double mScore;
        private final Node<String> mNode;
        private final int mStartIndex;

        SearchState(Node<String> node, int startIndex) {
            this(node, startIndex, 0.0);
        }

        SearchState(Node<String> node, int startIndex, double score) {
            this.mNode = node;
            this.mStartIndex = startIndex;
            this.mScore = score;
        }

        @Override
        public double score() {
            return this.mScore;
        }

        public boolean equals(Object that) {
            SearchState thatState = (SearchState)that;
            return this.mStartIndex == thatState.mStartIndex && this.mNode == thatState.mNode;
        }

        public int hashCode() {
            return this.mStartIndex;
        }

        public String toString() {
            return "SearchState(" + this.mNode + ", " + this.mStartIndex + ", " + this.mScore + ")";
        }
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 3935654738558540166L;
        private final ApproxDictionaryChunker mChunker;

        public Serializer() {
            this(null);
        }

        public Serializer(ApproxDictionaryChunker chunker) {
            this.mChunker = chunker;
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            TrieDictionary dictionary = (TrieDictionary)in.readObject();
            TokenizerFactory tokenizerFactory = (TokenizerFactory)in.readObject();
            WeightedEditDistance editDistance = (WeightedEditDistance)in.readObject();
            double distanceThreshold = in.readDouble();
            return new ApproxDictionaryChunker(dictionary, tokenizerFactory, editDistance, distanceThreshold);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.mChunker.mDictionary);
            out.writeObject(this.mChunker.mTokenizerFactory);
            out.writeObject(this.mChunker.mEditDistance);
            out.writeDouble(this.mChunker.mDistanceThreshold);
        }
    }

    static final class TTDistance
    extends WeightedEditDistance {
        TTDistance() {
        }

        @Override
        public double deleteWeight(char cDeleted) {
            return cDeleted == ' ' || cDeleted == '-' ? -10.0 : -100.0;
        }

        @Override
        public double insertWeight(char cInserted) {
            return this.deleteWeight(cInserted);
        }

        @Override
        public double matchWeight(char cMatched) {
            return 0.0;
        }

        @Override
        public double substituteWeight(char cDeleted, char cInserted) {
            if (cDeleted == ' ' && cInserted == '-') {
                return -10.0;
            }
            if (cDeleted == '-' && cInserted == ' ') {
                return -10.0;
            }
            if (Character.isDigit(cDeleted) && Character.isDigit(cInserted)) {
                return -10.0;
            }
            if (Character.toLowerCase(cDeleted) == Character.toLowerCase(cInserted)) {
                return -10.0;
            }
            return -50.0;
        }

        @Override
        public double transposeWeight(char c1, char c2) {
            return Double.NEGATIVE_INFINITY;
        }
    }
}

