/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.dict;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.dict.Dictionary;
import com.aliasi.dict.DictionaryEntry;
import com.aliasi.tokenizer.LowerCaseTokenizerFactory;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.Scored;
import com.aliasi.util.ScoredObject;
import com.aliasi.util.Strings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ExactDictionaryChunker
implements Chunker {
    final TrieNode mTrieRootNode;
    final TokenizerFactory mTokenizerFactory;
    final boolean mCaseSensitive;
    boolean mReturnAllMatches;
    int mMaxPhraseLength = 0;
    static ScoredCat[] EMPTY_SCORED_CATS = new ScoredCat[0];
    static final Chunk[] EMPTY_CHUNK_ARRAY = new Chunk[0];

    public ExactDictionaryChunker(Dictionary<String> dict, TokenizerFactory factory) {
        this(dict, factory, true, true);
    }

    public ExactDictionaryChunker(Dictionary<String> dict, TokenizerFactory factory, boolean returnAllMatches, boolean caseSensitive) {
        this.mTokenizerFactory = factory;
        this.mReturnAllMatches = returnAllMatches;
        this.mCaseSensitive = caseSensitive;
        this.mTrieRootNode = this.compileTrie(dict);
    }

    public TokenizerFactory tokenizerFactory() {
        return this.mTokenizerFactory;
    }

    public boolean caseSensitive() {
        return this.mCaseSensitive;
    }

    public boolean returnAllMatches() {
        return this.mReturnAllMatches;
    }

    public void setReturnAllMatches(boolean returnAllMatches) {
        this.mReturnAllMatches = returnAllMatches;
    }

    @Override
    public Chunking chunk(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.chunk(cs, 0, cs.length);
    }

    final Tokenizer tokenizer(char[] cs, int start, int end) {
        TokenizerFactory factory = this.mCaseSensitive ? this.mTokenizerFactory : new LowerCaseTokenizerFactory(this.mTokenizerFactory);
        return factory.tokenizer(cs, start, end - start);
    }

    @Override
    public Chunking chunk(char[] cs, int start, int end) {
        String token;
        ChunkingImpl chunking = new ChunkingImpl(cs, start, end);
        if (this.mMaxPhraseLength == 0) {
            return chunking;
        }
        CircularQueueInt queue = new CircularQueueInt(this.mMaxPhraseLength);
        Tokenizer tokenizer = this.tokenizer(cs, start, end);
        TrieNode node = this.mTrieRootNode;
        while ((token = tokenizer.nextToken()) != null) {
            int tokenStartPos = tokenizer.lastTokenStartPosition();
            int tokenEndPos = tokenizer.lastTokenEndPosition();
            queue.enqueue(tokenStartPos);
            while (true) {
                TrieNode daughterNode;
                if ((daughterNode = node.getDaughter(token)) != null) {
                    node = daughterNode;
                    break;
                }
                if (node.mSuffixNode == null) {
                    node = this.mTrieRootNode.getDaughter(token);
                    if (node != null) break;
                    node = this.mTrieRootNode;
                    break;
                }
                node = node.mSuffixNode;
            }
            this.emit(node, queue, tokenEndPos, chunking);
            TrieNode suffixNode = node.mSuffixNodeWithCategory;
            while (suffixNode != null) {
                this.emit(suffixNode, queue, tokenEndPos, chunking);
                suffixNode = suffixNode.mSuffixNodeWithCategory;
            }
        }
        return this.mReturnAllMatches ? chunking : ExactDictionaryChunker.restrictToLongest(chunking);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExactDictionaryChunker\n");
        sb.append("Tokenizer factory=" + this.mTokenizerFactory.getClass() + "\n");
        sb.append("(toString) mCaseSensitive=" + this.mCaseSensitive + "\n");
        sb.append("Return all matches=" + this.mReturnAllMatches + "\n\n");
        this.mTrieRootNode.toString(sb, 0);
        return sb.toString();
    }

    void emit(TrieNode node, CircularQueueInt queue, int end, ChunkingImpl chunking) {
        ScoredCat[] scoredCats = node.mCategories;
        int i = 0;
        while (i < scoredCats.length) {
            int start = queue.get(node.depth());
            String type = scoredCats[i].mCat;
            double score = scoredCats[i].mScore;
            Chunk chunk = ChunkFactory.createChunk(start, end, type, score);
            chunking.add(chunk);
            ++i;
        }
    }

    final TrieNode compileTrie(Dictionary<String> dict) {
        TrieNode rootNode = new TrieNode(0);
        for (DictionaryEntry dictionaryEntry : dict) {
            String phrase = dictionaryEntry.phrase();
            char[] cs = phrase.toCharArray();
            Tokenizer tokenizer = this.tokenizer(cs, 0, cs.length);
            int length = rootNode.add(tokenizer, dictionaryEntry);
            if (length <= this.mMaxPhraseLength) continue;
            this.mMaxPhraseLength = length;
        }
        this.computeSuffixes(rootNode, rootNode, new String[this.mMaxPhraseLength], 0);
        return rootNode;
    }

    final void computeSuffixes(TrieNode node, TrieNode rootNode, String[] tokens, int length) {
        TrieNode suffixNode;
        int i = 1;
        while (i < length) {
            suffixNode = rootNode.getDaughter(tokens, i, length);
            if (suffixNode != null) {
                node.mSuffixNode = suffixNode;
                break;
            }
            ++i;
        }
        i = 1;
        while (i < length) {
            suffixNode = rootNode.getDaughter(tokens, i, length);
            if (suffixNode != null && suffixNode.mCategories.length != 0) {
                node.mSuffixNodeWithCategory = suffixNode;
                break;
            }
            ++i;
        }
        if (node.mDaughterMap == null) {
            return;
        }
        for (Map.Entry<String, TrieNode> entry : node.mDaughterMap.entrySet()) {
            tokens[length] = entry.getKey().toString();
            TrieNode dtrNode = entry.getValue();
            this.computeSuffixes(dtrNode, rootNode, tokens, length + 1);
        }
    }

    static Chunking restrictToLongest(Chunking chunking) {
        ChunkingImpl result = new ChunkingImpl(chunking.charSequence());
        Set<Chunk> chunkSet = chunking.chunkSet();
        if (chunkSet.size() == 0) {
            return chunking;
        }
        Chunk[] chunks = chunkSet.toArray(EMPTY_CHUNK_ARRAY);
        Arrays.sort(chunks, Chunk.LONGEST_MATCH_ORDER_COMPARATOR);
        int lastEnd = -1;
        int i = 0;
        while (i < chunks.length) {
            if (chunks[i].start() >= lastEnd) {
                result.add(chunks[i]);
                lastEnd = chunks[i].end();
            }
            ++i;
        }
        return result;
    }

    static class CircularQueueInt {
        final int[] mQueue;
        int mNextPos = 0;

        public CircularQueueInt(int size) {
            this.mQueue = new int[size];
            Arrays.fill(this.mQueue, 0);
        }

        public void enqueue(int val) {
            this.mQueue[this.mNextPos] = val;
            if (++this.mNextPos == this.mQueue.length) {
                this.mNextPos = 0;
            }
        }

        public int get(int offset) {
            int pos = this.mNextPos - offset;
            if (pos < 0) {
                pos += this.mQueue.length;
            }
            return this.mQueue[pos];
        }
    }

    static class ScoredCat
    implements Scored {
        String mCat;
        double mScore;

        ScoredCat(String cat, double score) {
            this.mCat = cat;
            this.mScore = score;
        }

        @Override
        public double score() {
            return this.mScore;
        }

        public String toString() {
            return String.valueOf(this.mCat) + ":" + this.mScore;
        }
    }

    static class TrieNode {
        int mDepth;
        Map<String, TrieNode> mDaughterMap = null;
        ScoredCat[] mCategories = EMPTY_SCORED_CATS;
        TrieNode mSuffixNode;
        TrieNode mSuffixNodeWithCategory;

        TrieNode(int depth) {
            this.mDepth = depth;
        }

        public int depth() {
            return this.mDepth;
        }

        public void addEntry(DictionaryEntry<String> entry) {
            ScoredCat[] newCats = new ScoredCat[this.mCategories.length + 1];
            System.arraycopy(this.mCategories, 0, newCats, 0, this.mCategories.length);
            newCats[newCats.length - 1] = new ScoredCat(entry.category().toString(), entry.score());
            Arrays.sort(newCats, ScoredObject.reverseComparator());
            this.mCategories = newCats;
        }

        public TrieNode getDaughter(String[] tokens, int start, int end) {
            TrieNode node = this;
            int i = start;
            while (i < end && node != null) {
                node = node.getDaughter(tokens[i]);
                ++i;
            }
            return node;
        }

        public TrieNode getDaughter(String token) {
            return this.mDaughterMap == null ? null : this.mDaughterMap.get(token);
        }

        public TrieNode getOrCreateDaughter(String token) {
            TrieNode existingDaughter = this.getDaughter(token);
            if (existingDaughter != null) {
                return existingDaughter;
            }
            TrieNode newDaughter = new TrieNode(this.depth() + 1);
            if (this.mDaughterMap == null) {
                this.mDaughterMap = new HashMap<String, TrieNode>(2);
            }
            this.mDaughterMap.put(token, newDaughter);
            return newDaughter;
        }

        public int add(Tokenizer tokenizer, DictionaryEntry<String> entry) {
            String token;
            TrieNode node = this;
            while ((token = tokenizer.nextToken()) != null) {
                node = node.getOrCreateDaughter(token);
            }
            node.addEntry(entry);
            return node.depth();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb, 0);
            return sb.toString();
        }

        String id() {
            return String.valueOf(this.mDepth) + ":" + Integer.toHexString(this.hashCode());
        }

        void toString(StringBuilder sb, int depth) {
            TrieNode.indent(sb, depth);
            sb.append(this.id());
            int i = 0;
            while (i < this.mCategories.length) {
                TrieNode.indent(sb, depth);
                sb.append("cat " + i + "=" + this.mCategories[i]);
                ++i;
            }
            if (this.mSuffixNode != null) {
                TrieNode.indent(sb, depth);
                sb.append("suffixNode=");
                sb.append(this.mSuffixNode.id());
            }
            if (this.mSuffixNodeWithCategory != null) {
                TrieNode.indent(sb, depth);
                sb.append("suffixNodeWithCat=");
                sb.append(this.mSuffixNodeWithCategory.id());
            }
            if (this.mDaughterMap == null) {
                return;
            }
            for (String token : this.mDaughterMap.keySet()) {
                TrieNode.indent(sb, depth);
                sb.append(token);
                this.getDaughter(token).toString(sb, depth + 1);
            }
        }

        static void indent(StringBuilder sb, int depth) {
            sb.append("\n");
            int i = 0;
            while (i < depth) {
                sb.append("  ");
                ++i;
            }
        }
    }
}

