/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.features;

import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import com.aliasi.util.ObjectToDoubleMap;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AddFeatureExtractor<E>
implements FeatureExtractor<E>,
Serializable {
    static final long serialVersionUID = -79320527848334652L;
    private final List<FeatureExtractor<? super E>> mExtractors;

    public AddFeatureExtractor(Collection<? extends FeatureExtractor<? super E>> extractors) {
        this.mExtractors = new ArrayList<FeatureExtractor<FeatureExtractor<? super E>>>(extractors);
    }

    public AddFeatureExtractor(FeatureExtractor<? super E> extractor1, FeatureExtractor<? super E> extractor2) {
        this.mExtractors = new ArrayList<FeatureExtractor<? super E>>(2);
        this.mExtractors.add(extractor1);
        this.mExtractors.add(extractor2);
    }

    public AddFeatureExtractor(FeatureExtractor<? super E> ... extractors) {
        this(Arrays.asList(extractors));
    }

    @Override
    public Map<String, ? extends Number> features(E in) {
        ObjectToDoubleMap<String> result = new ObjectToDoubleMap<String>();
        for (FeatureExtractor<E> extractor : this.mExtractors) {
            for (Map.Entry<String, Number> featMap : extractor.features(in).entrySet()) {
                result.increment(featMap.getKey(), featMap.getValue().doubleValue());
            }
        }
        return result;
    }

    public List<FeatureExtractor<? super E>> baseFeatureExtractors() {
        return Collections.unmodifiableList(this.mExtractors);
    }

    Object writeReplace() {
        return new Externalizer(this);
    }

    static class Externalizer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = -3717190107802122376L;
        final AddFeatureExtractor<F> mAddFeatureExtractor;

        public Externalizer(AddFeatureExtractor<F> addFeatureExtractor) {
            this.mAddFeatureExtractor = addFeatureExtractor;
        }

        public Externalizer() {
            this(null);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(((AddFeatureExtractor)this.mAddFeatureExtractor).mExtractors.size());
            for (FeatureExtractor extractor : ((AddFeatureExtractor)this.mAddFeatureExtractor).mExtractors) {
                out.writeObject(extractor);
            }
        }

        @Override
        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            int size = in.readInt();
            ArrayList<FeatureExtractor> extractors = new ArrayList<FeatureExtractor>();
            int i = 0;
            while (i < size) {
                FeatureExtractor extractor = (FeatureExtractor)in.readObject();
                extractors.add(extractor);
                ++i;
            }
            return new AddFeatureExtractor(extractors);
        }
    }
}

