/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.io.BitOutput;
import com.aliasi.lm.BitTrie;
import com.aliasi.lm.TrieReader;
import com.aliasi.lm.TrieWriter;
import java.io.IOException;

public class BitTrieWriter
extends BitTrie
implements TrieWriter {
    private final BitOutput mBitOutput;

    public BitTrieWriter(BitOutput bitOutput) {
        this.mBitOutput = bitOutput;
    }

    @Override
    public void writeCount(long count) throws IOException {
        BitTrieWriter.checkCount(count);
        this.mBitOutput.writeDelta(count);
        this.pushValue(-1L);
    }

    @Override
    public void writeSymbol(long symbol) throws IOException {
        if (symbol == -1L) {
            this.mBitOutput.writeDelta(1L);
            this.popValue();
        } else {
            long code = symbol - this.popValue() + 1L;
            this.mBitOutput.writeDelta(code);
            this.pushValue(symbol);
        }
    }

    public static void copy(TrieReader reader, TrieWriter writer) throws IOException {
        long symbol;
        long count = reader.readCount();
        writer.writeCount(count);
        while ((symbol = reader.readSymbol()) != -1L) {
            writer.writeSymbol(symbol);
            BitTrieWriter.copy(reader, writer);
        }
        writer.writeSymbol(-1L);
    }
}

