/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.AbstractMatrix;
import java.util.Arrays;

public class DenseMatrix
extends AbstractMatrix {
    private final double[][] mValues;
    private final int mNumRows;
    private final int mNumColumns;
    private static final boolean IGNORE = true;

    public DenseMatrix(int numRows, int numColumns) {
        this(DenseMatrix.zeroValues(numRows, numColumns), true);
    }

    public DenseMatrix(double[][] values) {
        this(DenseMatrix.copyValues(values), true);
    }

    DenseMatrix(double[][] values, boolean ignoreMe) {
        this.mValues = values;
        this.mNumRows = values.length;
        if (this.mNumRows < 1) {
            String msg = "Require positive number of rows. Found number of rows=" + this.mNumRows;
            throw new IllegalArgumentException(msg);
        }
        this.mNumColumns = values[0].length;
        if (this.mNumColumns < 1) {
            String msg = "Require positive number of columns. Found number of columns=" + this.mNumColumns;
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public final int numRows() {
        return this.mNumRows;
    }

    @Override
    public final int numColumns() {
        return this.mNumColumns;
    }

    @Override
    public double value(int row, int column) {
        return this.mValues[row][column];
    }

    @Override
    public void setValue(int row, int column, double value) {
        this.mValues[row][column] = value;
    }

    private static int numColumns(double[][] values) {
        int numColumns = 0;
        int i = 0;
        while (i < values.length) {
            numColumns = Math.max(numColumns, values[i].length);
            ++i;
        }
        return numColumns;
    }

    private static double[][] copyValues(double[][] values) {
        int numRows = values.length;
        int numColumns = DenseMatrix.numColumns(values);
        double[][] result = new double[numRows][numColumns];
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < values[i].length) {
                result[i][j] = values[i][j];
                ++j;
            }
            j = values[i].length;
            while (j < numColumns) {
                result[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static double[][] zeroValues(int numRows, int numColumns) {
        double[][] result = new double[numRows][numColumns];
        int i = 0;
        while (i < result.length) {
            Arrays.fill(result[i], 0.0);
            ++i;
        }
        return result;
    }
}

