/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.spell;

import com.aliasi.spell.WeightedEditDistance;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Math;
import com.aliasi.util.Scored;
import com.aliasi.util.ScoredObject;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class AutoCompleter
implements Serializable {
    static final long serialVersionUID = -6846604550231066369L;
    final double mTotalCount;
    final String[] mPhrases;
    final float[] mPhraseLog2Probs;
    final char[] mLabels;
    final int[] mFirstDtr;
    final int[] mFirstOutcome;
    final int[] mOutcomes;
    int mMaxSearchQueueSize;
    final int mMaxResultsPerPrefix;
    final WeightedEditDistance mEditDistance;
    final double mMinScore;

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public AutoCompleter(Map<String, ? extends Number> phraseCounts, WeightedEditDistance editDistance, int maxResultsPerPrefix, int maxSearchQueueSize, double minScore) {
        super();
        if (Double.isInfinite(minScore) || Double.isNaN(minScore) || minScore >= 0.0) {
            msg = "Minimum score must be finite and negative. Found minScore=" + minScore;
            throw new IllegalArgumentException(msg);
        }
        this.mMinScore = minScore;
        phrases = new String[phraseCounts.size()];
        counts = new float[phraseCounts.size()];
        this.mPhrases = phrases;
        idx = 0;
        for (Map.Entry<String, ? extends Number> entry : phraseCounts.entrySet()) {
            this.mPhrases[idx] = entry.getKey();
            counts[idx] = entry.getValue().floatValue();
            if (Float.isNaN(counts[idx]) || Float.isInfinite(counts[idx]) || counts[idx] < 0.0f) {
                msg = "Counts must be finite and non-negative. Found phrase=" + entry.getKey() + " count=" + entry.getValue();
                throw new IllegalArgumentException(msg);
            }
            ++idx;
        }
        this.setMaxSearchQueueSize(maxSearchQueueSize);
        if (maxResultsPerPrefix <= 0) {
            msg = "Max results per prefix must be positive. Found maxResultsPerPrefix=" + maxResultsPerPrefix;
            throw new IllegalArgumentException(msg);
        }
        this.mMaxResultsPerPrefix = maxResultsPerPrefix;
        this.mEditDistance = editDistance;
        phraseLog2Probs = new float[counts.length];
        this.mPhraseLog2Probs = phraseLog2Probs;
        totalCount = 0.0;
        i = 0;
        while (i < counts.length) {
            totalCount += (double)counts[i];
            ++i;
        }
        this.mTotalCount = totalCount;
        i = 0;
        while (i < counts.length) {
            phraseLog2Probs[i] = (float)Math.log2((double)counts[i] / totalCount);
            ++i;
        }
        maxLength = AutoCompleter.maxLength(phrases);
        numNodes = new int[maxLength];
        last = "";
        var19_17 = phrases;
        var18_19 = phrases.length;
        var17_22 = 0;
        while (var17_22 < var18_19) {
            phrase = var19_17[var17_22];
            pos = AutoCompleter.prefixMatchLength(phrase, last);
            while (pos < phrase.length()) {
                v0 = pos++;
                numNodes[v0] = numNodes[v0] + 1;
            }
            last = phrase;
            ++var17_22;
        }
        totalNumNodes = 1;
        pos = 0;
        while (pos < maxLength) {
            totalNumNodes += numNodes[pos];
            ++pos;
        }
        nextIndex = new int[maxLength];
        nextIndex[0] = 1;
        pos = 1;
        while (pos < maxLength) {
            nextIndex[pos] = nextIndex[pos - 1] + numNodes[pos - 1];
            ++pos;
        }
        this.mLabels = new char[totalNumNodes];
        this.mFirstDtr = new int[totalNumNodes + 1];
        this.mFirstOutcome = new int[totalNumNodes + 1];
        last = "";
        var21_28 = phrases;
        pos = phrases.length;
        var19_18 = 0;
        while (var19_18 < pos) {
            phrase = var21_28[var19_18];
            pos = AutoCompleter.prefixMatchLength(phrase, last);
            while (pos < phrase.length()) {
                this.mLabels[nextIndex[pos]] = phrase.charAt(pos);
                this.mFirstDtr[nextIndex[pos]] = pos + 1 < nextIndex.length ? nextIndex[pos + 1] : totalNumNodes;
                v1 = pos++;
                nextIndex[v1] = nextIndex[v1] + 1;
            }
            last = phrase;
            ++var19_18;
        }
        outcomesLength = 0;
        prefixCount = 0;
        length = 0;
        while (length <= maxLength) {
            i = 0;
            ** GOTO lbl103
            {
                ++i;
                do {
                    if (i < phrases.length && phrases[i].length() < length) continue block10;
                    if (i >= phrases.length) break block10;
                    currentPrefix = phrases[i].substring(0, length);
                    while (i < phrases.length && phrases[i].startsWith(currentPrefix)) {
                        ++prefixCount;
                        ++i;
                    }
                    outcomesLength += java.lang.Math.min(prefixCount, maxResultsPerPrefix);
                    prefixCount = 0;
lbl103:
                    // 2 sources

                } while (i < phrases.length);
            }
            ++length;
        }
        this.mOutcomes = new int[outcomesLength];
        queue = new BoundedPriorityQueue<ScoredObject<Integer>>(ScoredObject.comparator(), maxResultsPerPrefix);
        prefixIdx = 0;
        id = 0;
        length = 0;
        while (length <= maxLength) {
            i = 0;
            ** GOTO lbl129
            {
                ++i;
                do {
                    if (i < phrases.length && phrases[i].length() < length) continue block14;
                    if (i >= phrases.length) break block14;
                    currentPrefix = phrases[i].substring(0, length);
                    while (i < phrases.length && phrases[i].startsWith(currentPrefix)) {
                        queue.offer(new ScoredObject<Integer>(i, phraseLog2Probs[i]));
                        ++i;
                    }
                    this.mFirstOutcome[prefixIdx++] = id;
                    for (ScoredObject so : queue) {
                        this.mOutcomes[id++] = (Integer)so.getObject();
                    }
                    queue.clear();
lbl129:
                    // 2 sources

                } while (i < phrases.length);
            }
            ++length;
        }
        this.mFirstDtr[this.mFirstDtr.length - 1] = this.mFirstDtr.length - 1;
        this.mFirstOutcome[this.mFirstOutcome.length - 1] = this.mOutcomes.length;
    }

    public int maxResultsPerPrefix() {
        return this.mMaxResultsPerPrefix;
    }

    public WeightedEditDistance editDistance() {
        return this.mEditDistance;
    }

    public Map<String, Float> phraseCountMap() {
        HashMap<String, Float> counter = new HashMap<String, Float>(this.mPhrases.length * 3 / 2);
        int i = 0;
        while (i < this.mPhrases.length) {
            counter.put(this.mPhrases[i], Float.valueOf((float)(this.mTotalCount * java.lang.Math.pow(2.0, this.mPhraseLog2Probs[i]))));
            ++i;
        }
        return counter;
    }

    public int maxSearchQueueSize() {
        return this.mMaxSearchQueueSize;
    }

    public void setMaxSearchQueueSize(int size) {
        if (size <= 0) {
            String msg = "Max queue size must be positive. Found maxSearchQueueSize=" + size;
            throw new IllegalArgumentException(msg);
        }
        this.mMaxSearchQueueSize = size;
    }

    public SortedSet<ScoredObject<String>> complete(String in) {
        Results results = new Results(this.mMaxResultsPerPrefix);
        BoundedPriorityQueue<SearchState> queue = new BoundedPriorityQueue<SearchState>(ScoredObject.comparator(), this.mMaxSearchQueueSize);
        queue.offer(new SearchState(0, 0, 0.0, this.mPhraseLog2Probs[0]));
        while (!queue.isEmpty()) {
            double bestCompletionCost;
            SearchState state = (SearchState)queue.poll();
            if (results.dominate(state.mEditCost)) {
                return results;
            }
            if (state.mInputPosition == in.length()) {
                int k = this.mFirstOutcome[state.mTrieNode];
                while (k < this.mFirstOutcome[state.mTrieNode + 1]) {
                    double score = (double)this.mPhraseLog2Probs[this.mOutcomes[k]] + state.mEditCost;
                    if (!(score < this.mMinScore)) {
                        results.add(this.mPhrases[this.mOutcomes[k]], score);
                    }
                    ++k;
                }
                continue;
            }
            char c = in.charAt(state.mInputPosition);
            int i = this.mFirstDtr[state.mTrieNode];
            while (i < this.mFirstDtr[state.mTrieNode + 1]) {
                char d = this.mLabels[i];
                double editCost = c == d ? state.mEditCost : state.mEditCost + this.mEditDistance.substituteWeight(c, d);
                double score = editCost + (bestCompletionCost = (double)this.mPhraseLog2Probs[this.mOutcomes[this.mFirstOutcome[i]]]);
                if (score >= this.mMinScore && !results.dominate(score)) {
                    queue.offer(new SearchState(state.mInputPosition + 1, i, editCost, bestCompletionCost));
                }
                if ((score = (editCost = state.mEditCost + this.mEditDistance.insertWeight(d)) + bestCompletionCost) >= this.mMinScore && !results.dominate(score)) {
                    queue.offer(new SearchState(state.mInputPosition, i, editCost, bestCompletionCost));
                }
                ++i;
            }
            double editCost = state.mEditCost + this.mEditDistance.deleteWeight(c);
            double score = editCost + (bestCompletionCost = (double)this.mPhraseLog2Probs[this.mOutcomes[this.mFirstOutcome[state.mTrieNode]]]);
            if (!(score >= this.mMinScore) || results.dominate(score)) continue;
            queue.offer(new SearchState(state.mInputPosition + 1, state.mTrieNode, editCost, bestCompletionCost));
        }
        return results;
    }

    boolean dominated(double score, SortedSet<ScoredObject<String>> results) {
        return score < this.mMinScore || results.size() == this.mMaxResultsPerPrefix && results.last().score() >= score;
    }

    private Object writeReplace() {
        return new Serializer(this);
    }

    static int prefixMatchLength(String x, String y) {
        int len = java.lang.Math.min(x.length(), y.length());
        int i = 0;
        while (i < len) {
            if (x.charAt(i) != y.charAt(i)) {
                return i;
            }
            ++i;
        }
        return len;
    }

    static int maxLength(String[] xs) {
        int max = -1;
        String[] stringArray = xs;
        int n = xs.length;
        int n2 = 0;
        while (n2 < n) {
            String x = stringArray[n2];
            if (x.length() > max) {
                max = x.length();
            }
            ++n2;
        }
        return max;
    }

    static class Results
    extends AbstractSet<ScoredObject<String>>
    implements SortedSet<ScoredObject<String>> {
        private final String[] mResults;
        private final double[] mScores;
        private int mSize = 0;

        Results(int maxSize) {
            this.mResults = new String[maxSize];
            this.mScores = new double[maxSize];
        }

        public boolean dominate(double score) {
            return this.full() && this.mScores[this.mSize - 1] >= score;
        }

        public void add(String s, double score) {
            int i = 0;
            while (i < this.mSize) {
                if (score > this.mScores[i]) {
                    this.tamp(i, s);
                    this.mScores[i] = score;
                    this.mResults[i] = s;
                    return;
                }
                if (this.mResults[i].equals(s)) {
                    return;
                }
                ++i;
            }
            if (this.mSize < this.mResults.length) {
                this.mResults[this.mSize] = s;
                this.mScores[this.mSize] = score;
                ++this.mSize;
            }
        }

        void tamp(int i, String s) {
            int n;
            int pos = i;
            while (pos < this.mSize) {
                if (this.mResults[pos].equals(s)) {
                    while (++pos < this.mSize) {
                        this.mResults[pos - 1] = this.mResults[pos];
                        this.mScores[pos - 1] = this.mScores[pos];
                    }
                    return;
                }
                ++pos;
            }
            if (this.mSize < this.mResults.length) {
                int n2 = this.mSize;
                n = n2;
                this.mSize = n2 + 1;
            } else {
                n = this.mSize - 1;
            }
            pos = n;
            while (--pos >= i) {
                this.mResults[pos + 1] = this.mResults[pos];
                this.mScores[pos + 1] = this.mScores[pos];
            }
        }

        public boolean full() {
            return this.mSize == this.mResults.length;
        }

        @Override
        public int size() {
            return this.mSize;
        }

        @Override
        public ScoredObject<String> first() {
            if (this.mSize == 0) {
                throw new NoSuchElementException();
            }
            return new ScoredObject<String>(this.mResults[0], this.mScores[0]);
        }

        @Override
        public ScoredObject<String> last() {
            if (this.mSize == 0) {
                throw new NoSuchElementException();
            }
            return new ScoredObject<String>(this.mResults[this.mSize - 1], this.mScores[this.mSize - 1]);
        }

        @Override
        public SortedSet<ScoredObject<String>> headSet(ScoredObject<String> from) {
            return null;
        }

        @Override
        public SortedSet<ScoredObject<String>> tailSet(ScoredObject<String> from) {
            return null;
        }

        @Override
        public SortedSet<ScoredObject<String>> subSet(ScoredObject<String> from, ScoredObject<String> to) {
            return null;
        }

        @Override
        public Comparator<ScoredObject<String>> comparator() {
            return ScoredObject.reverseComparator();
        }

        @Override
        public Iterator<ScoredObject<String>> iterator() {
            return new ResultsIterator();
        }

        class ResultsIterator
        implements Iterator<ScoredObject<String>> {
            int mPosition = 0;

            ResultsIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.mPosition < Results.this.mSize;
            }

            @Override
            public ScoredObject<String> next() {
                ++this.mPosition;
                return new ScoredObject<String>(Results.this.mResults[this.mPosition - 1], Results.this.mScores[this.mPosition - 1]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class SearchState
    implements Scored {
        final int mInputPosition;
        final int mTrieNode;
        final double mEditCost;
        final double mScore;

        SearchState(int inputPosition, int trieNode, double editCost, double bestCompletionCost) {
            this.mInputPosition = inputPosition;
            this.mTrieNode = trieNode;
            this.mEditCost = editCost;
            this.mScore = editCost + bestCompletionCost;
        }

        @Override
        public double score() {
            return this.mScore;
        }
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 2403836255870648306L;
        final AutoCompleter mAutoCompleter;

        public Serializer() {
            this(null);
        }

        public Serializer(AutoCompleter autoCompleter) {
            this.mAutoCompleter = autoCompleter;
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeObject(this.mAutoCompleter.mEditDistance);
            objOut.writeInt(this.mAutoCompleter.mMaxResultsPerPrefix);
            objOut.writeInt(this.mAutoCompleter.mMaxSearchQueueSize);
            objOut.writeInt(this.mAutoCompleter.mPhrases.length);
            int i = 0;
            while (i < this.mAutoCompleter.mPhrases.length) {
                objOut.writeUTF(this.mAutoCompleter.mPhrases[i]);
                objOut.writeFloat((float)(this.mAutoCompleter.mTotalCount * java.lang.Math.pow(2.0, this.mAutoCompleter.mPhraseLog2Probs[i])));
                ++i;
            }
            objOut.writeDouble(this.mAutoCompleter.mMinScore);
        }

        @Override
        public Object read(ObjectInput objIn) throws ClassNotFoundException, IOException {
            WeightedEditDistance editDistance = (WeightedEditDistance)objIn.readObject();
            int maxResultsPerPrefix = objIn.readInt();
            int maxSearchQueueSize = objIn.readInt();
            int numPhrases = objIn.readInt();
            HashMap<String, Float> phraseCountMap = new HashMap<String, Float>(numPhrases * 3 / 2);
            int i = 0;
            while (i < numPhrases) {
                String phrase = objIn.readUTF();
                float count = objIn.readFloat();
                phraseCountMap.put(phrase, Float.valueOf(count));
                ++i;
            }
            double minScore = objIn.readDouble();
            return new AutoCompleter(phraseCountMap, editDistance, maxResultsPerPrefix, maxSearchQueueSize, minScore);
        }
    }
}

